/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.core;

import tools.jackson.core.JsonPointer;
import tools.jackson.core.TokenStreamLocation;
import tools.jackson.core.io.CharTypes;
import tools.jackson.core.io.ContentReference;

public abstract class TokenStreamContext {
    public static final int TYPE_ROOT = 0;
    public static final int TYPE_ARRAY = 1;
    public static final int TYPE_OBJECT = 2;
    protected int _type;
    protected int _index;
    protected int _nestingDepth;

    protected TokenStreamContext() {
    }

    protected TokenStreamContext(TokenStreamContext base) {
        this._type = base._type;
        this._index = base._index;
    }

    protected TokenStreamContext(int type, int index) {
        this._type = type;
        this._index = index;
    }

    public abstract TokenStreamContext getParent();

    public final boolean inArray() {
        return this._type == 1;
    }

    public final boolean inRoot() {
        return this._type == 0;
    }

    public final boolean inObject() {
        return this._type == 2;
    }

    public final int getNestingDepth() {
        return this._nestingDepth;
    }

    public String typeDesc() {
        switch (this._type) {
            case 0: {
                return "root";
            }
            case 1: {
                return "Array";
            }
            case 2: {
                return "Object";
            }
        }
        return "?";
    }

    public final int getEntryCount() {
        return this._index + 1;
    }

    public final int getCurrentIndex() {
        return this._index < 0 ? 0 : this._index;
    }

    public boolean hasCurrentIndex() {
        return this._index >= 0;
    }

    public boolean hasPathSegment() {
        if (this._type == 2) {
            return this.hasCurrentName();
        }
        if (this._type == 1) {
            return this.hasCurrentIndex();
        }
        return false;
    }

    public abstract String currentName();

    public boolean hasCurrentName() {
        return this.currentName() != null;
    }

    public Object currentValue() {
        return null;
    }

    public void assignCurrentValue(Object v) {
    }

    public JsonPointer pathAsPointer() {
        return JsonPointer.forPath(this, false);
    }

    public JsonPointer pathAsPointer(boolean includeRoot) {
        return JsonPointer.forPath(this, includeRoot);
    }

    public TokenStreamLocation startLocation(ContentReference srcRef) {
        return TokenStreamLocation.NA;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        switch (this._type) {
            case 0: {
                sb.append("/");
                break;
            }
            case 1: {
                sb.append('[');
                sb.append(this.getCurrentIndex());
                sb.append(']');
                break;
            }
            default: {
                sb.append('{');
                String currentName = this.currentName();
                if (currentName != null) {
                    sb.append('\"');
                    CharTypes.appendQuoted(sb, currentName);
                    sb.append('\"');
                } else {
                    sb.append('?');
                }
                sb.append('}');
            }
        }
        return sb.toString();
    }
}

