/*
 * Decompiled with CFR 0.152.
 */
package androidx.compose.ui.graphics.vector;

import androidx.compose.runtime.internal.StabilityInferred;
import androidx.compose.ui.graphics.Brush;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.Matrix;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.SkiaBackedPath_skikoKt;
import androidx.compose.ui.graphics.SolidColor;
import androidx.compose.ui.graphics.drawscope.DrawContext;
import androidx.compose.ui.graphics.drawscope.DrawScope;
import androidx.compose.ui.graphics.drawscope.DrawTransform;
import androidx.compose.ui.graphics.vector.PathComponent;
import androidx.compose.ui.graphics.vector.PathNode;
import androidx.compose.ui.graphics.vector.PathParserKt;
import androidx.compose.ui.graphics.vector.VNode;
import androidx.compose.ui.graphics.vector.VectorKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\u0017\u0010\u0016\u001a\u00020\u00132\u0006\u0010\u0017\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u0010\u0010\u001a\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u0001H\u0002J\b\u0010\u001c\u001a\u00020\u0013H\u0002J\b\u00100\u001a\u00020\u0013H\u0002J\b\u0010T\u001a\u00020\u0013H\u0002J\u0016\u0010U\u001a\u00020\u00132\u0006\u0010V\u001a\u00020P2\u0006\u0010W\u001a\u00020\u0001J\u001e\u0010X\u001a\u00020\u00132\u0006\u0010Y\u001a\u00020P2\u0006\u0010Z\u001a\u00020P2\u0006\u0010[\u001a\u00020PJ\u0016\u0010\\\u001a\u00020\u00132\u0006\u0010V\u001a\u00020P2\u0006\u0010[\u001a\u00020PJ\f\u0010]\u001a\u00020\u0013*\u00020^H\u0016J\b\u0010_\u001a\u000201H\u0016R\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR \u0010\u000e\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r@BX\u0086\u000e\u00a2\u0006\n\n\u0002\u0010\u0011\u001a\u0004\b\u000f\u0010\u0010R0\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b%\u0010\fR\u000e\u0010&\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010'\u001a\u0004\u0018\u00010(X\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010)\u001a\u0010\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u0013\u0018\u00010*X\u0090\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001a\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00130*X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u00102\u001a\u0002012\u0006\u0010\t\u001a\u000201@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R$\u00108\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R$\u0010=\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010:\"\u0004\b?\u0010<R$\u0010@\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bA\u0010:\"\u0004\bB\u0010<R$\u0010C\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bD\u0010:\"\u0004\bE\u0010<R$\u0010F\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bG\u0010:\"\u0004\bH\u0010<R$\u0010I\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bJ\u0010:\"\u0004\bK\u0010<R$\u0010L\u001a\u0002072\u0006\u0010\t\u001a\u000207@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bM\u0010:\"\u0004\bN\u0010<R\u0011\u0010O\u001a\u00020P8F\u00a2\u0006\u0006\u001a\u0004\bQ\u0010RR\u000e\u0010S\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006`"}, d2={"Landroidx/compose/ui/graphics/vector/GroupComponent;", "Landroidx/compose/ui/graphics/vector/VNode;", "<init>", "()V", "groupMatrix", "Landroidx/compose/ui/graphics/Matrix;", "[F", "children", "", "value", "", "isTintable", "()Z", "Landroidx/compose/ui/graphics/Color;", "tintColor", "getTintColor-0d7_KjU", "()J", "J", "markTintForBrush", "", "brush", "Landroidx/compose/ui/graphics/Brush;", "markTintForColor", "color", "markTintForColor-8_81llA", "(J)V", "markTintForVNode", "node", "markNotTintable", "", "Landroidx/compose/ui/graphics/vector/PathNode;", "clipPathData", "getClipPathData", "()Ljava/util/List;", "setClipPathData", "(Ljava/util/List;)V", "willClipPath", "getWillClipPath", "isClipPathDirty", "clipPath", "Landroidx/compose/ui/graphics/Path;", "invalidateListener", "Lkotlin/Function1;", "getInvalidateListener$ui", "()Lkotlin/jvm/functions/Function1;", "setInvalidateListener$ui", "(Lkotlin/jvm/functions/Function1;)V", "wrappedListener", "updateClipPath", "", "name", "getName", "()Ljava/lang/String;", "setName", "(Ljava/lang/String;)V", "", "rotation", "getRotation", "()F", "setRotation", "(F)V", "pivotX", "getPivotX", "setPivotX", "pivotY", "getPivotY", "setPivotY", "scaleX", "getScaleX", "setScaleX", "scaleY", "getScaleY", "setScaleY", "translationX", "getTranslationX", "setTranslationX", "translationY", "getTranslationY", "setTranslationY", "numChildren", "", "getNumChildren", "()I", "isMatrixDirty", "updateMatrix", "insertAt", "index", "instance", "move", "from", "to", "count", "remove", "draw", "Landroidx/compose/ui/graphics/drawscope/DrawScope;", "toString", "ui"})
@StabilityInferred(parameters=0)
@SourceDebugExtension(value={"SMAP\nVector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/GroupComponent\n+ 2 Color.kt\nandroidx/compose/ui/graphics/ColorKt\n+ 3 DrawScope.kt\nandroidx/compose/ui/graphics/drawscope/DrawScopeKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 ListUtils.kt\nandroidx/compose/ui/util/ListUtilsKt\n*L\n1#1,659:1\n635#2:660\n640#2:661\n249#3,8:662\n257#3:671\n259#3,4:677\n1#4:670\n35#5,5:672\n35#5,5:681\n*S KotlinDebug\n*F\n+ 1 Vector.kt\nandroidx/compose/ui/graphics/vector/GroupComponent\n*L\n423#1:660\n424#1:661\n622#1:662,8\n622#1:671\n622#1:677,4\n629#1:672,5\n635#1:681,5\n*E\n"})
public final class GroupComponent
extends VNode {
    @Nullable
    private float[] groupMatrix;
    @NotNull
    private final List<VNode> children = new ArrayList();
    private boolean isTintable = true;
    private long tintColor = Color.Companion.getUnspecified-0d7_KjU();
    @NotNull
    private List<? extends PathNode> clipPathData = VectorKt.getEmptyPath();
    private boolean isClipPathDirty = true;
    @Nullable
    private Path clipPath;
    @Nullable
    private Function1<? super VNode, Unit> invalidateListener;
    @NotNull
    private final Function1<VNode, Unit> wrappedListener = arg_0 -> GroupComponent.wrappedListener$lambda$0(this, arg_0);
    @NotNull
    private String name = "";
    private float rotation;
    private float pivotX;
    private float pivotY;
    private float scaleX = 1.0f;
    private float scaleY = 1.0f;
    private float translationX;
    private float translationY;
    private boolean isMatrixDirty = true;
    public static final int $stable = 8;

    public GroupComponent() {
        super(null);
    }

    public final boolean isTintable() {
        return this.isTintable;
    }

    public final long getTintColor-0d7_KjU() {
        return this.tintColor;
    }

    private final void markTintForBrush(Brush brush) {
        if (!this.isTintable) {
            return;
        }
        if (brush != null) {
            if (brush instanceof SolidColor) {
                this.markTintForColor-8_81llA(((SolidColor)brush).getValue-0d7_KjU());
            } else {
                this.markNotTintable();
            }
        }
    }

    private final void markTintForColor-8_81llA(long l) {
        if (!this.isTintable) {
            return;
        }
        long l2 = l;
        boolean bl = false;
        if (l2 != 16L) {
            long l3 = this.tintColor;
            boolean bl2 = false;
            if (l3 == 16L) {
                this.tintColor = l;
            } else if (!VectorKt.rgbEqual--OWjLjI(this.tintColor, l)) {
                this.markNotTintable();
            }
        }
    }

    private final void markTintForVNode(VNode node2) {
        if (node2 instanceof PathComponent) {
            this.markTintForBrush(((PathComponent)node2).getFill());
            this.markTintForBrush(((PathComponent)node2).getStroke());
        } else if (node2 instanceof GroupComponent) {
            if (((GroupComponent)node2).isTintable && this.isTintable) {
                this.markTintForColor-8_81llA(((GroupComponent)node2).tintColor);
            } else {
                this.markNotTintable();
            }
        }
    }

    private final void markNotTintable() {
        this.isTintable = false;
        this.tintColor = Color.Companion.getUnspecified-0d7_KjU();
    }

    @NotNull
    public final List<PathNode> getClipPathData() {
        return this.clipPathData;
    }

    public final void setClipPathData(@NotNull List<? extends PathNode> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.clipPathData = value;
        this.isClipPathDirty = true;
        this.invalidate();
    }

    private final boolean getWillClipPath() {
        return !((Collection)this.clipPathData).isEmpty();
    }

    @Override
    @Nullable
    public Function1<VNode, Unit> getInvalidateListener$ui() {
        return this.invalidateListener;
    }

    @Override
    public void setInvalidateListener$ui(@Nullable Function1<? super VNode, Unit> function1) {
        this.invalidateListener = function1;
    }

    private final void updateClipPath() {
        if (this.getWillClipPath()) {
            Path targetClip = this.clipPath;
            if (targetClip == null) {
                this.clipPath = targetClip = SkiaBackedPath_skikoKt.Path();
            }
            PathParserKt.toPath(this.clipPathData, targetClip);
        }
    }

    @NotNull
    public final String getName() {
        return this.name;
    }

    public final void setName(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.name = value;
        this.invalidate();
    }

    public final float getRotation() {
        return this.rotation;
    }

    public final void setRotation(float value) {
        this.rotation = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getPivotX() {
        return this.pivotX;
    }

    public final void setPivotX(float value) {
        this.pivotX = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getPivotY() {
        return this.pivotY;
    }

    public final void setPivotY(float value) {
        this.pivotY = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getScaleX() {
        return this.scaleX;
    }

    public final void setScaleX(float value) {
        this.scaleX = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getScaleY() {
        return this.scaleY;
    }

    public final void setScaleY(float value) {
        this.scaleY = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getTranslationX() {
        return this.translationX;
    }

    public final void setTranslationX(float value) {
        this.translationX = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final float getTranslationY() {
        return this.translationY;
    }

    public final void setTranslationY(float value) {
        this.translationY = value;
        this.isMatrixDirty = true;
        this.invalidate();
    }

    public final int getNumChildren() {
        return this.children.size();
    }

    private final void updateMatrix() {
        float[] matrix = null;
        float[] target = this.groupMatrix;
        if (target == null) {
            this.groupMatrix = matrix = Matrix.constructor-impl$default(null, 1, null);
        } else {
            matrix = target;
            Matrix.reset-impl(matrix);
        }
        Matrix.translate-impl$default(matrix, this.translationX + this.pivotX, this.translationY + this.pivotY, 0.0f, 4, null);
        Matrix.rotateZ-impl(matrix, this.rotation);
        Matrix.scale-impl(matrix, this.scaleX, this.scaleY, 1.0f);
        Matrix.translate-impl$default(matrix, -this.pivotX, -this.pivotY, 0.0f, 4, null);
    }

    public final void insertAt(int index2, @NotNull VNode instance) {
        Intrinsics.checkNotNullParameter((Object)instance, (String)"instance");
        if (index2 < this.getNumChildren()) {
            this.children.set(index2, instance);
        } else {
            this.children.add(instance);
        }
        this.markTintForVNode(instance);
        instance.setInvalidateListener$ui(this.wrappedListener);
        this.invalidate();
    }

    public final void move(int from, int to, int count) {
        if (from > to) {
            int current = 0;
            current = to;
            int n = 0;
            while (n < count) {
                int it = n++;
                boolean bl = false;
                VNode node2 = this.children.get(from);
                this.children.remove(from);
                this.children.add(current, node2);
                ++current;
            }
        } else {
            int n = 0;
            while (n < count) {
                int it = n++;
                boolean bl = false;
                VNode node3 = this.children.get(from);
                this.children.remove(from);
                this.children.add(to - 1, node3);
            }
        }
        this.invalidate();
    }

    public final void remove(int index2, int count) {
        for (int i = 0; i < count; ++i) {
            int it = i;
            boolean bl = false;
            if (index2 >= this.children.size()) continue;
            this.children.get(index2).setInvalidateListener$ui(null);
            this.children.remove(index2);
        }
        this.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(@NotNull DrawScope $this$draw) {
        Intrinsics.checkNotNullParameter((Object)$this$draw, (String)"<this>");
        if (this.isMatrixDirty) {
            this.updateMatrix();
            this.isMatrixDirty = false;
        }
        if (this.isClipPathDirty) {
            this.updateClipPath();
            this.isClipPathDirty = false;
        }
        DrawScope $this$withTransform$iv = $this$draw;
        boolean $i$f$withTransform = false;
        DrawContext $this$withTransform_u24lambda_u240$iv = $this$withTransform$iv.getDrawContext();
        boolean bl = false;
        long previousSize$iv = $this$withTransform_u24lambda_u240$iv.getSize-NH-jbRc();
        $this$withTransform_u24lambda_u240$iv.getCanvas().save();
        try {
            DrawTransform $this$draw_u24lambda_u240 = $this$withTransform_u24lambda_u240$iv.getTransform();
            boolean bl2 = false;
            if (this.groupMatrix != null) {
                float[] it = (this.groupMatrix != null ? Matrix.box-impl(this.groupMatrix) : null).unbox-impl();
                boolean bl3 = false;
                $this$draw_u24lambda_u240.transform-58bKbWc(it);
            }
            Path targetClip = this.clipPath;
            if (this.getWillClipPath() && targetClip != null) {
                DrawTransform.clipPath-mtrdD-E$default($this$draw_u24lambda_u240, targetClip, 0, 2, null);
            }
            DrawScope $this$draw_u24lambda_u241 = $this$withTransform$iv;
            boolean bl4 = false;
            List<VNode> $this$fastForEach$iv = this.children;
            boolean $i$f$fastForEach = false;
            int n = ((Collection)$this$fastForEach$iv).size();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                VNode item$iv;
                VNode node2 = item$iv = $this$fastForEach$iv.get(index$iv);
                boolean bl5 = false;
                VNode $this$draw_u24lambda_u241_u240_u240 = node2;
                boolean bl6 = false;
                $this$draw_u24lambda_u241_u240_u240.draw($this$draw);
            }
        }
        finally {
            $this$withTransform_u24lambda_u240$iv.getCanvas().restore();
            $this$withTransform_u24lambda_u240$iv.setSize-uvyYCjk(previousSize$iv);
        }
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder().append("VGroup: ").append(this.name);
        List<VNode> $this$fastForEach$iv = this.children;
        boolean $i$f$fastForEach = false;
        int n = ((Collection)$this$fastForEach$iv).size();
        for (int index$iv = 0; index$iv < n; ++index$iv) {
            VNode item$iv;
            VNode node2 = item$iv = $this$fastForEach$iv.get(index$iv);
            boolean bl = false;
            sb.append("\t").append(node2.toString()).append("\n");
        }
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private static final Unit wrappedListener$lambda$0(GroupComponent this$0, VNode node2) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)node2, (String)"node");
            this$0.markTintForVNode(node2);
            Function1<VNode, Unit> function1 = this$0.getInvalidateListener$ui();
            if (function1 == null) break block0;
            function1.invoke((Object)node2);
        }
        return Unit.INSTANCE;
    }
}

