/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.python.codeInsight.typing;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.vfs.StandardFileSystems;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.util.QualifiedName;
import com.intellij.python.community.helpersLocator.PythonHelpersLocator;
import com.jetbrains.python.PythonRuntimeService;
import com.jetbrains.python.psi.LanguageLevel;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0015\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0014\u001a\u00020\u0015J\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0019\u001a\u00020\bJ\u0014\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00130\u00172\u0006\u0010\u0019\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0013J\u000e\u0010(\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0013J\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u0013J\u0010\u0010*\u001a\u0004\u0018\u00010\u00132\u0006\u0010+\u001a\u00020\u0006R(\u0010\u0004\u001a\u001c\u0012\u0004\u0012\u00020\u0006\u0012\u0012\u0012\u0010\u0012\u0004\u0012\u00020\b\u0012\u0006\u0012\u0004\u0018\u00010\b0\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001d\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u001d\u0010\u001d\u001a\u0004\u0018\u00010\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b \u0010!\u001a\u0004\b\u001e\u0010\u001fR\u001d\u0010\"\u001a\u0004\u0018\u00010\u00138FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b$\u0010!\u001a\u0004\b#\u0010\u001fR\u0016\u0010%\u001a\u0004\u0018\u00010\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006,"}, d2={"Lcom/jetbrains/python/codeInsight/typing/PyTypeShed;", "", "<init>", "()V", "stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels", "", "", "Lkotlin/Pair;", "Lcom/jetbrains/python/psi/LanguageLevel;", "typingRedirections", "getTypingRedirections", "()Ljava/util/Map;", "typeshedModuleRedirections", "getTypeshedModuleRedirections", "maySearchForStubInRoot", "", "name", "Lcom/intellij/psi/util/QualifiedName;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "findStdlibRootsForSdk", "", "findStdlibRootsForLanguageLevel", "level", "findAllRootsForLanguageLevel", "isInside", "file", "directory", "getDirectory", "()Lcom/intellij/openapi/vfs/VirtualFile;", "directory$delegate", "Lkotlin/Lazy;", "thirdPartyStubRoot", "getThirdPartyStubRoot", "thirdPartyStubRoot$delegate", "directoryPath", "getDirectoryPath", "()Ljava/lang/String;", "isInThirdPartyLibraries", "isInStandardLibrary", "getStubRootForPackage", "packageName", "intellij.python.psi.impl"})
public final class PyTypeShed {
    @NotNull
    public static final PyTypeShed INSTANCE = new PyTypeShed();
    @NotNull
    private static final Map<String, Pair<LanguageLevel, LanguageLevel>> stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels;
    @NotNull
    private static final Map<String, String> typingRedirections;
    @NotNull
    private static final Map<String, String> typeshedModuleRedirections;
    @NotNull
    private static final Lazy directory$delegate;
    @NotNull
    private static final Lazy thirdPartyStubRoot$delegate;

    private PyTypeShed() {
    }

    @NotNull
    public final Map<String, String> getTypingRedirections() {
        return typingRedirections;
    }

    @NotNull
    public final Map<String, String> getTypeshedModuleRedirections() {
        return typeshedModuleRedirections;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean maySearchForStubInRoot(@NotNull QualifiedName name2, @NotNull VirtualFile root, @NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)name2, (String)"name");
        Intrinsics.checkNotNullParameter((Object)root, (String)"root");
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        if (!this.isInStandardLibrary(root)) return this.isInThirdPartyLibraries(root);
        String string = name2.getFirstComponent();
        if (string == null) {
            return true;
        }
        String head = string;
        Pair<LanguageLevel, LanguageLevel> pair = stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels.get(head);
        if (pair == null) {
            return true;
        }
        Pair<LanguageLevel, LanguageLevel> languageLevels = pair;
        LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"getLanguageLevelForSdk(...)");
        LanguageLevel currentLanguageLevel = languageLevel;
        if (!currentLanguageLevel.isAtLeast((LanguageLevel)((Object)languageLevels.getFirst()))) return false;
        LanguageLevel it = (LanguageLevel)((Object)languageLevels.getSecond());
        boolean bl = false;
        if (it == null) return true;
        if (!it.isAtLeast(currentLanguageLevel)) return false;
        return true;
    }

    @NotNull
    public final List<VirtualFile> findStdlibRootsForSdk(@NotNull Sdk sdk2) {
        Intrinsics.checkNotNullParameter((Object)sdk2, (String)"sdk");
        LanguageLevel languageLevel = PythonRuntimeService.getInstance().getLanguageLevelForSdk(sdk2);
        Intrinsics.checkNotNullExpressionValue((Object)((Object)languageLevel), (String)"getLanguageLevelForSdk(...)");
        LanguageLevel level = languageLevel;
        return this.findStdlibRootsForLanguageLevel(level);
    }

    @NotNull
    public final List<VirtualFile> findStdlibRootsForLanguageLevel(@NotNull LanguageLevel level) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        VirtualFile virtualFile = this.getDirectory();
        if (virtualFile == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile dir = virtualFile;
        VirtualFile virtualFile2 = dir.findChild("stdlib");
        if (virtualFile2 == null) {
            return CollectionsKt.emptyList();
        }
        VirtualFile stdlib = virtualFile2;
        if (level.isPython2()) {
            Object[] objectArray = new VirtualFile[]{stdlib.findChild("@python2"), stdlib};
            list = CollectionsKt.listOfNotNull((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)stdlib);
        }
        return list;
    }

    @NotNull
    public final List<VirtualFile> findAllRootsForLanguageLevel(@NotNull LanguageLevel level) {
        List list;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Collection collection = this.findStdlibRootsForLanguageLevel(level);
        Object[] objectArray = this.getThirdPartyStubRoot();
        if ((objectArray != null && (objectArray = objectArray.getChildren()) != null ? ArraysKt.toList((Object[])objectArray) : (list = null)) == null) {
            list = CollectionsKt.emptyList();
        }
        return CollectionsKt.plus((Collection)collection, (Iterable)list);
    }

    public final boolean isInside(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile dir = this.getDirectory();
        return dir != null && VfsUtilCore.isAncestor((VirtualFile)dir, (VirtualFile)file, (boolean)true);
    }

    @Nullable
    public final VirtualFile getDirectory() {
        Lazy lazy = directory$delegate;
        return (VirtualFile)lazy.getValue();
    }

    @Nullable
    public final VirtualFile getThirdPartyStubRoot() {
        Lazy lazy = thirdPartyStubRoot$delegate;
        return (VirtualFile)lazy.getValue();
    }

    private final String getDirectoryPath() {
        Object[] objectArray = new String[]{PathManager.getConfigPath() + "/typeshed", PathManager.getConfigPath() + "/../typeshed", PythonHelpersLocator.Companion.findPathStringInHelpers("typeshed")};
        List paths = CollectionsKt.listOf((Object[])objectArray);
        return (String)SequencesKt.firstOrNull((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)paths), PyTypeShed::_get_directoryPath_$lambda$3));
    }

    public final boolean isInThirdPartyLibraries(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"stubs", (boolean)false, (int)2, null);
    }

    public final boolean isInStandardLibrary(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        String string = file.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return StringsKt.contains$default((CharSequence)string, (CharSequence)"stdlib", (boolean)false, (int)2, null);
    }

    @Nullable
    public final VirtualFile getStubRootForPackage(@NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        VirtualFile virtualFile = this.getThirdPartyStubRoot();
        return virtualFile != null ? virtualFile.findChild(packageName) : null;
    }

    private static final VirtualFile directory_delegate$lambda$1() {
        String string = INSTANCE.getDirectoryPath();
        if (string == null) {
            return null;
        }
        String path2 = string;
        return StandardFileSystems.local().findFileByPath(path2);
    }

    private static final VirtualFile thirdPartyStubRoot_delegate$lambda$2() {
        VirtualFile virtualFile = INSTANCE.getDirectory();
        return virtualFile != null ? virtualFile.findChild("stubs") : null;
    }

    private static final boolean _get_directoryPath_$lambda$3(String it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return new File(it).exists();
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"_bootlocale", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON36), (Object)((Object)LanguageLevel.PYTHON39))), TuplesKt.to((Object)"_dummy_thread", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON36), (Object)((Object)LanguageLevel.PYTHON38))), TuplesKt.to((Object)"_dummy_threading", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON38))), TuplesKt.to((Object)"_interpchannels", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON313), null)), TuplesKt.to((Object)"_interpqueues", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON313), null)), TuplesKt.to((Object)"_interpreters", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON313), null)), TuplesKt.to((Object)"_py_abc", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON37), null)), TuplesKt.to((Object)"aifc", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"asynchat", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON311))), TuplesKt.to((Object)"asyncio.exceptions", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON38), null)), TuplesKt.to((Object)"asyncio.format_helpers", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON37), null)), TuplesKt.to((Object)"asyncio.mixins", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON310), null)), TuplesKt.to((Object)"asyncio.runners", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON37), null)), TuplesKt.to((Object)"asyncio.staggered", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON38), null)), TuplesKt.to((Object)"asyncio.taskgroups", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"asyncio.threads", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON39), null)), TuplesKt.to((Object)"asyncio.timeouts", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"asyncio.trsock", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON38), null)), TuplesKt.to((Object)"asyncore", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON311))), TuplesKt.to((Object)"audioop", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"binhex", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON310))), TuplesKt.to((Object)"cgi", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"cgitb", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"chunk", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"contextvars", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON37), null)), TuplesKt.to((Object)"crypt", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"dataclasses", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON37), null)), TuplesKt.to((Object)"dbm.sqlite3", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON313), null)), TuplesKt.to((Object)"distutils", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON311))), TuplesKt.to((Object)"distutils.command.bdist_msi", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON310))), TuplesKt.to((Object)"distutils.command.bdist_wininst", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON39))), TuplesKt.to((Object)"dummy_threading", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON38))), TuplesKt.to((Object)"formatter", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON39))), TuplesKt.to((Object)"graphlib", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON39), null)), TuplesKt.to((Object)"imghdr", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"imp", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON311))), TuplesKt.to((Object)"importlib._abc", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON310), null)), TuplesKt.to((Object)"importlib.metadata", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON38), null)), TuplesKt.to((Object)"importlib.metadata._meta", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON310), null)), TuplesKt.to((Object)"importlib.metadata.diagnose", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON313), null)), TuplesKt.to((Object)"importlib.readers", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON310), null)), TuplesKt.to((Object)"importlib.resources", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON37), null)), TuplesKt.to((Object)"importlib.resources.abc", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"importlib.resources.readers", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"importlib.resources.simple", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"importlib.simple", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"lib2to3", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"mailcap", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"msilib", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"multiprocessing.resource_tracker", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON38), null)), TuplesKt.to((Object)"multiprocessing.shared_memory", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON38), null)), TuplesKt.to((Object)"nis", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"nntplib", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"ossaudiodev", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"parser", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON39))), TuplesKt.to((Object)"pipes", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"smtpd", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON311))), TuplesKt.to((Object)"sndhdr", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"spwd", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"sunau", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"symbol", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON27), (Object)((Object)LanguageLevel.PYTHON39))), TuplesKt.to((Object)"sys._monitoring", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON312), null)), TuplesKt.to((Object)"telnetlib", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"tkinter.tix", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"tomllib", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"unittest._log", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON39), null)), TuplesKt.to((Object)"unittest.async_case", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON38), null)), TuplesKt.to((Object)"uu", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"wsgiref.types", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON311), null)), TuplesKt.to((Object)"xdrlib", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON30), (Object)((Object)LanguageLevel.PYTHON312))), TuplesKt.to((Object)"zipfile._path", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON312), null)), TuplesKt.to((Object)"zoneinfo", (Object)TuplesKt.to((Object)((Object)LanguageLevel.PYTHON39), null))};
        stdlibNamesAvailableOnlyInSubsetOfSupportedLanguageLevels = MapsKt.mapOf((Pair[])pairArray);
        pairArray = new Pair[]{TuplesKt.to((Object)"typing.Hashable", (Object)"_collections_abc.Hashable"), TuplesKt.to((Object)"typing.Awaitable", (Object)"_collections_abc.Awaitable"), TuplesKt.to((Object)"typing.Coroutine", (Object)"_collections_abc.Coroutine"), TuplesKt.to((Object)"typing.AsyncIterable", (Object)"_collections_abc.AsyncIterable"), TuplesKt.to((Object)"typing.AsyncIterator", (Object)"_collections_abc.AsyncIterator"), TuplesKt.to((Object)"typing.Iterable", (Object)"_collections_abc.Iterable"), TuplesKt.to((Object)"typing.Iterator", (Object)"_collections_abc.Iterator"), TuplesKt.to((Object)"typing.Reversible", (Object)"_collections_abc.Reversible"), TuplesKt.to((Object)"typing.Sized", (Object)"_collections_abc.Sized"), TuplesKt.to((Object)"typing.Container", (Object)"_collections_abc.Container"), TuplesKt.to((Object)"typing.Collection", (Object)"_collections_abc.Collection"), TuplesKt.to((Object)"typing.Callable", (Object)"_collections_abc.Callable"), TuplesKt.to((Object)"typing.AbstractSet", (Object)"_collections_abc.Set"), TuplesKt.to((Object)"typing.MutableSet", (Object)"_collections_abc.MutableSet"), TuplesKt.to((Object)"typing.Mapping", (Object)"_collections_abc.Mapping"), TuplesKt.to((Object)"typing.MutableMapping", (Object)"_collections_abc.MutableMapping"), TuplesKt.to((Object)"typing.Sequence", (Object)"_collections_abc.Sequence"), TuplesKt.to((Object)"typing.MutableSequence", (Object)"_collections_abc.MutableSequence"), TuplesKt.to((Object)"typing.ByteString", (Object)"_collections_abc.ByteString"), TuplesKt.to((Object)"typing.Deque", (Object)"_collections.deque"), TuplesKt.to((Object)"typing.MappingView", (Object)"_collections_abc.MappingView"), TuplesKt.to((Object)"typing.KeysView", (Object)"_collections_abc.KeysView"), TuplesKt.to((Object)"typing.ItemsView", (Object)"_collections_abc.ItemsView"), TuplesKt.to((Object)"typing.ValuesView", (Object)"_collections_abc.ValuesView"), TuplesKt.to((Object)"typing.DefaultDict", (Object)"_collections.defaultdict"), TuplesKt.to((Object)"typing.Generator", (Object)"_collections_abc.Generator"), TuplesKt.to((Object)"typing.AsyncGenerator", (Object)"_collections_abc.AsyncGenerator")};
        typingRedirections = MapsKt.mapOf((Pair[])pairArray);
        typeshedModuleRedirections = MapsKt.mapOf((Pair)TuplesKt.to((Object)"collections.abc", (Object)"_collections_abc"));
        directory$delegate = LazyKt.lazy(PyTypeShed::directory_delegate$lambda$1);
        thirdPartyStubRoot$delegate = LazyKt.lazy(PyTypeShed::thirdPartyStubRoot_delegate$lambda$2);
    }
}

