/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.selection;

import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridListener;
import com.intellij.database.datagrid.GridModel;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.Index;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.datagrid.ModelIndexSet;
import com.intellij.database.datagrid.ResultView;
import com.intellij.database.datagrid.ViewIndex;
import com.intellij.database.datagrid.ViewIndexSet;
import com.intellij.database.run.ui.DataAccessType;
import com.intellij.database.run.ui.grid.editors.GridCellEditorHelper;
import com.intellij.database.run.ui.grid.selection.GridSelectionTracker;
import com.intellij.util.containers.Stack;
import java.util.Collection;
import java.util.OptionalInt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GridSelectionTrackerImpl
implements GridSelectionTracker {
    private final Stack<ModelIndex<GridRow>> myRows;
    private final DataGrid myGrid;
    private boolean myAdjusting;

    public GridSelectionTrackerImpl(@NotNull DataGrid grid, @NotNull ResultView view) {
        if (grid == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(0);
        }
        if (view == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(1);
        }
        this.myGrid = grid;
        this.myRows = new Stack();
        this.myGrid.addDataGridListener(new DataGridListener(){

            @Override
            public void onSelectionChanged(DataGrid dataGrid) {
                if (GridSelectionTrackerImpl.this.myAdjusting) {
                    return;
                }
                GridSelectionTrackerImpl.this.myRows.clear();
            }
        }, view);
    }

    public void performOperation(@NotNull GridSelectionTracker.Operation operation) {
        if (operation == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(2);
        }
        if (!this.checkAndFillStack(operation)) {
            return;
        }
        operation.perform((GridSelectionTracker)this);
        this.updateSelection();
    }

    public boolean canPerformOperation(@NotNull GridSelectionTracker.Operation operation) {
        if (operation == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(3);
        }
        return operation.checkStackSize(this.myRows.size()) || operation.checkSelectedRowsCount(this.myGrid.getSelectionModel().getSelectedRowCount()) && operation.checkSelectedColumnsCount(this.myGrid.getSelectionModel().getSelectedColumnCount()) && this.checkRowEquality();
    }

    private boolean checkAndFillStack(@NotNull GridSelectionTracker.Operation operation) {
        if (operation == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(4);
        }
        if (!this.canPerformOperation(operation)) {
            return false;
        }
        if (this.myRows.isEmpty()) {
            this.myRows.addAll((Collection)this.myGrid.getSelectionModel().getSelectedRows().asList());
        }
        return true;
    }

    private void updateSelection() {
        this.run(() -> this.myGrid.getSelectionModel().setRowSelection(this.getRows(), false));
    }

    @NotNull
    private ModelIndexSet<GridRow> getRows() {
        int[] rows = this.myRows.stream().filter(idx -> idx.isValid((CoreGrid)this.myGrid)).mapToInt(Index::asInteger).toArray();
        ModelIndexSet modelIndexSet = ModelIndexSet.forRows((CoreGrid)this.myGrid, (int[])rows);
        if (modelIndexSet == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(5);
        }
        return modelIndexSet;
    }

    @Nullable
    private ModelIndex<GridRow> findNext(@NotNull ViewIndex<GridRow> stopRow) {
        if (stopRow == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(6);
        }
        ViewIndex<GridRow> startRow = this.getLastRow();
        ViewIndex next = ViewIndex.forRow((CoreGrid)this.myGrid, (int)this.next(startRow.asInteger()));
        ModelIndex startRowModelIdx = startRow.toModel((CoreGrid)this.myGrid);
        while (next.asInteger() != startRow.asInteger()) {
            if (stopRow.asInteger() == next.asInteger()) {
                return null;
            }
            ModelIndex nextModelIdx = next.toModel((CoreGrid)this.myGrid);
            boolean isValid = next.isValid((CoreGrid)this.myGrid);
            boolean isNotSelectedRow = !this.myGrid.getSelectionModel().isSelectedRow(nextModelIdx);
            boolean isNotInStack = !this.myRows.contains((Object)nextModelIdx);
            boolean valuesAreEqual = this.rowEquals((ModelIndex<GridRow>)startRowModelIdx, (ModelIndex<GridRow>)nextModelIdx);
            if (isNotInStack && isValid && isNotSelectedRow && valuesAreEqual) {
                return nextModelIdx;
            }
            next = ViewIndex.forRow((CoreGrid)this.myGrid, (int)this.next(next.asInteger()));
        }
        return null;
    }

    @NotNull
    private ViewIndex<GridRow> getLastRow() {
        if (!this.myRows.isEmpty()) {
            ViewIndex viewIndex = ((ModelIndex)this.myRows.peek()).toView((CoreGrid)this.myGrid);
            if (viewIndex == null) {
                GridSelectionTrackerImpl.$$$reportNull$$$0(7);
            }
            return viewIndex;
        }
        ViewIndexSet rows = this.myGrid.getSelectionModel().getSelectedRows().toView((CoreGrid)this.myGrid);
        OptionalInt max = rows.asList().stream().mapToInt(Index::asInteger).max();
        if (max.isEmpty()) {
            ViewIndex viewIndex = ViewIndex.forRow((CoreGrid)this.myGrid, (int)0);
            if (viewIndex == null) {
                GridSelectionTrackerImpl.$$$reportNull$$$0(8);
            }
            return viewIndex;
        }
        ViewIndex viewIndex = ViewIndex.forRow((CoreGrid)this.myGrid, (int)max.getAsInt());
        if (viewIndex == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(9);
        }
        return viewIndex;
    }

    private boolean checkRowEquality() {
        ModelIndexSet rows = this.myGrid.getSelectionModel().getSelectedRows();
        ModelIndex previous = (ModelIndex)rows.first();
        for (ModelIndex rowIdx : rows.asIterable()) {
            if (this.rowEquals((ModelIndex<GridRow>)rowIdx, (ModelIndex<GridRow>)previous)) continue;
            return false;
        }
        return true;
    }

    private boolean rowEquals(@NotNull ModelIndex<GridRow> first, @NotNull ModelIndex<GridRow> second) {
        if (first == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(10);
        }
        if (second == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(11);
        }
        GridModel model2 = this.myGrid.getDataModel(DataAccessType.DATA_WITH_MUTATIONS);
        ModelIndexSet columns = this.myGrid.getSelectionModel().getSelectedColumns();
        for (ModelIndex colIdx : columns.asIterable()) {
            if (GridCellEditorHelper.get((CoreGrid)this.myGrid).areValuesEqual(model2.getValueAt(first, colIdx), model2.getValueAt(second, colIdx), (CoreGrid)this.myGrid)) continue;
            return false;
        }
        return true;
    }

    private int next(int current) {
        return ++current >= this.myGrid.getVisibleRowsCount() ? 0 : current;
    }

    private void run(@NotNull Runnable runnable) {
        if (runnable == null) {
            GridSelectionTrackerImpl.$$$reportNull$$$0(12);
        }
        this.myAdjusting = true;
        try {
            runnable.run();
        }
        finally {
            this.myAdjusting = false;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 7, 8, 9 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "grid";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "view";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operation";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/ui/grid/selection/GridSelectionTrackerImpl";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stopRow";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "first";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "second";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/ui/grid/selection/GridSelectionTrackerImpl";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getRows";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastRow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performOperation";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canPerformOperation";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "checkAndFillStack";
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findNext";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "rowEquals";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "run";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 7, 8, 9 -> new IllegalStateException(string);
        };
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum OperationImpl implements GridSelectionTracker.Operation
    {
        SELECT_NEXT(1, 1, 1){

            public boolean perform(@NotNull GridSelectionTracker tracker) {
                GridSelectionTrackerImpl t;
                ModelIndex<GridRow> next;
                if (tracker == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ((next = (t = (GridSelectionTrackerImpl)tracker).findNext(t.getLastRow())) == null) {
                    return false;
                }
                t.myRows.add(next);
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTrackerImpl$OperationImpl$1", "perform"));
            }
        }
        ,
        SELECT_ALL(1, 1, 1){

            public boolean perform(@NotNull GridSelectionTracker tracker) {
                ModelIndex<GridRow> next;
                if (tracker == null) {
                    2.$$$reportNull$$$0(0);
                }
                GridSelectionTrackerImpl t = (GridSelectionTrackerImpl)tracker;
                int rowCount = t.myRows.size();
                ViewIndex<GridRow> row = t.getLastRow();
                while ((next = t.findNext(row)) != null) {
                    t.myRows.add(next);
                }
                return rowCount != t.myRows.size();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTrackerImpl$OperationImpl$2", "perform"));
            }
        }
        ,
        UNSELECT_PREVIOUS(2, 1, 2){

            public boolean perform(@NotNull GridSelectionTracker tracker) {
                if (tracker == null) {
                    3.$$$reportNull$$$0(0);
                }
                GridSelectionTrackerImpl t = (GridSelectionTrackerImpl)tracker;
                t.myRows.pop();
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tracker", "com/intellij/database/run/ui/grid/selection/GridSelectionTrackerImpl$OperationImpl$3", "perform"));
            }
        };

        private final int myMinStackSize;
        private final int myMinSelectedColumns;
        private final int myMinSelectedRows;

        private OperationImpl(int minStackSize, int minSelectedColumns, int minSelectedRows) {
            this.myMinStackSize = minStackSize;
            this.myMinSelectedColumns = minSelectedColumns;
            this.myMinSelectedRows = minSelectedRows;
        }

        public boolean checkStackSize(int size) {
            return size >= this.myMinStackSize;
        }

        public boolean checkSelectedColumnsCount(int count) {
            return count >= this.myMinSelectedColumns;
        }

        public boolean checkSelectedRowsCount(int count) {
            return count >= this.myMinSelectedRows;
        }
    }
}

