/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler.languages.java.ast;

import com.strobel.decompiler.languages.java.ast.AstNode;
import com.strobel.decompiler.languages.java.ast.AstNodeCollection;
import com.strobel.decompiler.languages.java.ast.Expression;
import com.strobel.decompiler.languages.java.ast.IAstVisitor;
import com.strobel.decompiler.languages.java.ast.JavaTokenNode;
import com.strobel.decompiler.languages.java.ast.ParameterDeclaration;
import com.strobel.decompiler.languages.java.ast.Roles;
import com.strobel.decompiler.languages.java.ast.TokenRole;
import com.strobel.decompiler.patterns.INode;
import com.strobel.decompiler.patterns.Match;
import com.strobel.decompiler.patterns.Role;

public class LambdaExpression
extends Expression {
    public static final TokenRole ARROW_ROLE = new TokenRole("->", 2);
    public static final Role<AstNode> BODY_ROLE = new Role<AstNode>("Body", AstNode.class, AstNode.NULL);

    public LambdaExpression(int offset) {
        super(offset);
    }

    public final AstNodeCollection<ParameterDeclaration> getParameters() {
        return this.getChildrenByRole(Roles.PARAMETER);
    }

    public final JavaTokenNode getArrowToken() {
        return this.getChildByRole(ARROW_ROLE);
    }

    public final AstNode getBody() {
        return this.getChildByRole(BODY_ROLE);
    }

    public final void setBody(AstNode value) {
        this.setChildByRole(BODY_ROLE, value);
    }

    @Override
    public <T, R> R acceptVisitor(IAstVisitor<? super T, ? extends R> visitor, T data) {
        return visitor.visitLambdaExpression(this, data);
    }

    @Override
    public boolean matches(INode other, Match match) {
        if (other instanceof LambdaExpression) {
            LambdaExpression otherLambda = (LambdaExpression)other;
            return this.getParameters().matches(otherLambda.getParameters(), match) && this.getBody().matches(otherLambda.getBody(), match);
        }
        return false;
    }
}

