/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.http.crt.internal;

import java.io.IOException;
import java.net.ConnectException;
import java.time.Duration;
import javax.net.ssl.SSLHandshakeException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.crt.http.HttpClientConnection;
import software.amazon.awssdk.crt.http.HttpClientConnectionManager;
import software.amazon.awssdk.crt.http.HttpException;
import software.amazon.awssdk.crt.http.HttpManagerMetrics;
import software.amazon.awssdk.http.HttpMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.utils.NumericUtils;

@SdkInternalApi
public final class CrtUtils {
    public static final int CRT_TLS_NEGOTIATION_ERROR_CODE = 1029;
    public static final int CRT_SOCKET_TIMEOUT = 1048;

    private CrtUtils() {
    }

    public static Throwable wrapWithIoExceptionIfRetryable(HttpException httpException) {
        Object toThrow = httpException;
        if (HttpClientConnection.isErrorRetryable((HttpException)httpException)) {
            toThrow = new IOException((Throwable)httpException);
        }
        return toThrow;
    }

    public static Throwable wrapConnectionFailureException(Throwable throwable) {
        IOException toThrow = new IOException("An exception occurred when acquiring a connection", throwable);
        if (throwable instanceof HttpException) {
            HttpException httpException = (HttpException)throwable;
            int httpErrorCode = httpException.getErrorCode();
            if (httpErrorCode == 1029) {
                toThrow = new SSLHandshakeException(httpException.getMessage());
            } else if (httpErrorCode == 1048) {
                toThrow = new ConnectException(httpException.getMessage());
            }
        }
        return toThrow;
    }

    public static void reportMetrics(HttpClientConnectionManager connManager, MetricCollector metricCollector, long acquireStartTime) {
        long acquireCompletionTime = System.nanoTime();
        Duration acquireTimeTaken = Duration.ofNanos(acquireCompletionTime - acquireStartTime);
        metricCollector.reportMetric(HttpMetric.CONCURRENCY_ACQUIRE_DURATION, (Object)acquireTimeTaken);
        HttpManagerMetrics managerMetrics = connManager.getManagerMetrics();
        metricCollector.reportMetric(HttpMetric.MAX_CONCURRENCY, (Object)connManager.getMaxConnections());
        metricCollector.reportMetric(HttpMetric.AVAILABLE_CONCURRENCY, (Object)NumericUtils.saturatedCast((long)managerMetrics.getAvailableConcurrency()));
        metricCollector.reportMetric(HttpMetric.LEASED_CONCURRENCY, (Object)NumericUtils.saturatedCast((long)managerMetrics.getLeasedConcurrency()));
        metricCollector.reportMetric(HttpMetric.PENDING_CONCURRENCY_ACQUIRES, (Object)NumericUtils.saturatedCast((long)managerMetrics.getPendingConcurrencyAcquires()));
    }
}

