/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.models;

import com.azure.core.util.CoreUtils;
import com.azure.storage.blob.implementation.models.ArrowConfiguration;
import com.azure.storage.blob.implementation.models.DelimitedTextConfiguration;
import com.azure.storage.blob.implementation.models.JsonTextConfiguration;
import com.azure.storage.blob.implementation.models.QueryFormatType;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class QueryFormat
implements XmlSerializable<QueryFormat> {
    private QueryFormatType type;
    private DelimitedTextConfiguration delimitedTextConfiguration;
    private JsonTextConfiguration jsonTextConfiguration;
    private ArrowConfiguration arrowConfiguration;
    private Object parquetTextConfiguration;

    public QueryFormatType getType() {
        return this.type;
    }

    public QueryFormat setType(QueryFormatType type) {
        this.type = type;
        return this;
    }

    public DelimitedTextConfiguration getDelimitedTextConfiguration() {
        return this.delimitedTextConfiguration;
    }

    public QueryFormat setDelimitedTextConfiguration(DelimitedTextConfiguration delimitedTextConfiguration) {
        this.delimitedTextConfiguration = delimitedTextConfiguration;
        return this;
    }

    public JsonTextConfiguration getJsonTextConfiguration() {
        return this.jsonTextConfiguration;
    }

    public QueryFormat setJsonTextConfiguration(JsonTextConfiguration jsonTextConfiguration) {
        this.jsonTextConfiguration = jsonTextConfiguration;
        return this;
    }

    public ArrowConfiguration getArrowConfiguration() {
        return this.arrowConfiguration;
    }

    public QueryFormat setArrowConfiguration(ArrowConfiguration arrowConfiguration) {
        this.arrowConfiguration = arrowConfiguration;
        return this;
    }

    public Object getParquetTextConfiguration() {
        return this.parquetTextConfiguration;
    }

    public QueryFormat setParquetTextConfiguration(Object parquetTextConfiguration) {
        this.parquetTextConfiguration = parquetTextConfiguration;
        return this;
    }

    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueryFormat" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Type", this.type == null ? null : this.type.toString());
        xmlWriter.writeXml((XmlSerializable)this.delimitedTextConfiguration, "DelimitedTextConfiguration");
        xmlWriter.writeXml((XmlSerializable)this.jsonTextConfiguration, "JsonTextConfiguration");
        xmlWriter.writeXml((XmlSerializable)this.arrowConfiguration, "ArrowConfiguration");
        xmlWriter.writeStartElement("ParquetTextConfiguration").writeEndElement();
        return xmlWriter.writeEndElement();
    }

    public static QueryFormat fromXml(XmlReader xmlReader) throws XMLStreamException {
        return QueryFormat.fromXml(xmlReader, null);
    }

    public static QueryFormat fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty((CharSequence)rootElementName) ? "QueryFormat" : rootElementName;
        return (QueryFormat)xmlReader.readObject(finalRootElementName, reader -> {
            QueryFormat deserializedQueryFormat = new QueryFormat();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Type".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.type = QueryFormatType.fromString(reader.getStringElement());
                    continue;
                }
                if ("DelimitedTextConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.delimitedTextConfiguration = DelimitedTextConfiguration.fromXml(reader, "DelimitedTextConfiguration");
                    continue;
                }
                if ("JsonTextConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.jsonTextConfiguration = JsonTextConfiguration.fromXml(reader, "JsonTextConfiguration");
                    continue;
                }
                if ("ArrowConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.arrowConfiguration = ArrowConfiguration.fromXml(reader, "ArrowConfiguration");
                    continue;
                }
                if ("ParquetTextConfiguration".equals(elementName.getLocalPart())) {
                    deserializedQueryFormat.parquetTextConfiguration = new Object();
                    xmlReader.skipElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedQueryFormat;
        });
    }
}

