/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.neuralsearch.sparse.common;

import java.util.Iterator;
import java.util.function.BiFunction;

public class CombinedIterator<T, U, R>
implements Iterator<R> {
    private final Iterator<T> firstIter;
    private final Iterator<U> secondIter;
    private final BiFunction<T, U, R> combinedDataCreator;

    public CombinedIterator(Iterator<T> firstIter, Iterator<U> secondIter, BiFunction<T, U, R> combinedDataCreator) {
        this.firstIter = firstIter;
        this.secondIter = secondIter;
        this.combinedDataCreator = combinedDataCreator;
    }

    @Override
    public boolean hasNext() {
        return this.firstIter.hasNext() && this.secondIter.hasNext();
    }

    @Override
    public R next() {
        if (!this.hasNext()) {
            return null;
        }
        T t = this.firstIter.next();
        U u = this.secondIter.next();
        return this.combinedDataCreator.apply(t, u);
    }
}

