/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.pst;

import com.pff.PSTFile;
import com.pff.PSTFolder;
import com.pff.PSTMessage;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Set;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.EmbeddedDocumentUtil;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.PST;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.microsoft.pst.PSTMailItemParser;
import org.apache.tika.sax.XHTMLContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class OutlookPSTParser
implements Parser {
    public static final MediaType MS_OUTLOOK_PST_MIMETYPE = MediaType.application((String)"vnd.ms-outlook-pst");
    private static final long serialVersionUID = 620998217748364063L;
    private static final Set<MediaType> SUPPORTED_TYPES = Collections.singleton(MS_OUTLOOK_PST_MIMETYPE);

    private static AttributesImpl createAttribute(String attName, String attValue) {
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("", attName, attName, "CDATA", attValue);
        return attributes;
    }

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        return SUPPORTED_TYPES;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        EmbeddedDocumentExtractor embeddedExtractor = EmbeddedDocumentUtil.getEmbeddedDocumentExtractor((ParseContext)context);
        metadata.set("Content-Type", MS_OUTLOOK_PST_MIMETYPE.toString());
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        TikaInputStream in = TikaInputStream.get((InputStream)stream);
        PSTFile pstFile = null;
        try {
            pstFile = new PSTFile(in.getFile().getPath());
            metadata.set("Content-Length", String.valueOf(pstFile.getFileHandle().length()));
            boolean isValid = pstFile.getFileHandle().getFD().valid();
            metadata.set(PST.IS_VALID, isValid);
            if (pstFile.getPSTFileType() == 36) {
                throw new TikaException("OST 2013 support not added yet. It will be when https://github.com/rjohnsondev/java-libpst/issues/60 is fixed.");
            }
            if (isValid) {
                this.parseFolder(xhtml, pstFile.getRootFolder(), "/", embeddedExtractor);
            }
        }
        catch (TikaException e) {
            throw e;
        }
        catch (Exception e) {
            throw new TikaException(e.getMessage(), (Throwable)e);
        }
        finally {
            if (pstFile != null && pstFile.getFileHandle() != null) {
                try {
                    pstFile.getFileHandle().close();
                }
                catch (IOException iOException) {}
            }
        }
        xhtml.endDocument();
    }

    private void parseFolder(XHTMLContentHandler handler, PSTFolder pstFolder, String folderPath, EmbeddedDocumentExtractor embeddedExtractor) throws Exception {
        if (pstFolder.getContentCount() > 0) {
            PSTMessage pstMail = (PSTMessage)pstFolder.getNextChild();
            while (pstMail != null) {
                Metadata metadata = new Metadata();
                metadata.set(TikaCoreProperties.CONTENT_TYPE_PARSER_OVERRIDE, PSTMailItemParser.PST_MAIL_ITEM_STRING);
                metadata.set(PST.PST_FOLDER_PATH, folderPath);
                try (TikaInputStream tis = TikaInputStream.get((byte[])new byte[0]);){
                    tis.setOpenContainer((Object)pstMail);
                    metadata.set("resourceName", pstMail.getSubject() + ".msg");
                    embeddedExtractor.parseEmbedded((InputStream)tis, (ContentHandler)handler, metadata, true);
                }
                pstMail = (PSTMessage)pstFolder.getNextChild();
            }
        }
        if (pstFolder.hasSubfolders()) {
            for (PSTFolder pstSubFolder : pstFolder.getSubFolders()) {
                handler.startElement("div", OutlookPSTParser.createAttribute("class", "email-folder"));
                handler.element("h1", pstSubFolder.getDisplayName());
                String subFolderPath = folderPath.endsWith("/") ? folderPath + pstSubFolder.getDisplayName() : folderPath + "/" + pstFolder.getDisplayName();
                this.parseFolder(handler, pstSubFolder, subFolderPath, embeddedExtractor);
                handler.endElement("div");
            }
        }
    }
}

