/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.AllowedPrincipal;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcEndpointServicePermissionsResponse;

public class DescribeVpcEndpointServicePermissionsPublisher
implements SdkPublisher<DescribeVpcEndpointServicePermissionsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeVpcEndpointServicePermissionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeVpcEndpointServicePermissionsPublisher(Ec2AsyncClient client, DescribeVpcEndpointServicePermissionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeVpcEndpointServicePermissionsPublisher(Ec2AsyncClient client, DescribeVpcEndpointServicePermissionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeVpcEndpointServicePermissionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeVpcEndpointServicePermissionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AllowedPrincipal> allowedPrincipals() {
        Function<DescribeVpcEndpointServicePermissionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.allowedPrincipals() != null) {
                return response.allowedPrincipals().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeVpcEndpointServicePermissionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeVpcEndpointServicePermissionsResponseFetcher
    implements AsyncPageFetcher<DescribeVpcEndpointServicePermissionsResponse> {
        private DescribeVpcEndpointServicePermissionsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeVpcEndpointServicePermissionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeVpcEndpointServicePermissionsResponse> nextPage(DescribeVpcEndpointServicePermissionsResponse previousPage) {
            if (previousPage == null) {
                return DescribeVpcEndpointServicePermissionsPublisher.this.client.describeVpcEndpointServicePermissions(DescribeVpcEndpointServicePermissionsPublisher.this.firstRequest);
            }
            return DescribeVpcEndpointServicePermissionsPublisher.this.client.describeVpcEndpointServicePermissions((DescribeVpcEndpointServicePermissionsRequest)((Object)DescribeVpcEndpointServicePermissionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

