/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.MacSystemIntegrityProtectionConfigurationRequest;
import software.amazon.awssdk.services.ec2.model.MacSystemIntegrityProtectionSettingStatus;
import software.amazon.awssdk.services.ec2.model.TagSpecification;
import software.amazon.awssdk.services.ec2.model.TagSpecificationListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMacSystemIntegrityProtectionModificationTaskRequest
extends Ec2Request
implements ToCopyableBuilder<Builder, CreateMacSystemIntegrityProtectionModificationTaskRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientToken").getter(CreateMacSystemIntegrityProtectionModificationTaskRequest.getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::clientToken)).setter(CreateMacSystemIntegrityProtectionModificationTaskRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientToken").unmarshallLocationName("ClientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("DryRun").getter(CreateMacSystemIntegrityProtectionModificationTaskRequest.getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::dryRun)).setter(CreateMacSystemIntegrityProtectionModificationTaskRequest.setter(Builder::dryRun)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DryRun").unmarshallLocationName("DryRun").build()}).build();
    private static final SdkField<String> INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("InstanceId").getter(CreateMacSystemIntegrityProtectionModificationTaskRequest.getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::instanceId)).setter(CreateMacSystemIntegrityProtectionModificationTaskRequest.setter(Builder::instanceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceId").unmarshallLocationName("InstanceId").build()}).build();
    private static final SdkField<String> MAC_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacCredentials").getter(CreateMacSystemIntegrityProtectionModificationTaskRequest.getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::macCredentials)).setter(CreateMacSystemIntegrityProtectionModificationTaskRequest.setter(Builder::macCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacCredentials").unmarshallLocationName("MacCredentials").build()}).build();
    private static final SdkField<MacSystemIntegrityProtectionConfigurationRequest> MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MacSystemIntegrityProtectionConfiguration").getter(CreateMacSystemIntegrityProtectionModificationTaskRequest.getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::macSystemIntegrityProtectionConfiguration)).setter(CreateMacSystemIntegrityProtectionModificationTaskRequest.setter(Builder::macSystemIntegrityProtectionConfiguration)).constructor(MacSystemIntegrityProtectionConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacSystemIntegrityProtectionConfiguration").unmarshallLocationName("MacSystemIntegrityProtectionConfiguration").build()}).build();
    private static final SdkField<String> MAC_SYSTEM_INTEGRITY_PROTECTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MacSystemIntegrityProtectionStatus").getter(CreateMacSystemIntegrityProtectionModificationTaskRequest.getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::macSystemIntegrityProtectionStatusAsString)).setter(CreateMacSystemIntegrityProtectionModificationTaskRequest.setter(Builder::macSystemIntegrityProtectionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MacSystemIntegrityProtectionStatus").unmarshallLocationName("MacSystemIntegrityProtectionStatus").build()}).build();
    private static final SdkField<List<TagSpecification>> TAG_SPECIFICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("TagSpecifications").getter(CreateMacSystemIntegrityProtectionModificationTaskRequest.getter(CreateMacSystemIntegrityProtectionModificationTaskRequest::tagSpecifications)).setter(CreateMacSystemIntegrityProtectionModificationTaskRequest.setter(Builder::tagSpecifications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSpecification").unmarshallLocationName("TagSpecification").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TagSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DRY_RUN_FIELD, INSTANCE_ID_FIELD, MAC_CREDENTIALS_FIELD, MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIGURATION_FIELD, MAC_SYSTEM_INTEGRITY_PROTECTION_STATUS_FIELD, TAG_SPECIFICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMacSystemIntegrityProtectionModificationTaskRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final Boolean dryRun;
    private final String instanceId;
    private final String macCredentials;
    private final MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration;
    private final String macSystemIntegrityProtectionStatus;
    private final List<TagSpecification> tagSpecifications;

    private CreateMacSystemIntegrityProtectionModificationTaskRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.dryRun = builder.dryRun;
        this.instanceId = builder.instanceId;
        this.macCredentials = builder.macCredentials;
        this.macSystemIntegrityProtectionConfiguration = builder.macSystemIntegrityProtectionConfiguration;
        this.macSystemIntegrityProtectionStatus = builder.macSystemIntegrityProtectionStatus;
        this.tagSpecifications = builder.tagSpecifications;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final Boolean dryRun() {
        return this.dryRun;
    }

    public final String instanceId() {
        return this.instanceId;
    }

    public final String macCredentials() {
        return this.macCredentials;
    }

    public final MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration() {
        return this.macSystemIntegrityProtectionConfiguration;
    }

    public final MacSystemIntegrityProtectionSettingStatus macSystemIntegrityProtectionStatus() {
        return MacSystemIntegrityProtectionSettingStatus.fromValue(this.macSystemIntegrityProtectionStatus);
    }

    public final String macSystemIntegrityProtectionStatusAsString() {
        return this.macSystemIntegrityProtectionStatus;
    }

    public final boolean hasTagSpecifications() {
        return this.tagSpecifications != null && !(this.tagSpecifications instanceof SdkAutoConstructList);
    }

    public final List<TagSpecification> tagSpecifications() {
        return this.tagSpecifications;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.macCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.macSystemIntegrityProtectionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.macSystemIntegrityProtectionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTagSpecifications() ? this.tagSpecifications() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMacSystemIntegrityProtectionModificationTaskRequest)) {
            return false;
        }
        CreateMacSystemIntegrityProtectionModificationTaskRequest other = (CreateMacSystemIntegrityProtectionModificationTaskRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.dryRun(), other.dryRun()) && Objects.equals(this.instanceId(), other.instanceId()) && Objects.equals(this.macCredentials(), other.macCredentials()) && Objects.equals(this.macSystemIntegrityProtectionConfiguration(), other.macSystemIntegrityProtectionConfiguration()) && Objects.equals(this.macSystemIntegrityProtectionStatusAsString(), other.macSystemIntegrityProtectionStatusAsString()) && this.hasTagSpecifications() == other.hasTagSpecifications() && Objects.equals(this.tagSpecifications(), other.tagSpecifications());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMacSystemIntegrityProtectionModificationTaskRequest").add("ClientToken", (Object)this.clientToken()).add("DryRun", (Object)this.dryRun()).add("InstanceId", (Object)this.instanceId()).add("MacCredentials", (Object)(this.macCredentials() == null ? null : "*** Sensitive Data Redacted ***")).add("MacSystemIntegrityProtectionConfiguration", (Object)this.macSystemIntegrityProtectionConfiguration()).add("MacSystemIntegrityProtectionStatus", (Object)this.macSystemIntegrityProtectionStatusAsString()).add("TagSpecifications", this.hasTagSpecifications() ? this.tagSpecifications() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "DryRun": {
                return Optional.ofNullable(clazz.cast(this.dryRun()));
            }
            case "InstanceId": {
                return Optional.ofNullable(clazz.cast(this.instanceId()));
            }
            case "MacCredentials": {
                return Optional.ofNullable(clazz.cast(this.macCredentials()));
            }
            case "MacSystemIntegrityProtectionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.macSystemIntegrityProtectionConfiguration()));
            }
            case "MacSystemIntegrityProtectionStatus": {
                return Optional.ofNullable(clazz.cast(this.macSystemIntegrityProtectionStatusAsString()));
            }
            case "TagSpecifications": {
                return Optional.ofNullable(clazz.cast(this.tagSpecifications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ClientToken", CLIENT_TOKEN_FIELD);
        map.put("DryRun", DRY_RUN_FIELD);
        map.put("InstanceId", INSTANCE_ID_FIELD);
        map.put("MacCredentials", MAC_CREDENTIALS_FIELD);
        map.put("MacSystemIntegrityProtectionConfiguration", MAC_SYSTEM_INTEGRITY_PROTECTION_CONFIGURATION_FIELD);
        map.put("MacSystemIntegrityProtectionStatus", MAC_SYSTEM_INTEGRITY_PROTECTION_STATUS_FIELD);
        map.put("TagSpecification", TAG_SPECIFICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMacSystemIntegrityProtectionModificationTaskRequest, T> g) {
        return obj -> g.apply((CreateMacSystemIntegrityProtectionModificationTaskRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Request.BuilderImpl
    implements Builder {
        private String clientToken;
        private Boolean dryRun;
        private String instanceId;
        private String macCredentials;
        private MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration;
        private String macSystemIntegrityProtectionStatus;
        private List<TagSpecification> tagSpecifications = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMacSystemIntegrityProtectionModificationTaskRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.dryRun(model.dryRun);
            this.instanceId(model.instanceId);
            this.macCredentials(model.macCredentials);
            this.macSystemIntegrityProtectionConfiguration(model.macSystemIntegrityProtectionConfiguration);
            this.macSystemIntegrityProtectionStatus(model.macSystemIntegrityProtectionStatus);
            this.tagSpecifications(model.tagSpecifications);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final String getInstanceId() {
            return this.instanceId;
        }

        public final void setInstanceId(String instanceId) {
            this.instanceId = instanceId;
        }

        @Override
        public final Builder instanceId(String instanceId) {
            this.instanceId = instanceId;
            return this;
        }

        public final String getMacCredentials() {
            return this.macCredentials;
        }

        public final void setMacCredentials(String macCredentials) {
            this.macCredentials = macCredentials;
        }

        @Override
        public final Builder macCredentials(String macCredentials) {
            this.macCredentials = macCredentials;
            return this;
        }

        public final MacSystemIntegrityProtectionConfigurationRequest.Builder getMacSystemIntegrityProtectionConfiguration() {
            return this.macSystemIntegrityProtectionConfiguration != null ? this.macSystemIntegrityProtectionConfiguration.toBuilder() : null;
        }

        public final void setMacSystemIntegrityProtectionConfiguration(MacSystemIntegrityProtectionConfigurationRequest.BuilderImpl macSystemIntegrityProtectionConfiguration) {
            this.macSystemIntegrityProtectionConfiguration = macSystemIntegrityProtectionConfiguration != null ? macSystemIntegrityProtectionConfiguration.build() : null;
        }

        @Override
        public final Builder macSystemIntegrityProtectionConfiguration(MacSystemIntegrityProtectionConfigurationRequest macSystemIntegrityProtectionConfiguration) {
            this.macSystemIntegrityProtectionConfiguration = macSystemIntegrityProtectionConfiguration;
            return this;
        }

        public final String getMacSystemIntegrityProtectionStatus() {
            return this.macSystemIntegrityProtectionStatus;
        }

        public final void setMacSystemIntegrityProtectionStatus(String macSystemIntegrityProtectionStatus) {
            this.macSystemIntegrityProtectionStatus = macSystemIntegrityProtectionStatus;
        }

        @Override
        public final Builder macSystemIntegrityProtectionStatus(String macSystemIntegrityProtectionStatus) {
            this.macSystemIntegrityProtectionStatus = macSystemIntegrityProtectionStatus;
            return this;
        }

        @Override
        public final Builder macSystemIntegrityProtectionStatus(MacSystemIntegrityProtectionSettingStatus macSystemIntegrityProtectionStatus) {
            this.macSystemIntegrityProtectionStatus(macSystemIntegrityProtectionStatus == null ? null : macSystemIntegrityProtectionStatus.toString());
            return this;
        }

        public final List<TagSpecification.Builder> getTagSpecifications() {
            List<TagSpecification.Builder> result = TagSpecificationListCopier.copyToBuilder(this.tagSpecifications);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTagSpecifications(Collection<TagSpecification.BuilderImpl> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copyFromBuilder(tagSpecifications);
        }

        @Override
        public final Builder tagSpecifications(Collection<TagSpecification> tagSpecifications) {
            this.tagSpecifications = TagSpecificationListCopier.copy(tagSpecifications);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(TagSpecification ... tagSpecifications) {
            this.tagSpecifications(Arrays.asList(tagSpecifications));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tagSpecifications(Consumer<TagSpecification.Builder> ... tagSpecifications) {
            this.tagSpecifications(Stream.of(tagSpecifications).map(c -> (TagSpecification)((TagSpecification.Builder)TagSpecification.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMacSystemIntegrityProtectionModificationTaskRequest build() {
            return new CreateMacSystemIntegrityProtectionModificationTaskRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends Ec2Request.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMacSystemIntegrityProtectionModificationTaskRequest> {
        public Builder clientToken(String var1);

        public Builder dryRun(Boolean var1);

        public Builder instanceId(String var1);

        public Builder macCredentials(String var1);

        public Builder macSystemIntegrityProtectionConfiguration(MacSystemIntegrityProtectionConfigurationRequest var1);

        default public Builder macSystemIntegrityProtectionConfiguration(Consumer<MacSystemIntegrityProtectionConfigurationRequest.Builder> macSystemIntegrityProtectionConfiguration) {
            return this.macSystemIntegrityProtectionConfiguration((MacSystemIntegrityProtectionConfigurationRequest)((MacSystemIntegrityProtectionConfigurationRequest.Builder)MacSystemIntegrityProtectionConfigurationRequest.builder().applyMutation(macSystemIntegrityProtectionConfiguration)).build());
        }

        public Builder macSystemIntegrityProtectionStatus(String var1);

        public Builder macSystemIntegrityProtectionStatus(MacSystemIntegrityProtectionSettingStatus var1);

        public Builder tagSpecifications(Collection<TagSpecification> var1);

        public Builder tagSpecifications(TagSpecification ... var1);

        public Builder tagSpecifications(Consumer<TagSpecification.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

