/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.calcite.utils.binning.handlers;

import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.opensearch.sql.ast.expression.Literal;
import org.opensearch.sql.ast.expression.UnresolvedExpression;
import org.opensearch.sql.ast.tree.Bin;
import org.opensearch.sql.ast.tree.CountBin;
import org.opensearch.sql.calcite.CalcitePlanContext;
import org.opensearch.sql.calcite.CalciteRexNodeVisitor;
import org.opensearch.sql.calcite.utils.binning.BinFieldValidator;
import org.opensearch.sql.calcite.utils.binning.BinHandler;
import org.opensearch.sql.calcite.utils.binning.BinnableField;
import org.opensearch.sql.expression.function.BuiltinFunctionName;
import org.opensearch.sql.expression.function.PPLFuncImpTable;

public class CountBinHandler
implements BinHandler {
    @Override
    public RexNode createExpression(Bin node, RexNode fieldExpr, CalcitePlanContext context, CalciteRexNodeVisitor visitor) {
        CountBin countBin = (CountBin)node;
        String fieldName = BinFieldValidator.extractFieldName(node);
        BinnableField field = new BinnableField(fieldExpr, fieldExpr.getType(), fieldName);
        Integer requestedBins = countBin.getBins();
        if (requestedBins == null) {
            requestedBins = 100;
        }
        RexNode minValue = context.relBuilder.min(fieldExpr).over().toRex();
        RexNode maxValue = context.relBuilder.max(fieldExpr).over().toRex();
        RexNode dataRange = PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.SUBTRACT, maxValue, minValue);
        RexNode startValue = this.convertParameter(countBin.getStart(), context);
        RexNode endValue = this.convertParameter(countBin.getEnd(), context);
        RexLiteral numBins = context.relBuilder.literal((Object)requestedBins);
        return PPLFuncImpTable.INSTANCE.resolve((RexBuilder)context.rexBuilder, BuiltinFunctionName.WIDTH_BUCKET, new RexNode[]{fieldExpr, numBins, dataRange, maxValue});
    }

    private RexNode convertParameter(UnresolvedExpression expr, CalcitePlanContext context) {
        if (expr == null) {
            return context.relBuilder.literal((Object)-1);
        }
        if (expr instanceof Literal) {
            Literal literal = (Literal)expr;
            Object value = literal.getValue();
            if (value instanceof Number) {
                return context.relBuilder.literal((Object)((Number)value).doubleValue());
            }
            return context.relBuilder.literal(value);
        }
        throw new IllegalArgumentException("Expected literal expression, got: " + String.valueOf(expr.getClass()));
    }
}

