/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.alerting.resthandler;

import java.time.Instant;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.alerting.AlertingPlugin;
import org.opensearch.alerting.action.ExecuteMonitorAction;
import org.opensearch.alerting.action.ExecuteMonitorRequest;
import org.opensearch.alerting.resthandler.RestExecuteMonitorActionKt;
import org.opensearch.common.unit.TimeValue;
import org.opensearch.commons.alerting.model.Monitor;
import org.opensearch.commons.alerting.util.AlertingException;
import org.opensearch.core.action.ActionListener;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.core.xcontent.XContentParserUtils;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestChannel;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestToXContentListener;
import org.opensearch.transport.client.node.NodeClient;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u000e\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0014J\u000e\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0016\u00a8\u0006\u0013"}, d2={"Lorg/opensearch/alerting/resthandler/RestExecuteMonitorAction;", "Lorg/opensearch/rest/BaseRestHandler;", "()V", "getName", "", "prepareRequest", "Lorg/opensearch/rest/BaseRestHandler$RestChannelConsumer;", "request", "Lorg/opensearch/rest/RestRequest;", "client", "Lorg/opensearch/transport/client/node/NodeClient;", "replacedRoutes", "", "Lorg/opensearch/rest/RestHandler$ReplacedRoute;", "responseParams", "", "routes", "", "Lorg/opensearch/rest/RestHandler$Route;", "opensearch-alerting"})
public final class RestExecuteMonitorAction
extends BaseRestHandler {
    @NotNull
    public String getName() {
        return "execute_monitor_action";
    }

    @NotNull
    public List<RestHandler.Route> routes() {
        return CollectionsKt.emptyList();
    }

    @NotNull
    public List<RestHandler.ReplacedRoute> replacedRoutes() {
        Object[] objectArray = new RestHandler.ReplacedRoute[]{new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/{monitorID}/_execute", RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_MONITOR_BASE_URI + "/{monitorID}/_execute"), new RestHandler.ReplacedRoute(RestRequest.Method.POST, AlertingPlugin.MONITOR_BASE_URI + "/_execute", RestRequest.Method.POST, AlertingPlugin.LEGACY_OPENDISTRO_MONITOR_BASE_URI + "/_execute")};
        return CollectionsKt.mutableListOf((Object[])objectArray);
    }

    @NotNull
    protected BaseRestHandler.RestChannelConsumer prepareRequest(@NotNull RestRequest request, @NotNull NodeClient client) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        RestExecuteMonitorActionKt.access$getLog$p().debug(request.method() + " " + AlertingPlugin.MONITOR_BASE_URI + "/_execute");
        return arg_0 -> RestExecuteMonitorAction.prepareRequest$lambda$0(request, client, arg_0);
    }

    @NotNull
    protected Set<String> responseParams() {
        Object[] objectArray = new String[]{"dryrun", "period_end", "monitorID"};
        return SetsKt.setOf((Object[])objectArray);
    }

    private static final void prepareRequest$lambda$0(RestRequest $request, NodeClient $client, RestChannel channel) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)$client, (String)"$client");
        boolean dryrun = $request.paramAsBoolean("dryrun", false);
        TimeValue requestEnd = $request.paramAsTime("period_end", new TimeValue(Instant.now().toEpochMilli()));
        if ($request.hasParam("monitorID")) {
            String monitorId = $request.param("monitorID");
            Intrinsics.checkNotNull((Object)requestEnd);
            ExecuteMonitorRequest execMonitorRequest = new ExecuteMonitorRequest(dryrun, requestEnd, monitorId, null, null, 16, null);
            $client.execute((ActionType)ExecuteMonitorAction.Companion.getINSTANCE(), (ActionRequest)execMonitorRequest, (ActionListener)new RestToXContentListener(channel));
        } else {
            XContentParser xcp = $request.contentParser();
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)xcp.nextToken(), (XContentParser)xcp);
            Monitor monitor = null;
            try {
                Intrinsics.checkNotNull((Object)xcp);
                monitor = Monitor.Companion.parse(xcp, "", 1L);
            }
            catch (Exception e) {
                throw AlertingException.Companion.wrap(e);
            }
            Intrinsics.checkNotNull((Object)requestEnd);
            ExecuteMonitorRequest execMonitorRequest = new ExecuteMonitorRequest(dryrun, requestEnd, null, monitor, null, 16, null);
            $client.execute((ActionType)ExecuteMonitorAction.Companion.getINSTANCE(), (ActionRequest)execMonitorRequest, (ActionListener)new RestToXContentListener(channel));
        }
    }
}

