/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector;

import java.util.function.BiConsumer;
import org.opensearch.search.aggregations.bucket.filterrewrite.FilterRewriteOptimizationContext;
import org.opensearch.search.aggregations.bucket.filterrewrite.Ranges;
import org.opensearch.search.aggregations.bucket.filterrewrite.rangecollector.RangeCollector;

public abstract class AbstractRangeCollector
implements RangeCollector {
    protected final Ranges ranges;
    protected int activeIndex;
    protected final BiConsumer<Integer, Integer> incrementRangeDocCount;
    protected final int maxNumNonZeroRange;
    protected final FilterRewriteOptimizationContext.OptimizeResult result;
    private int visitedRange = 0;
    protected int counter = 0;

    public AbstractRangeCollector(Ranges ranges, BiConsumer<Integer, Integer> incrementRangeDocCount, int maxNumNonZeroRange, int activeIndex, FilterRewriteOptimizationContext.OptimizeResult result) {
        this.ranges = ranges;
        this.activeIndex = activeIndex;
        this.incrementRangeDocCount = incrementRangeDocCount;
        this.maxNumNonZeroRange = maxNumNonZeroRange;
        this.result = result;
    }

    @Override
    public boolean iterateRangeEnd(byte[] value, boolean inLeaf) {
        while (!this.withinUpperBound(value)) {
            if (++this.activeIndex < this.ranges.getSize()) continue;
            return true;
        }
        ++this.visitedRange;
        return this.visitedRange > this.maxNumNonZeroRange;
    }

    @Override
    public boolean withinLowerBound(byte[] value) {
        return Ranges.withinLowerBound(value, this.ranges.getLowers()[this.activeIndex]);
    }

    @Override
    public boolean withinUpperBound(byte[] value) {
        return Ranges.withinUpperBound(value, this.ranges.getUppers()[this.activeIndex]);
    }

    @Override
    public boolean withinRange(byte[] value) {
        return this.withinLowerBound(value) && this.withinUpperBound(value);
    }

    @Override
    public void visitInner() {
        this.result.visitInner();
    }

    @Override
    public void visitLeaf() {
        this.result.visitLeaf();
    }

    @Override
    public FilterRewriteOptimizationContext.OptimizeResult getResult() {
        return this.result;
    }
}

