# -*- coding:binary -*-

require 'spec_helper'

RSpec.describe Msf::Exploit::Remote::HTTP::Nifi do
  subject do
    mod = ::Msf::Module.new
    mod.extend described_class
    mod
  end

  let(:valid_code) do
    200
  end

  describe '#nifi get_version' do
    it 'returns nil if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect(subject.get_version).to be_nil
    end

    it 'returns nil if version cant be found' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 200
        res.body = 'foobar'
        res
      end

      expect(subject.get_version).to be_nil
    end

    it 'returns version when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = valid_code
        res.body = '<script type="text/javascript" src="js/nf/nf-namespace.js?1.21.0"></script>'
        res
      end

      expect(subject.get_version).to eq(Rex::Version.new('1.21.0'))
    end
  end

  describe '#nifi fetch_root_process_group' do
    it 'returns nil if page can not be reached' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response::E404.new
        res
      end

      expect(subject.fetch_root_process_group('a')).to be_nil
    end

    it 'returns nil if value not found' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = 200
        res.body = 'foobar'
        res
      end

      expect(subject.fetch_root_process_group('a')).to be_nil
    end

    it 'returns UUID when successfull' do
      allow(subject).to receive(:send_request_cgi) do
        res = Rex::Proto::Http::Response.new
        res.code = valid_code
        res.body = '{"id":"628de124-3d0f-11ee-be56-0242ac120002"}'
        res
      end

      expect(subject.fetch_root_process_group('a')).to eq('628de124-3d0f-11ee-be56-0242ac120002')
    end
  end
end
