/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.Incubating;
import org.hibernate.Internal;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.sql.results.graph.entity.EntityInitializer;
import org.hibernate.sql.results.jdbc.spi.JdbcValuesSourceProcessingState;

@Incubating
public interface EntityHolder {
    public EntityKey getEntityKey();

    public EntityPersister getDescriptor();

    public @Nullable Object getEntity();

    public @Nullable Object getProxy();

    public @Nullable EntityInitializer<?> getEntityInitializer();

    public @Nullable JdbcValuesSourceProcessingState getJdbcValuesProcessingState();

    default public @Nullable Object getManagedObject() {
        Object proxy = this.getProxy();
        return proxy == null ? this.getEntity() : proxy;
    }

    public @Nullable EntityEntry getEntityEntry();

    @Internal
    public void setEntityEntry(@Nullable EntityEntry var1);

    public void markAsReloaded(JdbcValuesSourceProcessingState var1);

    public boolean isInitialized();

    public boolean isEventuallyInitialized();

    public boolean isDetached();

    public void resetEntityInitialier();
}

