/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.federation.sssd.impl;

import org.freedesktop.dbus.connections.impl.DBusConnection;
import org.freedesktop.dbus.connections.impl.DBusConnectionBuilder;
import org.freedesktop.sssd.infopipe.InfoPipe;
import org.jboss.logging.Logger;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class AvailabilityChecker {
    private static final Logger logger = Logger.getLogger(AvailabilityChecker.class);

    public static boolean isAvailable() {
        boolean sssdAvailable = false;
        try (DBusConnection connection = DBusConnectionBuilder.forSystemBus().build();){
            InfoPipe infoPipe = connection.getRemoteObject("org.freedesktop.sssd.infopipe", "/org/freedesktop/sssd/infopipe", InfoPipe.class);
            if (infoPipe.ping("PING") == null || infoPipe.ping("PING").isEmpty()) {
                logger.debug((Object)"SSSD is not available in your system. Federation provider will be disabled.");
            } else {
                sssdAvailable = true;
            }
        }
        catch (Exception e) {
            logger.debug((Object)"SSSD is not available in your system. Federation provider will be disabled.", (Throwable)e);
        }
        return sssdAvailable;
    }
}

