/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.client;

import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.RoleModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.mapper.ClientModelMapper;
import org.keycloak.models.mapper.MapStructModelMapper;
import org.keycloak.models.utils.ModelToRepresentation;
import org.keycloak.representations.admin.v2.ClientRepresentation;
import org.keycloak.representations.admin.v2.validation.CreateClientDefault;
import org.keycloak.representations.idm.RoleRepresentation;
import org.keycloak.services.ServiceException;
import org.keycloak.services.client.ClientService;
import org.keycloak.services.resources.admin.ClientResource;
import org.keycloak.services.resources.admin.ClientsResource;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.RoleContainerResource;
import org.keycloak.services.resources.admin.RoleMapperResource;
import org.keycloak.validation.jakarta.HibernateValidatorProvider;
import org.keycloak.validation.jakarta.JakartaValidatorProvider;

public class DefaultClientService
implements ClientService {
    private final KeycloakSession session;
    private final ClientModelMapper mapper;
    private final JakartaValidatorProvider validator;
    private final RealmAdminResource realmAdminResource;
    private final ClientsResource clientsResource;
    private ClientResource clientResource;

    public DefaultClientService(KeycloakSession session, RealmAdminResource realmAdminResource, ClientResource clientResource) {
        this.session = session;
        this.realmAdminResource = realmAdminResource;
        this.clientResource = clientResource;
        this.clientsResource = realmAdminResource.getClients();
        this.mapper = new MapStructModelMapper().clients();
        this.validator = new HibernateValidatorProvider();
    }

    public DefaultClientService(KeycloakSession session, RealmAdminResource realmAdminResource) {
        this(session, realmAdminResource, null);
    }

    @Override
    public Optional<ClientRepresentation> getClient(RealmModel realm, String clientId, ClientService.ClientProjectionOptions projectionOptions) {
        return Optional.ofNullable(this.clientResource).map(ClientResource::viewClientModel).map(model -> this.mapper.fromModel(this.session, (ClientModel)model));
    }

    @Override
    public Stream<ClientRepresentation> getClients(RealmModel realm, ClientService.ClientProjectionOptions projectionOptions, ClientService.ClientSearchOptions searchOptions, ClientService.ClientSortAndSliceOptions sortAndSliceOptions) {
        return this.clientsResource.getClientModels(null, true, false, null, null, null).map(model -> this.mapper.fromModel(this.session, (ClientModel)model));
    }

    @Override
    public ClientService.CreateOrUpdateResult createOrUpdate(RealmModel realm, ClientRepresentation client, boolean allowUpdate) throws ServiceException {
        ClientModel model;
        boolean created = false;
        if (this.clientResource != null) {
            if (!allowUpdate) {
                throw new ServiceException("Client already exists", Response.Status.CONFLICT);
            }
            model = this.mapper.toModel(this.session, realm, this.clientResource.viewClientModel(), client);
            rep = ModelToRepresentation.toRepresentation((ClientModel)model, (KeycloakSession)this.session);
            this.clientResource.update(rep);
        } else {
            created = true;
            this.validator.validate(client, CreateClientDefault.class);
            model = this.mapper.toModel(this.session, realm, client);
            rep = ModelToRepresentation.toRepresentation((ClientModel)model, (KeycloakSession)this.session);
            model = this.clientsResource.createClientModel(rep);
            this.clientResource = this.clientsResource.getClient(model.getId());
        }
        this.handleRoles(client.getRoles());
        this.handleServiceAccount(model, client.getServiceAccount());
        ClientRepresentation updated = this.mapper.fromModel(this.session, model);
        return new ClientService.CreateOrUpdateResult(updated, created);
    }

    @Override
    public Stream<ClientRepresentation> deleteClients(RealmModel realm, ClientService.ClientSearchOptions searchOptions) {
        return null;
    }

    protected void handleRoles(Set<String> rolesFromRep) {
        RoleContainerResource roleResource = this.clientResource.getRoleContainerResource();
        Set desiredRoleNames = Optional.ofNullable(rolesFromRep).orElse(Collections.emptySet());
        Set currentRoleNames = roleResource.getRoles(null, null, null, false).map(RoleRepresentation::getName).collect(Collectors.toSet());
        desiredRoleNames.stream().filter(roleName -> !currentRoleNames.contains(roleName)).forEach(roleName -> roleResource.createRole(new RoleRepresentation(roleName, "", false)));
        currentRoleNames.stream().filter(role -> !desiredRoleNames.contains(role)).forEach(arg_0 -> ((RoleContainerResource)roleResource).deleteRole(arg_0));
    }

    protected void handleServiceAccount(ClientModel model, ClientRepresentation.ServiceAccount serviceAccount) {
        if (serviceAccount != null && serviceAccount.getEnabled() != null) {
            ClientResource.updateClientServiceAccount((KeycloakSession)this.session, (ClientModel)model, (Boolean)serviceAccount.getEnabled());
            if (serviceAccount.getEnabled().booleanValue()) {
                List<RoleRepresentation> extraRoles;
                RoleContainerResource clientRoleResource = this.clientResource.getRoleContainerResource();
                RoleContainerResource realmRoleResource = this.realmAdminResource.getRoleContainerResource();
                UserModel serviceAccountUser = this.session.users().getServiceAccount(model);
                RoleMapperResource serviceAccountRoleResource = this.realmAdminResource.users().user(this.clientResource.getServiceAccountUser().getId()).getRoleMappings();
                Set desiredRoleNames = Optional.ofNullable(serviceAccount.getRoles()).orElse(Collections.emptySet());
                Set currentRoles = serviceAccountUser.getRoleMappingsStream().collect(Collectors.toSet());
                Set currentRoleNames = currentRoles.stream().map(RoleModel::getName).collect(Collectors.toSet());
                List<RoleRepresentation> missingRoles = desiredRoleNames.stream().filter(roleName -> !currentRoleNames.contains(roleName)).map(roleName -> {
                    try {
                        return clientRoleResource.getRole(roleName);
                    }
                    catch (NotFoundException e) {
                        try {
                            return realmRoleResource.getRole(roleName);
                        }
                        catch (NotFoundException e2) {
                            throw new ServiceException("Cannot assign role to the service account (field 'serviceAccount.roles') as it does not exist", Response.Status.BAD_REQUEST);
                        }
                    }
                }).toList();
                if (!missingRoles.isEmpty()) {
                    serviceAccountRoleResource.addRealmRoleMappings(missingRoles);
                }
                if (!(extraRoles = currentRoles.stream().filter(role -> !desiredRoleNames.contains(role.getName())).map(ModelToRepresentation::toRepresentation).toList()).isEmpty()) {
                    try {
                        serviceAccountRoleResource.deleteRealmRoleMappings(extraRoles);
                    }
                    catch (NotFoundException e) {
                        throw new ServiceException("Cannot unassign role from the service account (field 'serviceAccount.roles') as it does not exist", Response.Status.BAD_REQUEST);
                    }
                }
            }
        }
    }
}

