/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.runtime;

import io.netty.util.concurrent.FastThreadLocal;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.CurrentContextFactory;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.LazyValue;
import io.quarkus.vertx.core.runtime.context.VertxContextSafetyToggle;
import io.smallrye.common.vertx.VertxContext;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Supplier;

public class VertxCurrentContextFactory
implements CurrentContextFactory {
    private static final String LOCAL_KEY_PREFIX = "io.quarkus.vertx.cdi-current-context";
    private final List<String> keys = new CopyOnWriteArrayList<String>();
    private final List<String> unmodifiableKeys = Collections.unmodifiableList(this.keys);

    public <T extends InjectableContext.ContextState> CurrentContext<T> create(Class<? extends Annotation> scope) {
        String key = LOCAL_KEY_PREFIX + scope.getName();
        if (this.keys.contains(key)) {
            throw new IllegalStateException("Multiple current contexts for the same scope are not supported. Current context for " + String.valueOf(scope) + " already exists!");
        }
        this.keys.add(key);
        return new VertxCurrentContext(key);
    }

    public List<String> keys() {
        return this.unmodifiableKeys;
    }

    private static final class VertxCurrentContext<T extends InjectableContext.ContextState>
    implements CurrentContext<T> {
        private final String key;
        private final LazyValue<FastThreadLocal<T>> fallback = new LazyValue(new Supplier<FastThreadLocal<T>>(){

            @Override
            public FastThreadLocal<T> get() {
                return new FastThreadLocal();
            }
        });

        private VertxCurrentContext(String key) {
            this.key = key;
        }

        public T get() {
            Context context = Vertx.currentContext();
            if (context != null && VertxContext.isDuplicatedContext((Context)context)) {
                return (T)((InjectableContext.ContextState)context.getLocal((Object)this.key));
            }
            return (T)((InjectableContext.ContextState)((FastThreadLocal)this.fallback.get()).get());
        }

        public void set(T state) {
            Context context = Vertx.currentContext();
            if (context != null && VertxContext.isDuplicatedContext((Context)context)) {
                VertxContextSafetyToggle.setContextSafe(context, true);
                Object oldState = context.getLocal((Object)this.key);
                if (oldState != state) {
                    context.putLocal((Object)this.key, state);
                }
            } else {
                ((FastThreadLocal)this.fallback.get()).set(state);
            }
        }

        public void remove() {
            Context context = Vertx.currentContext();
            if (context == null || !VertxContext.isDuplicatedContext((Context)context)) {
                ((FastThreadLocal)this.fallback.get()).remove();
            }
        }
    }
}

