/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.cors;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.keycloak.Config;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.provider.ProviderConfigurationBuilder;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.cors.CorsFactory;
import org.keycloak.services.cors.DefaultCors;

public class DefaultCorsFactory
implements CorsFactory {
    private static final String PROVIDER_ID = "default";
    private static final String ALLOWED_HEADERS = "allowedHeaders";
    private String allowedHeaders;

    public Cors create(KeycloakSession session) {
        return new DefaultCors(session, this.allowedHeaders);
    }

    public void init(Config.Scope config) {
        HashSet<String> allowedHeaders = new HashSet<String>(Cors.DEFAULT_ALLOW_HEADERS);
        String[] customAllowedHeaders = config.getArray(ALLOWED_HEADERS);
        if (customAllowedHeaders != null) {
            allowedHeaders.addAll(Arrays.asList(customAllowedHeaders));
        }
        this.allowedHeaders = String.join((CharSequence)", ", allowedHeaders);
    }

    public void postInit(KeycloakSessionFactory factory) {
    }

    public void close() {
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public List<ProviderConfigProperty> getConfigMetadata() {
        return ProviderConfigurationBuilder.create().property().name(ALLOWED_HEADERS).type("string").helpText("A comma-separated list of additional allowed headers for CORS requests").defaultValue((Object)"").add().build();
    }
}

