/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.mappers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.keycloak.models.ProtocolMapperModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.mappers.AbstractOIDCProtocolMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAccessTokenMapper;
import org.keycloak.protocol.oidc.mappers.OIDCAttributeMapperHelper;
import org.keycloak.protocol.oidc.mappers.OIDCIDTokenMapper;
import org.keycloak.protocol.oidc.mappers.TokenIntrospectionTokenMapper;
import org.keycloak.protocol.oidc.mappers.UserInfoTokenMapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.IDToken;

public class AddressMapper
extends AbstractOIDCProtocolMapper
implements OIDCAccessTokenMapper,
OIDCIDTokenMapper,
UserInfoTokenMapper,
TokenIntrospectionTokenMapper {
    private static final List<ProviderConfigProperty> configProperties = new ArrayList<ProviderConfigProperty>();
    public static final String STREET = "street";
    public static final String PROVIDER_ID = "oidc-address-mapper";

    protected static ProviderConfigProperty createConfigProperty(String claimName) {
        ProviderConfigProperty property = new ProviderConfigProperty();
        property.setName(AddressMapper.getModelPropertyName(claimName));
        property.setLabel("addressClaim." + claimName + ".label");
        property.setHelpText("addressClaim." + claimName + ".tooltip");
        property.setType("String");
        property.setDefaultValue((Object)claimName);
        return property;
    }

    public static String getModelPropertyName(String claimName) {
        return "user.attribute." + claimName;
    }

    public static ProtocolMapperModel createAddressMapper() {
        return AddressMapper.createAddressMapper(true, true, true, true);
    }

    public static ProtocolMapperModel createAddressMapper(boolean idToken, boolean accessToken, boolean userInfo, boolean introspectionEndpoint) {
        ProtocolMapperModel address = new ProtocolMapperModel();
        address.setName("address");
        address.setProtocolMapper(PROVIDER_ID);
        address.setProtocol("openid-connect");
        HashMap<String, String> config = new HashMap<String, String>();
        config.put("access.token.claim", Boolean.toString(accessToken));
        config.put("id.token.claim", Boolean.toString(idToken));
        config.put("userinfo.token.claim", Boolean.toString(userInfo));
        config.put("introspection.token.claim", Boolean.toString(introspectionEndpoint));
        config.put(AddressMapper.getModelPropertyName(STREET), STREET);
        config.put(AddressMapper.getModelPropertyName("locality"), "locality");
        config.put(AddressMapper.getModelPropertyName("region"), "region");
        config.put(AddressMapper.getModelPropertyName("postal_code"), "postal_code");
        config.put(AddressMapper.getModelPropertyName("country"), "country");
        config.put(AddressMapper.getModelPropertyName("formatted"), "formatted");
        address.setConfig(config);
        return address;
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return configProperties;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "User Address";
    }

    public String getDisplayCategory() {
        return "Token mapper";
    }

    public String getHelpText() {
        return "Maps user address attributes (street, locality, region, postal_code, and country) to the OpenID Connect 'address' claim.";
    }

    @Override
    protected void setClaim(IDToken token, ProtocolMapperModel mappingModel, UserSessionModel userSession) {
        UserModel user = userSession.getUser();
        Map addressSet = Optional.ofNullable(token.getAddressClaimsMap()).orElseGet(() -> Optional.ofNullable(token.getOtherClaims().get("address")).filter(Map.class::isInstance).map(o -> (HashMap)o).orElseGet(HashMap::new));
        Optional.ofNullable(this.getUserModelAttributeValue(user, mappingModel, STREET)).ifPresent(street -> addressSet.put("street_address", street));
        Optional.ofNullable(this.getUserModelAttributeValue(user, mappingModel, "locality")).ifPresent(locality -> addressSet.put("locality", locality));
        Optional.ofNullable(this.getUserModelAttributeValue(user, mappingModel, "region")).ifPresent(region -> addressSet.put("region", region));
        Optional.ofNullable(this.getUserModelAttributeValue(user, mappingModel, "postal_code")).ifPresent(postalCode -> addressSet.put("postal_code", postalCode));
        Optional.ofNullable(this.getUserModelAttributeValue(user, mappingModel, "country")).ifPresent(country -> addressSet.put("country", country));
        Optional.ofNullable(this.getUserModelAttributeValue(user, mappingModel, "formatted")).ifPresent(formatted -> addressSet.put("formatted", formatted));
        if (!addressSet.isEmpty()) {
            token.setAddress(addressSet);
        }
    }

    private String getUserModelAttributeValue(UserModel user, ProtocolMapperModel mappingModel, String claim) {
        String modelPropertyName = AddressMapper.getModelPropertyName(claim);
        String userAttrName = (String)mappingModel.getConfig().get(modelPropertyName);
        if (userAttrName == null) {
            userAttrName = claim;
        }
        return user.getFirstAttribute(userAttrName);
    }

    static {
        OIDCAttributeMapperHelper.addIncludeInTokensConfig(configProperties, AddressMapper.class);
        configProperties.add(AddressMapper.createConfigProperty(STREET));
        configProperties.add(AddressMapper.createConfigProperty("locality"));
        configProperties.add(AddressMapper.createConfigProperty("region"));
        configProperties.add(AddressMapper.createConfigProperty("postal_code"));
        configProperties.add(AddressMapper.createConfigProperty("country"));
        configProperties.add(AddressMapper.createConfigProperty("formatted"));
    }
}

