/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ActionManager {
    private static final ActionManager _theManager = new ActionManager();
    private final Map<Uid, BasicAction> _allActions = new ConcurrentHashMap<Uid, BasicAction>();

    public static ActionManager manager() {
        return _theManager;
    }

    public void put(BasicAction act) {
        this._allActions.put(act.get_uid(), act);
    }

    public BasicAction get(Uid id) {
        return this._allActions.get(id);
    }

    public void remove(Uid id) {
        this._allActions.remove(id);
    }

    public int getNumberOfInflightTransactions() {
        return (int)this._allActions.entrySet().parallelStream().filter(entry -> ((BasicAction)entry.getValue()).status() == 0).count();
    }

    private ActionManager() {
    }
}

