/*
 * Decompiled with CFR 0.152.
 */
package jakarta.xml.bind;

import jakarta.xml.bind.Binder;
import jakarta.xml.bind.ContextFinder;
import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.JAXBIntrospector;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.SchemaOutputResolver;
import jakarta.xml.bind.Unmarshaller;
import java.io.IOException;
import java.security.AccessController;
import java.util.Collections;
import java.util.Map;
import org.w3c.dom.Node;

public abstract class JAXBContext {
    public static final String JAXB_CONTEXT_FACTORY = "jakarta.xml.bind.JAXBContextFactory";

    protected JAXBContext() {
    }

    public static JAXBContext newInstance(String contextPath) throws JAXBException {
        return JAXBContext.newInstance(contextPath, JAXBContext.getContextClassLoader());
    }

    public static JAXBContext newInstance(String contextPath, ClassLoader classLoader) throws JAXBException {
        return JAXBContext.newInstance(contextPath, classLoader, Collections.emptyMap());
    }

    public static JAXBContext newInstance(String contextPath, ClassLoader classLoader, Map<String, ?> properties) throws JAXBException {
        return ContextFinder.find(JAXB_CONTEXT_FACTORY, contextPath, classLoader, properties);
    }

    public static JAXBContext newInstance(Class<?> ... classesToBeBound) throws JAXBException {
        return JAXBContext.newInstance(classesToBeBound, Collections.emptyMap());
    }

    public static JAXBContext newInstance(Class<?>[] classesToBeBound, Map<String, ?> properties) throws JAXBException {
        if (classesToBeBound == null) {
            throw new IllegalArgumentException();
        }
        for (int i = classesToBeBound.length - 1; i >= 0; --i) {
            if (classesToBeBound[i] != null) continue;
            throw new IllegalArgumentException();
        }
        return ContextFinder.find(classesToBeBound, properties);
    }

    public abstract Unmarshaller createUnmarshaller() throws JAXBException;

    public abstract Marshaller createMarshaller() throws JAXBException;

    public <T> Binder<T> createBinder(Class<T> domType) {
        throw new UnsupportedOperationException();
    }

    public Binder<Node> createBinder() {
        return this.createBinder(Node.class);
    }

    public JAXBIntrospector createJAXBIntrospector() {
        throw new UnsupportedOperationException();
    }

    public void generateSchema(SchemaOutputResolver outputResolver) throws IOException {
        throw new UnsupportedOperationException();
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(() -> Thread.currentThread().getContextClassLoader());
    }
}

