/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.keybinding;

import java.util.Map;
import org.jboss.logging.Logger;
import org.keycloak.jose.jwk.JWK;
import org.keycloak.protocol.oid4vc.issuance.keybinding.AttestationKeyResolver;

public class StaticAttestationKeyResolver
implements AttestationKeyResolver {
    private static final Logger logger = Logger.getLogger(StaticAttestationKeyResolver.class);
    private final Map<String, JWK> trustedKeys;

    public StaticAttestationKeyResolver(Map<String, JWK> trustedKeys) {
        this.trustedKeys = trustedKeys;
    }

    @Override
    public JWK resolveKey(String kid, Map<String, Object> header, Map<String, Object> payload) {
        JWK key = this.trustedKeys.get(kid);
        if (key == null) {
            logger.warnf("Key with kid '%s' not found in trusted static key registry", (Object)kid);
        }
        return key;
    }
}

