/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.vcs.log.ui.frame;

import com.intellij.diff.impl.DiffEditorViewer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.DiffPreview;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.JBColor;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.navigation.History;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.util.ui.table.ComponentsListFocusTraversalPolicy;
import com.intellij.vcs.log.CommitId;
import com.intellij.vcs.log.VcsFullCommitDetails;
import com.intellij.vcs.log.VcsShortCommitDetails;
import com.intellij.vcs.log.data.VcsLogData;
import com.intellij.vcs.log.impl.CommonUiProperties;
import com.intellij.vcs.log.impl.MainVcsLogUiProperties;
import com.intellij.vcs.log.impl.VcsLogNavigationUtil;
import com.intellij.vcs.log.ui.AbstractVcsLogUi;
import com.intellij.vcs.log.ui.VcsLogColorManager;
import com.intellij.vcs.log.ui.details.CommitDetailsListPanel;
import com.intellij.vcs.log.ui.details.commit.CommitDetailsPanel;
import com.intellij.vcs.log.ui.filter.VcsLogFilterUiEx;
import com.intellij.vcs.log.ui.frame.CommitDetailsLoader;
import com.intellij.vcs.log.ui.frame.FrameDiffPreview;
import com.intellij.vcs.log.ui.frame.VcsLogChangesBrowser;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDetails;
import com.intellij.vcs.log.ui.frame.VcsLogCommitSelectionListenerForDiff;
import com.intellij.vcs.log.ui.frame.VcsLogComponents;
import com.intellij.vcs.log.ui.frame.VcsLogEditorDiffPreview;
import com.intellij.vcs.log.ui.table.VcsLogGraphTable;
import com.intellij.vcs.log.ui.table.VcsLogTableCommitSelectionListener;
import com.intellij.vcs.log.util.VcsLogUiUtil;
import com.intellij.vcs.log.util.VcsLogUtil;
import com.intellij.vcs.log.visible.VisiblePack;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MainFrame
extends JPanel
implements UiDataProvider,
Disposable {
    @NonNls
    private static final String DIFF_SPLITTER_PROPORTION = "vcs.log.diff.splitter.proportion";
    @NonNls
    private static final String DETAILS_SPLITTER_PROPORTION = "vcs.log.details.splitter.proportion";
    @NonNls
    private static final String CHANGES_SPLITTER_PROPORTION = "vcs.log.changes.splitter.proportion";
    @NotNull
    private final VcsLogData myLogData;
    @NotNull
    private final MainVcsLogUiProperties myUiProperties;
    @NotNull
    private final JComponent myToolbar;
    @NotNull
    private final VcsLogGraphTable myGraphTable;
    @NotNull
    private final VcsLogFilterUiEx myFilterUi;
    @NotNull
    private final VcsLogChangesBrowser myChangesBrowser;
    @NotNull
    private final Splitter myChangesBrowserSplitter;
    @NotNull
    private final CommitDetailsListPanel myDetailsPanel;
    @NotNull
    private final Splitter myDetailsSplitter;
    @NotNull
    private final EditorNotificationPanel myNotificationLabel;
    @NotNull
    private final History myHistory;
    private boolean myIsLoading;
    @Nullable
    private FilePath myPathToSelect;
    @NotNull
    private final FrameDiffPreview myDiffPreview;

    public MainFrame(@NotNull VcsLogData logData, @NotNull AbstractVcsLogUi logUi, @NotNull MainVcsLogUiProperties uiProperties, @NotNull VcsLogFilterUiEx filterUi, @NotNull VcsLogColorManager colorManager, boolean withEditorDiffPreview, @NotNull Disposable disposable) {
        if (logData == null) {
            MainFrame.$$$reportNull$$$0(0);
        }
        if (logUi == null) {
            MainFrame.$$$reportNull$$$0(1);
        }
        if (uiProperties == null) {
            MainFrame.$$$reportNull$$$0(2);
        }
        if (filterUi == null) {
            MainFrame.$$$reportNull$$$0(3);
        }
        if (colorManager == null) {
            MainFrame.$$$reportNull$$$0(4);
        }
        if (disposable == null) {
            MainFrame.$$$reportNull$$$0(5);
        }
        this.myPathToSelect = null;
        this.myLogData = logData;
        this.myUiProperties = uiProperties;
        this.myFilterUi = filterUi;
        this.myGraphTable = VcsLogComponents.createTable(logData, logUi, filterUi, colorManager, disposable);
        this.myDetailsPanel = new CommitDetailsListPanel(logData.getProject(), this, (Function0<CommitDetailsPanel>)((Function0)() -> new CommitDetailsPanel((Function1<? super CommitId, Unit>)((Function1)commit -> {
            VcsLogNavigationUtil.jumpToCommit(logUi, commit.getHash(), commit.getRoot(), false, true);
            return Unit.INSTANCE;
        }))));
        final CommitDetailsLoader<VcsFullCommitDetails> commitDetailsLoader = new CommitDetailsLoader<VcsFullCommitDetails>(logData.getCommitDetailsGetter(), this);
        VcsLogCommitSelectionListenerForDetails listenerForDetails = new VcsLogCommitSelectionListenerForDetails(logData, colorManager, this.myDetailsPanel, this);
        commitDetailsLoader.addListener(listenerForDetails);
        this.myChangesBrowser = new VcsLogChangesBrowser(logData.getProject(), this.myUiProperties, (Function1<? super CommitId, ? extends VcsShortCommitDetails>)((Function1)commitId -> {
            int index = this.myLogData.getCommitIndex(commitId.getHash(), commitId.getRoot());
            return this.myLogData.getMiniDetailsGetter().getCachedDataOrPlaceholder(index);
        }), this);
        this.myChangesBrowser.setShowDiffActionPreview((DiffPreview)(withEditorDiffPreview ? new VcsLogEditorDiffPreview(this.myChangesBrowser) : null));
        this.myChangesBrowser.getDiffAction().registerCustomShortcutSet(this.myChangesBrowser.getDiffAction().getShortcutSet(), (JComponent)((Object)this.getGraphTable()));
        JBLoadingPanel changesLoadingPane = new JBLoadingPanel(new BorderLayout(), this, 300){

            public Dimension getMinimumSize() {
                return VcsLogUiUtil.expandToFitToolbar(super.getMinimumSize(), MainFrame.this.myChangesBrowser.getToolbar().getComponent());
            }
        };
        changesLoadingPane.add((Component)((Object)this.myChangesBrowser));
        this.myToolbar = this.createActionsToolbar();
        this.myChangesBrowser.setToolbarHeightReferent(this.myToolbar);
        VcsLogCommitSelectionListenerForDiff commitSelectionListener = new VcsLogCommitSelectionListenerForDiff(changesLoadingPane, this.myChangesBrowser){

            @Override
            public void onLoadingStopped() {
                super.onLoadingStopped();
                MainFrame.this.myIsLoading = false;
                if (MainFrame.this.myPathToSelect != null) {
                    MainFrame.this.myChangesBrowser.selectFile(MainFrame.this.myPathToSelect);
                    MainFrame.this.myPathToSelect = null;
                }
            }
        };
        commitDetailsLoader.addListener(commitSelectionListener);
        VcsLogTableCommitSelectionListener tableCommitSelectionListener = new VcsLogTableCommitSelectionListener(this.myGraphTable){

            @Override
            protected void handleSelection(@NotNull @NotNull List<@NotNull Integer> commitIds2) {
                if (commitIds2 == null) {
                    3.$$$reportNull$$$0(0);
                }
                commitDetailsLoader.loadDetails(commitIds2);
            }

            @Override
            protected void onHandlingScheduled() {
                MainFrame.this.myIsLoading = true;
                MainFrame.this.myPathToSelect = null;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commitIds", "com/intellij/vcs/log/ui/frame/MainFrame$3", "handleSelection"));
            }
        };
        this.myGraphTable.getSelectionModel().addListSelectionListener(tableCommitSelectionListener);
        Disposer.register((Disposable)disposable, () -> this.myGraphTable.getSelectionModel().removeListSelectionListener(tableCommitSelectionListener));
        this.myNotificationLabel = new EditorNotificationPanel(UIUtil.getPanelBackground(), EditorNotificationPanel.Status.Warning);
        this.myNotificationLabel.setVisible(false);
        this.myNotificationLabel.setBorder((Border)new CompoundBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)1, (int)0, (int)0, (int)0), (Border)ObjectUtils.notNull((Object)this.myNotificationLabel.getBorder(), (Object)JBUI.Borders.empty())));
        BorderLayoutPanel toolbars = new BorderLayoutPanel();
        toolbars.add((Component)this.myToolbar, "North");
        toolbars.add((Component)this.myNotificationLabel, "Center");
        JPanel toolbarsAndTable = new JPanel(new BorderLayout());
        toolbarsAndTable.add((Component)toolbars, "North");
        JComponent tableWithProgress = VcsLogUiUtil.installScrollingAndProgress(this.myGraphTable, this);
        toolbarsAndTable.add((Component)tableWithProgress, "Center");
        this.myDetailsSplitter = new OnePixelSplitter(true, DETAILS_SPLITTER_PROPORTION, 0.7f);
        this.myDetailsSplitter.setFirstComponent((JComponent)changesLoadingPane);
        this.showDetails(this.myUiProperties.get(CommonUiProperties.SHOW_DETAILS));
        this.myChangesBrowserSplitter = new OnePixelSplitter(false, CHANGES_SPLITTER_PROPORTION, 0.7f);
        this.myChangesBrowserSplitter.setFirstComponent((JComponent)toolbarsAndTable);
        this.myChangesBrowserSplitter.setSecondComponent((JComponent)this.myDetailsSplitter);
        this.setLayout(new BorderLayout());
        this.myDiffPreview = new FrameDiffPreview(this.myUiProperties, (JComponent)this.myChangesBrowserSplitter, DIFF_SPLITTER_PROPORTION, 0.7f, this){

            @Override
            @NotNull
            protected DiffEditorViewer createViewer() {
                DiffEditorViewer processor = MainFrame.this.myChangesBrowser.createChangeProcessor(false);
                processor.setToolbarVerticalSizeReferent(MainFrame.this.getToolbar());
                DiffEditorViewer diffEditorViewer = processor;
                if (diffEditorViewer == null) {
                    4.$$$reportNull$$$0(0);
                }
                return diffEditorViewer;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$4", "createViewer"));
            }
        };
        this.add(this.myDiffPreview.getMainComponent());
        this.myHistory = VcsLogUiUtil.installNavigationHistory(logUi, this.myGraphTable);
        Disposer.register((Disposable)disposable, (Disposable)this);
        this.setFocusCycleRoot(true);
        this.setFocusTraversalPolicy((FocusTraversalPolicy)((Object)new MyFocusPolicy()));
    }

    public void setExplanationHtml(@NlsContexts.LinkLabel @Nullable String text) {
        this.myNotificationLabel.setText(Objects.requireNonNullElse(text, ""));
        this.myNotificationLabel.setVisible(text != null);
    }

    public void updateDataPack(@NotNull VisiblePack dataPack, boolean permGraphChanged) {
        if (dataPack == null) {
            MainFrame.$$$reportNull$$$0(6);
        }
        this.myFilterUi.updateDataPack(dataPack);
        this.myGraphTable.updateDataPack(dataPack, permGraphChanged);
        this.myChangesBrowser.setAffectedPaths(VcsLogUtil.getAffectedPaths(dataPack));
    }

    @NotNull
    public VcsLogGraphTable getGraphTable() {
        VcsLogGraphTable vcsLogGraphTable = this.myGraphTable;
        if (vcsLogGraphTable == null) {
            MainFrame.$$$reportNull$$$0(7);
        }
        return vcsLogGraphTable;
    }

    @NotNull
    public VcsLogFilterUiEx getFilterUi() {
        VcsLogFilterUiEx vcsLogFilterUiEx = this.myFilterUi;
        if (vcsLogFilterUiEx == null) {
            MainFrame.$$$reportNull$$$0(8);
        }
        return vcsLogFilterUiEx;
    }

    @NotNull
    protected JComponent createActionsToolbar() {
        JComponent jComponent = VcsLogComponents.createActionsToolbar(this.myGraphTable, this.myFilterUi);
        if (jComponent == null) {
            MainFrame.$$$reportNull$$$0(9);
        }
        return jComponent;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            MainFrame.$$$reportNull$$$0(10);
        }
        Change[] changes = this.myChangesBrowser.getDirectChanges().toArray(Change.EMPTY_CHANGE_ARRAY);
        sink.set(VcsDataKeys.CHANGES, (Object)changes);
        sink.set(VcsDataKeys.SELECTED_CHANGES, (Object)changes);
        VcsLogComponents.collectLogKeys(sink, this.myUiProperties, this.myGraphTable, this.myHistory, this.myFilterUi, this.myToolbar, this);
    }

    @NotNull
    public JComponent getToolbar() {
        JComponent jComponent = this.myToolbar;
        if (jComponent == null) {
            MainFrame.$$$reportNull$$$0(11);
        }
        return jComponent;
    }

    @NotNull
    public VcsLogChangesBrowser getChangesBrowser() {
        VcsLogChangesBrowser vcsLogChangesBrowser = this.myChangesBrowser;
        if (vcsLogChangesBrowser == null) {
            MainFrame.$$$reportNull$$$0(12);
        }
        return vcsLogChangesBrowser;
    }

    public void showDetails(boolean state) {
        this.myDetailsSplitter.setSecondComponent((JComponent)((Object)(state ? this.myDetailsPanel : null)));
    }

    public void selectFilePath(@NotNull FilePath filePath, boolean requestFocus) {
        if (filePath == null) {
            MainFrame.$$$reportNull$$$0(13);
        }
        if (this.myIsLoading) {
            this.myPathToSelect = filePath;
        } else {
            this.myChangesBrowser.selectFile(filePath);
            this.myPathToSelect = null;
        }
        if (requestFocus) {
            this.myChangesBrowser.getViewer().requestFocus();
        }
    }

    public void dispose() {
        this.myDetailsSplitter.dispose();
        this.myChangesBrowserSplitter.dispose();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 9, 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logData";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logUi";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uiProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filterUi";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorManager";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataPack";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/vcs/log/ui/frame/MainFrame";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getGraphTable";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilterUi";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionsToolbar";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getToolbar";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChangesBrowser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "updateDataPack";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 12: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 9, 11, 12 -> new IllegalStateException(string);
        };
    }

    private class MyFocusPolicy
    extends ComponentsListFocusTraversalPolicy {
        private MyFocusPolicy() {
        }

        @NotNull
        protected List<Component> getOrderedComponents() {
            List list = ContainerUtil.skipNulls(Arrays.asList(MainFrame.this.myGraphTable, MainFrame.this.myChangesBrowser.getPreferredFocusedComponent(), MainFrame.this.myDiffPreview.getPreferredFocusedComponent(), MainFrame.this.myFilterUi.getTextFilterComponent().getFocusedComponent()));
            if (list == null) {
                MyFocusPolicy.$$$reportNull$$$0(0);
            }
            return list;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/vcs/log/ui/frame/MainFrame$MyFocusPolicy", "getOrderedComponents"));
        }
    }
}

