/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes.actions;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0010\u0011\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\u0018\u001a\u00020\u00192\u000e\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001bJ\u001b\u0010\u001c\u001a\u00020\u00192\u000e\u0010\u001d\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\u001a\u00a2\u0006\u0002\u0010\u001eJ\u0010\u0010\u001f\u001a\u00020\u00192\u0006\u0010 \u001a\u00020!H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000fR\u0017\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u000fR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017\u00a8\u0006\""}, d2={"Lcom/intellij/openapi/vcs/changes/actions/MoveChangesHandler;", "", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "changeListManager", "Lcom/intellij/openapi/vcs/changes/ChangeListManager;", "Lorg/jetbrains/annotations/NotNull;", "unversionedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "getUnversionedFiles", "()Ljava/util/List;", "changedFiles", "getChangedFiles", "changes", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "isEmpty", "", "()Z", "addChanges", "", "", "([Lcom/intellij/openapi/vcs/changes/Change;)V", "addChangesForFiles", "files", "([Lcom/intellij/openapi/vfs/VirtualFile;)V", "addChangesUnder", "path", "Lcom/intellij/openapi/vcs/FilePath;", "intellij.platform.vcs.impl"})
@SourceDebugExtension(value={"SMAP\nMoveChangesToAnotherListAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MoveChangesToAnotherListAction.kt\ncom/intellij/openapi/vcs/changes/actions/MoveChangesHandler\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,196:1\n18#2:197\n18#2:198\n1#3:199\n*S KotlinDebug\n*F\n+ 1 MoveChangesToAnotherListAction.kt\ncom/intellij/openapi/vcs/changes/actions/MoveChangesHandler\n*L\n159#1:197\n163#1:198\n*E\n"})
final class MoveChangesHandler {
    @NotNull
    private final Project project;
    @NotNull
    private final ChangeListManager changeListManager;
    @NotNull
    private final List<VirtualFile> unversionedFiles;
    @NotNull
    private final List<VirtualFile> changedFiles;
    @NotNull
    private final List<Change> changes;

    public MoveChangesHandler(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(...)");
        this.changeListManager = changeListManager;
        this.unversionedFiles = new ArrayList();
        this.changedFiles = new ArrayList();
        this.changes = new ArrayList();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final List<VirtualFile> getUnversionedFiles() {
        return this.unversionedFiles;
    }

    @NotNull
    public final List<VirtualFile> getChangedFiles() {
        return this.changedFiles;
    }

    @NotNull
    public final List<Change> getChanges() {
        return this.changes;
    }

    public final boolean isEmpty() {
        return this.changes.isEmpty() && this.unversionedFiles.isEmpty();
    }

    public final void addChanges(@Nullable Change[] changes) {
        Collection collection = this.changes;
        Object[] $this$orEmpty$iv = changes;
        boolean $i$f$orEmpty = false;
        Object[] objectArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            objectArray = new Change[]{};
        }
        CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
    }

    public final void addChangesForFiles(@Nullable VirtualFile[] files) {
        VirtualFile[] $this$orEmpty$iv = files;
        boolean $i$f$orEmpty = false;
        VirtualFile[] virtualFileArray = $this$orEmpty$iv;
        if ($this$orEmpty$iv == null) {
            virtualFileArray = new VirtualFile[]{};
        }
        for (VirtualFile file : virtualFileArray) {
            Change change = this.changeListManager.getChange(file);
            if (change == null) {
                FileStatus status;
                Intrinsics.checkNotNullExpressionValue((Object)this.changeListManager.getStatus(file), (String)"getStatus(...)");
                if (Intrinsics.areEqual((Object)FileStatus.UNKNOWN, (Object)status)) {
                    this.unversionedFiles.add(file);
                    this.changedFiles.add(file);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)FileStatus.NOT_CHANGED, (Object)status) || !file.isDirectory()) continue;
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                this.addChangesUnder(filePath);
                continue;
            }
            FilePath afterPath = ChangesUtil.getAfterPath((Change)change);
            if (afterPath != null && afterPath.isDirectory()) {
                this.addChangesUnder(afterPath);
                continue;
            }
            this.changes.add(change);
            this.changedFiles.add(file);
        }
    }

    private final void addChangesUnder(FilePath path) {
        for (Change change : this.changeListManager.getChangesIn(path)) {
            VirtualFile it;
            VirtualFile file;
            Intrinsics.checkNotNull((Object)change);
            this.changes.add(change);
            FilePath filePath = ChangesUtil.getAfterPath((Change)change);
            Object object = file = filePath != null ? filePath.getVirtualFile() : null;
            if (file == null) continue;
            boolean bl = false;
            this.changedFiles.add(it);
        }
    }
}

