/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.svn.update;

import com.intellij.DynamicBundle;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.svn.SvnBundle;
import org.jetbrains.idea.svn.SvnConfiguration;
import org.jetbrains.idea.svn.SvnUtil;
import org.jetbrains.idea.svn.SvnVcs;
import org.jetbrains.idea.svn.api.Url;
import org.jetbrains.idea.svn.commandLine.SvnBindException;
import org.jetbrains.idea.svn.dialogs.SelectLocationDialog;
import org.jetbrains.idea.svn.update.MergeRootInfo;
import org.jetbrains.idea.svn.update.SvnPanel;
import org.jetbrains.idea.svn.update.SvnRevisionPanel;

public class SvnIntegrateRootOptionsPanel
implements SvnPanel {
    private TextFieldWithBrowseButton myMergeText1;
    private TextFieldWithBrowseButton myMergeText2;
    private JPanel myPanel;
    private SvnRevisionPanel myRevision2;
    private SvnRevisionPanel myRevision1;
    @NotNull
    private final FilePath myRoot;
    @NotNull
    private final SvnVcs myVcs;

    public SvnIntegrateRootOptionsPanel(@NotNull SvnVcs vcs, @NotNull FilePath root) {
        if (vcs == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(0);
        }
        if (root == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(1);
        }
        this.myRoot = root;
        this.myVcs = vcs;
        this.$$$setupUI$$$();
        this.setupUrlField(this.myMergeText1);
        this.setupUrlField(this.myMergeText2);
        this.setupRevisionField(this.myRevision1, this.myMergeText1);
        this.setupRevisionField(this.myRevision2, this.myMergeText2);
    }

    private void setupUrlField(@NotNull TextFieldWithBrowseButton textField) {
        if (textField == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(2);
        }
        textField.setEditable(true);
        textField.addActionListener(e -> {
            try {
                Url url = SvnUtil.createUrl(textField.getText(), false);
                Url selectedUrl = SelectLocationDialog.selectLocation(this.myVcs.getProject(), url);
                if (selectedUrl != null) {
                    textField.setText(selectedUrl.toDecodedString());
                }
            }
            catch (SvnBindException ex) {
                Messages.showErrorDialog((Project)this.myVcs.getProject(), (String)ex.getMessage(), (String)SvnBundle.message("dialog.title.select.repository.location", new Object[0]));
            }
        });
    }

    private void setupRevisionField(@NotNull SvnRevisionPanel revisionField, @NotNull TextFieldWithBrowseButton textField) {
        if (revisionField == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(3);
        }
        if (textField == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(4);
        }
        revisionField.setProject(this.myVcs.getProject());
        revisionField.setRoot(this.myRoot.getVirtualFile());
        revisionField.setUrlProvider((ThrowableComputable<Url, SvnBindException>)((ThrowableComputable)() -> SvnUtil.createUrl(textField.getText(), false)));
    }

    @Override
    public void apply(@NotNull SvnConfiguration conf) throws ConfigurationException {
        if (conf == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(5);
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myMergeText1.getText())) {
            this.myMergeText1.requestFocus();
            throw new ConfigurationException(SvnBundle.message("source.url.could.not.be.empty.error.message", new Object[0]));
        }
        if (StringUtil.isEmptyOrSpaces((String)this.myMergeText2.getText())) {
            this.myMergeText2.requestFocus();
            throw new ConfigurationException(SvnBundle.message("source.url.could.not.be.empty.error.message", new Object[0]));
        }
        if (this.myMergeText1.getText().equals(this.myMergeText2.getText()) && this.myRevision1.getRevisionText().equals(this.myRevision2.getRevisionText())) {
            throw new ConfigurationException(SvnBundle.message("no.differences.between.sources.error.message", new Object[0]));
        }
        MergeRootInfo rootInfo = conf.getMergeRootInfo(this.myRoot.getIOFile(), this.myVcs);
        rootInfo.setUrl1(this.myMergeText1.getText());
        rootInfo.setUrl2(this.myMergeText2.getText());
        rootInfo.setRevision1(this.myRevision1.getRevision());
        rootInfo.setRevision2(this.myRevision2.getRevision());
    }

    @Override
    public boolean canApply() {
        return !this.myMergeText1.getText().equals(this.myMergeText2.getText()) || !this.myRevision1.getRevisionText().equals(this.myRevision2.getRevisionText());
    }

    @Override
    @NotNull
    public JPanel getPanel() {
        JPanel jPanel = this.myPanel;
        if (jPanel == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(6);
        }
        return jPanel;
    }

    @Override
    public void reset(@NotNull SvnConfiguration config) {
        if (config == null) {
            SvnIntegrateRootOptionsPanel.$$$reportNull$$$0(7);
        }
        MergeRootInfo rootInfo = config.getMergeRootInfo(this.myRoot.getIOFile(), this.myVcs);
        this.myRevision1.setRevision(rootInfo.getRevision1());
        this.myRevision2.setRevision(rootInfo.getRevision2());
        this.myMergeText1.setText(rootInfo.getUrlString1());
        this.myMergeText2.setText(rootInfo.getUrlString2());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        SvnRevisionPanel svnRevisionPanel;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        SvnRevisionPanel svnRevisionPanel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        JLabel jLabel = new JLabel();
        this.$$$loadLabelText$$$(jLabel, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegrateRootOptionsPanel.class).getString("integrate.configuration.description.label"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 7, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.$$$loadLabelText$$$(jLabel2, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegrateRootOptionsPanel.class).getString("integrate.configuration.source1.label"));
        jPanel3.add((Component)jLabel2, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMergeText1 = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        jPanel3.add((Component)textFieldWithBrowseButton2, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, new Dimension(250, -1), null, null));
        JLabel jLabel3 = new JLabel();
        this.$$$loadLabelText$$$(jLabel3, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegrateRootOptionsPanel.class).getString("integrate.configuration.revision1.label"));
        jPanel3.add((Component)jLabel3, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRevision1 = svnRevisionPanel2 = new SvnRevisionPanel();
        jPanel3.add((Component)svnRevisionPanel2, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(1, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel4, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel4 = new JLabel();
        this.$$$loadLabelText$$$(jLabel4, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegrateRootOptionsPanel.class).getString("integrate.configuration.source2.label"));
        jPanel4.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMergeText2 = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel4.add((Component)textFieldWithBrowseButton, new GridConstraints(0, 1, 1, 1, 0, 1, 7, 0, new Dimension(250, -1), null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, DynamicBundle.getBundle((String)"messages/SvnBundle", SvnIntegrateRootOptionsPanel.class).getString("integrate.configuration.revision2.label"));
        jPanel4.add((Component)jLabel5, new GridConstraints(0, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myRevision2 = svnRevisionPanel = new SvnRevisionPanel();
        jPanel4.add((Component)svnRevisionPanel, new GridConstraints(0, 3, 1, 1, 0, 0, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        jLabel2.setLabelFor((Component)textFieldWithBrowseButton2);
        jLabel4.setLabelFor((Component)textFieldWithBrowseButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "textField";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "revisionField";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "conf";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/svn/update/SvnIntegrateRootOptionsPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "config";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/svn/update/SvnIntegrateRootOptionsPanel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPanel";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setupUrlField";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setupRevisionField";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "apply";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6 -> new IllegalStateException(string);
        };
    }
}

