/**
 * @type {import('unified').Plugin<[Options]>}
 * @returns {(tree: Node, file: VFile) => void}
 */
export default function messageControl(
  options: Options
): (tree: Node, file: VFile) => void
export type Node = import('unist').Node
export type Parent = import('unist').Parent
export type Point = import('unist').Point
export type Test = import('unist-util-is').Test
export type VFile = import('vfile').VFile
export type VFileMessage = import('vfile-message').VFileMessage
export type Options = OptionsWithoutReset | OptionsWithReset
export type OptionsWithoutReset = OptionsBaseFields & OptionsWithoutResetFields
export type OptionsWithReset = OptionsBaseFields & OptionsWithResetFields
export type OptionsWithoutResetFields = {
  /**
   * Whether to treat all messages as turned off initially.
   */
  reset?: false | undefined
  /**
   * List of `ruleId`s to turn off.
   */
  disable?: string[] | undefined
}
export type OptionsWithResetFields = {
  /**
   * Whether to treat all messages as turned off initially.
   */
  reset: true
  /**
   * List of `ruleId`s to initially turn on.
   */
  enable?: string[] | undefined
}
export type OptionsBaseFields = {
  /**
   * Name of markers that can control the message sources.
   *
   * For example, `{name: 'alpha'}` controls `alpha` markers:
   *
   * ```html
   * <!--alpha ignore-->
   * ```
   */
  name: string
  /**
   * Parse a possible marker to a comment marker object (Marker).
   * If the marker isn't a marker, should return `null`.
   */
  marker: MarkerParser
  /**
   * Test for possible markers
   */
  test?: Test
  /**
   * List of allowed `ruleId`s. When given a warning is shown
   * when someone tries to control an unknown rule.
   *
   * For example, `{name: 'alpha', known: ['bravo']}` results in a warning if
   * `charlie` is configured:
   *
   * ```html
   * <!--alpha ignore charlie-->
   * ```
   */
  known?: string[] | undefined
  /**
   * Sources that can be controlled with `name` markers.
   * Defaults to `name`.
   */
  source?: string | string[] | undefined
}
/**
 * Parse a possible comment marker node to a Marker.
 */
export type MarkerParser = (node: Node) => any
/**
 * A comment marker.
 */
export type Marker = {
  /**
   * Name of marker.
   */
  name: string
  /**
   * Value after name.
   */
  attributes: string
  /**
   * Parsed attributes.
   */
  parameters: Record<string, string | number | boolean>
  /**
   * Reference to given node.
   */
  node: Node
}
export type Mark = {
  point: Point | undefined
  state: boolean
}
