/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.resolve;

import org.gradle.api.UnknownProjectException;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.project.ProjectRegistry;
import org.gradle.api.internal.resolve.ProjectModelResolver;
import org.gradle.model.internal.registry.ModelRegistry;

public class DefaultProjectModelResolver
implements ProjectModelResolver {
    private final ProjectRegistry delegate;

    public DefaultProjectModelResolver(ProjectRegistry delegate) {
        this.delegate = delegate;
    }

    @Override
    public ModelRegistry resolveProjectModel(String path) {
        ProjectInternal projectInternal = this.delegate.getProjectInternal(path);
        if (projectInternal == null) {
            throw new UnknownProjectException("Project with path '" + path + "' not found.");
        }
        return (ModelRegistry)projectInternal.getOwner().fromMutableState(project -> {
            project.prepareForRuleBasedPlugins();
            project.evaluateUnchecked();
            project.getTasks().discoverTasks();
            return project.getModelRegistry();
        });
    }
}

