/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.concurrent.Executor;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Stream;
import net.rubygrapefruit.platform.ProcessLauncher;
import org.gradle.api.JavaVersion;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.internal.operations.BuildOperationRef;
import org.gradle.internal.operations.CurrentBuildOperationRef;
import org.gradle.process.internal.DefaultExecHandle;
import org.gradle.process.internal.ProcessBuilderFactory;
import org.gradle.process.internal.StreamsHandler;

public class ExecHandleRunner
implements Runnable {
    private static final Logger LOGGER = Logging.getLogger(ExecHandleRunner.class);
    private final ProcessBuilderFactory processBuilderFactory;
    private final DefaultExecHandle execHandle;
    private final Lock lock = new ReentrantLock();
    private final ProcessLauncher processLauncher;
    private final Executor executor;
    private Process process;
    private boolean aborted;
    private final StreamsHandler streamsHandler;
    private volatile BuildOperationRef associatedBuildOperation;

    public ExecHandleRunner(DefaultExecHandle execHandle, StreamsHandler streamsHandler, ProcessLauncher processLauncher, Executor executor, BuildOperationRef associatedBuildOperation) {
        if (execHandle == null) {
            throw new IllegalArgumentException("execHandle == null!");
        }
        this.execHandle = execHandle;
        this.streamsHandler = streamsHandler;
        this.processLauncher = processLauncher;
        this.executor = executor;
        this.associatedBuildOperation = associatedBuildOperation;
        this.processBuilderFactory = new ProcessBuilderFactory();
    }

    public void abortProcess() {
        this.lock.lock();
        try {
            if (this.aborted) {
                return;
            }
            this.aborted = true;
            if (this.process != null) {
                this.streamsHandler.disconnect();
                LOGGER.debug("Abort requested. Destroying process: {}.", (Object)this.execHandle.getDisplayName());
                this.destroyProcessTree();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void destroyProcessTree() {
        if (JavaVersion.current().isJava9Compatible()) {
            this.destroyDescendants();
        }
        this.process.destroy();
    }

    private void destroyDescendants() {
        try {
            Stream descendants = (Stream)Process.class.getMethod("descendants", new Class[0]).invoke((Object)this.process, new Object[0]);
            Method destroyMethod = Class.forName("java.lang.ProcessHandle").getMethod("destroy", new Class[0]);
            Iterator it = descendants.iterator();
            while (it.hasNext()) {
                destroyMethod.invoke(it.next(), new Object[0]);
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to destroy descendants of process: " + this.execHandle.getDisplayName(), e);
        }
    }

    @Override
    public void run() {
        try {
            CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> {
                this.startProcess();
                this.execHandle.started();
                LOGGER.debug("waiting until streams are handled...");
                this.streamsHandler.start();
            });
            if (this.execHandle.isDaemon()) {
                CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> {
                    this.streamsHandler.stop();
                    this.detached();
                });
            } else {
                int exitValue = this.process.waitFor();
                CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> {
                    this.streamsHandler.stop();
                    this.completed(exitValue);
                });
            }
        }
        catch (Throwable t) {
            CurrentBuildOperationRef.instance().with(this.associatedBuildOperation, () -> this.execHandle.failed(t));
        }
    }

    public void removeStartupContext() {
        this.associatedBuildOperation = null;
        this.streamsHandler.removeStartupContext();
    }

    private void startProcess() {
        this.lock.lock();
        try {
            if (this.aborted) {
                throw new IllegalStateException("Process has already been aborted");
            }
            ProcessBuilder processBuilder = this.processBuilderFactory.createProcessBuilder(this.execHandle);
            Process process = this.processLauncher.start(processBuilder);
            this.streamsHandler.connectStreams(process, this.execHandle.getDisplayName(), this.executor);
            this.process = process;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void completed(int exitValue) {
        if (this.aborted) {
            this.execHandle.aborted(exitValue);
        } else {
            this.execHandle.finished(exitValue);
        }
    }

    private void detached() {
        this.execHandle.detached();
    }
}

