/*
 * Decompiled with CFR 0.152.
 */
package org.jungrapht.visualization.spatial.rtree;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.jungrapht.visualization.spatial.rtree.AbstractSplitter;
import org.jungrapht.visualization.spatial.rtree.InnerNode;
import org.jungrapht.visualization.spatial.rtree.Node;
import org.jungrapht.visualization.spatial.rtree.Pair;
import org.jungrapht.visualization.spatial.rtree.Splitter;

public class QuadraticSplitter<T>
extends AbstractSplitter<T>
implements Splitter<T> {
    @Override
    public Pair<InnerNode<T>> split(List<Node<T>> children, Node<T> newEntry) {
        return this.quadraticSplit(children, newEntry);
    }

    private Pair<InnerNode<T>> quadraticSplit(List<Node<T>> children, Node<T> newEntry) {
        Pair<InnerNode<T>> pickedSeeds;
        block5: {
            ArrayList<Node<T>> entryList = new ArrayList<Node<T>>(children);
            entryList.add(newEntry);
            pickedSeeds = this.pickSeeds(entryList);
            while (entryList.size() > 0 && ((InnerNode)pickedSeeds.left).size() < 7 && ((InnerNode)pickedSeeds.right).size() < 7) {
                this.distributeEntry(entryList, pickedSeeds);
            }
            if (entryList.size() <= 0) break block5;
            if (((InnerNode)pickedSeeds.left).size() >= 7) {
                for (Node node : entryList) {
                    ((InnerNode)pickedSeeds.right).addVertex(node);
                }
            } else {
                for (Node node : entryList) {
                    ((InnerNode)pickedSeeds.left).addVertex(node);
                }
            }
        }
        return pickedSeeds;
    }

    private void distributeEntry(List<Node<T>> entries, Pair<InnerNode<T>> pickedSeeds) {
        Optional<Node<T>> nextOptional = this.pickNext(entries, pickedSeeds);
        if (nextOptional.isPresent()) {
            double rightEnlargement;
            Node<T> next = nextOptional.get();
            Rectangle2D leftBounds = ((InnerNode)pickedSeeds.left).getBounds();
            Rectangle2D rightBounds = ((InnerNode)pickedSeeds.right).getBounds();
            double leftArea = Node.area(leftBounds);
            double rightArea = Node.area(rightBounds);
            double leftEnlargement = Node.area(leftBounds.createUnion(next.getBounds())) - leftArea;
            if (leftEnlargement == (rightEnlargement = Node.area(rightBounds.createUnion(next.getBounds())) - rightArea)) {
                if (leftArea == rightArea) {
                    int rightKids;
                    int leftKids = ((InnerNode)pickedSeeds.left).size();
                    if (leftKids < (rightKids = ((InnerNode)pickedSeeds.right).size())) {
                        ((InnerNode)pickedSeeds.left).addVertex(next);
                    } else {
                        ((InnerNode)pickedSeeds.right).addVertex(next);
                    }
                } else if (leftArea < rightArea) {
                    ((InnerNode)pickedSeeds.left).addVertex(next);
                } else {
                    ((InnerNode)pickedSeeds.right).addVertex(next);
                }
            } else if (leftEnlargement < rightEnlargement) {
                ((InnerNode)pickedSeeds.left).addVertex(next);
            } else {
                ((InnerNode)pickedSeeds.right).addVertex(next);
            }
        }
    }

    private Pair<InnerNode<T>> pickSeeds(List<Node<T>> entryList) {
        double largestArea = 0.0;
        Optional<Object> winningPair = Optional.empty();
        for (int i = 0; i < entryList.size(); ++i) {
            for (int j = i + 1; j < entryList.size(); ++j) {
                Pair<Node<T>> entryPair = new Pair<Node<T>>(entryList.get(i), entryList.get(j));
                Rectangle2D union = ((Node)entryPair.left).getBounds().createUnion(((Node)entryPair.right).getBounds());
                double area = Node.area(union) - Node.area(((Node)entryPair.left).getBounds()) - Node.area(((Node)entryPair.right).getBounds());
                if (winningPair.isEmpty()) {
                    winningPair = Optional.of(entryPair);
                    largestArea = area;
                    continue;
                }
                if (!(area > largestArea)) continue;
                winningPair = Optional.of(entryPair);
            }
        }
        if (!winningPair.isPresent()) {
            throw new RuntimeException("No winning pair returned");
        }
        Node leftEntry = (Node)((Pair)winningPair.get()).left;
        InnerNode leftVertex = InnerNode.create(leftEntry);
        Node rightEntry = (Node)((Pair)winningPair.get()).right;
        InnerNode rightVertex = InnerNode.create(rightEntry);
        entryList.remove(leftEntry);
        entryList.remove(rightEntry);
        return new Pair(leftVertex, rightVertex);
    }

    private Optional<Node<T>> pickNext(List<Node<T>> entries, Pair<InnerNode<T>> pickedSeeds) {
        double maxDifference = 0.0;
        Optional<Node<Node>> winner = Optional.empty();
        entries.removeAll(((InnerNode)pickedSeeds.left).getChildren());
        entries.removeAll(((InnerNode)pickedSeeds.right).getChildren());
        for (Node<T> entry : entries) {
            double rightAreaIncrease;
            if (((InnerNode)pickedSeeds.left).getChildren().contains(entry) || ((InnerNode)pickedSeeds.right).getChildren().contains(entry)) continue;
            InnerNode leftVertex = (InnerNode)pickedSeeds.left;
            InnerNode rightVertex = (InnerNode)pickedSeeds.right;
            double leftArea = Node.area(leftVertex.getBounds());
            double rightArea = Node.area(rightVertex.getBounds());
            Rectangle2D leftUnion = leftVertex.getBounds().createUnion(entry.getBounds());
            Rectangle2D rightUnion = rightVertex.getBounds().createUnion(entry.getBounds());
            double leftAreaIncrease = Node.area(leftUnion) - leftArea;
            double difference = leftAreaIncrease - (rightAreaIncrease = Node.area(rightUnion) - rightArea);
            double d = difference = difference < 0.0 ? -difference : difference;
            if (winner.isEmpty()) {
                winner = Optional.of(entry);
                maxDifference = difference;
                continue;
            }
            if (!(difference > maxDifference)) continue;
            maxDifference = difference;
            winner = Optional.of(entry);
        }
        winner.ifPresent(entries::remove);
        return winner;
    }

    @Override
    public Optional<Node<T>> chooseSubtree(InnerNode<T> nodeToSplit, T element, Rectangle2D bounds) {
        return this.leastEnlargementThenAreaThenKids(nodeToSplit, bounds);
    }
}

