/*
 * Decompiled with CFR 0.152.
 */
package ghidra.formats.gfilesystem;

import ghidra.app.util.bin.ByteProvider;
import ghidra.app.util.bin.ByteProviderInputStream;
import ghidra.formats.gfilesystem.FSRLRoot;
import ghidra.formats.gfilesystem.FSUtilities;
import ghidra.formats.gfilesystem.FileSystemRefManager;
import ghidra.formats.gfilesystem.GFile;
import ghidra.formats.gfilesystem.GFileSystemIterator;
import ghidra.formats.gfilesystem.fileinfo.FileAttributes;
import ghidra.util.Msg;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;

public interface GFileSystem
extends Closeable,
Iterable<GFile>,
ExtensionPoint {
    public String getName();

    default public String getType() {
        return FSUtilities.getFilesystemTypeFromClass(this.getClass());
    }

    default public String getDescription() {
        return FSUtilities.getFilesystemDescriptionFromClass(this.getClass());
    }

    public FSRLRoot getFSRL();

    public boolean isClosed();

    default public boolean isStatic() {
        return true;
    }

    public FileSystemRefManager getRefManager();

    default public int getFileCount() {
        return -1;
    }

    public GFile lookup(String var1) throws IOException;

    default public GFile lookup(String path, Comparator<String> nameComp) throws IOException {
        Msg.error(GFileSystem.class, (Object)"Unimplemented %s.lookup(path, comparator), falling back to non-comparator lookup".formatted(this.getClass().getSimpleName()));
        return this.lookup(path);
    }

    default public GFile getRootDir() {
        try {
            return this.lookup(null);
        }
        catch (IOException e) {
            return null;
        }
    }

    default public InputStream getInputStream(GFile file, TaskMonitor monitor) throws IOException, CancelledException {
        return GFileSystem.getInputStreamHelper(file, this, monitor);
    }

    public ByteProvider getByteProvider(GFile var1, TaskMonitor var2) throws IOException, CancelledException;

    public List<GFile> getListing(GFile var1) throws IOException;

    default public FileAttributes getFileAttributes(GFile file, TaskMonitor monitor) {
        return FileAttributes.EMPTY;
    }

    default public GFile resolveSymlinks(GFile file) throws IOException {
        return null;
    }

    public static InputStream getInputStreamHelper(GFile file, GFileSystem fs, TaskMonitor monitor) throws CancelledException, IOException {
        ByteProvider bp = fs.getByteProvider(file, monitor);
        return bp != null ? new ByteProviderInputStream.ClosingInputStream(bp) : null;
    }

    default public Iterable<GFile> files() {
        return () -> new GFileSystemIterator(this);
    }

    default public Iterable<GFile> files(GFile dir) throws UncheckedIOException {
        return () -> new GFileSystemIterator(Objects.requireNonNullElse(dir, this.getRootDir()));
    }

    default public Iterable<GFile> files(Predicate<GFile> fileFilter) {
        return () -> new GFileSystemIterator(this.getRootDir(), fileFilter);
    }

    default public Iterable<GFile> files(GFile dir, Predicate<GFile> fileFilter) throws UncheckedIOException {
        return () -> new GFileSystemIterator(Objects.requireNonNullElse(dir, this.getRootDir()), fileFilter);
    }

    @Override
    default public Iterator<GFile> iterator() {
        return new GFileSystemIterator(this);
    }
}

