/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.rtti;

import ghidra.app.util.bin.format.golang.GoConstants;
import ghidra.app.util.bin.format.golang.GoFunctionMultiReturn;
import ghidra.app.util.bin.format.golang.rtti.GoApiSnapshot;
import ghidra.app.util.bin.format.golang.rtti.GoIface;
import ghidra.app.util.bin.format.golang.rtti.GoItab;
import ghidra.app.util.bin.format.golang.rtti.GoModuledata;
import ghidra.app.util.bin.format.golang.rtti.GoRttiMapper;
import ghidra.app.util.bin.format.golang.rtti.GoSymbolName;
import ghidra.app.util.bin.format.golang.rtti.types.GoInterfaceType;
import ghidra.app.util.bin.format.golang.rtti.types.GoKind;
import ghidra.app.util.bin.format.golang.rtti.types.GoStructType;
import ghidra.app.util.bin.format.golang.rtti.types.GoType;
import ghidra.app.util.bin.format.golang.rtti.types.GoTypeBridge;
import ghidra.app.util.bin.format.golang.structmapping.MarkupSession;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.AbstractFloatDataType;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BooleanDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.FunctionDefinitionDataType;
import ghidra.program.model.data.ParameterDefinition;
import ghidra.program.model.data.ParameterDefinitionImpl;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.Structure;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.data.TypedefDataType;
import ghidra.program.model.data.VoidDataType;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.NumericUtilities;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import ghidra.util.task.UnknownProgressWrappingTaskMonitor;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GoTypeManager {
    private static final Map<String, String> STATIC_GOTYPE_ALIASES = Map.of("byte", "uint8", "rune", "int32");
    private static final Pattern TYPENAME_SPLITTER_REGEX = Pattern.compile("(\\*|\\[\\]|\\[[0-9.]+\\])(.*)");
    private final GoRttiMapper goBinary;
    private final DataTypeManager dtm;
    private final GoApiSnapshot apiSnapshot;
    private final Map<Long, TypeRec> typeOffsetIndex = new HashMap<Long, TypeRec>();
    private final Map<String, TypeRec> typeNameIndex = new HashMap<String, TypeRec>();
    private Set<String> missingGoTypes = new HashSet<String>();
    private Structure defaultClosureType;
    private Structure defaultMethodWrapperType;
    private DataType genericDictDT;
    private DataType voidPtrDT;
    private int ptrSize;

    public GoTypeManager(GoRttiMapper goBinary, GoApiSnapshot apiSnapshot) {
        this.goBinary = goBinary;
        this.apiSnapshot = apiSnapshot;
        this.dtm = goBinary.getDTM();
        this.ptrSize = goBinary.getPtrSize();
        this.voidPtrDT = this.dtm.getPointer((DataType)VoidDataType.dataType);
    }

    public void init(TaskMonitor monitor) throws IOException {
        this.genericDictDT = this.dtm.getPointer((DataType)this.dtm.getPointer(this.findDataType("uintptr")));
        UnknownProgressWrappingTaskMonitor upwtm = new UnknownProgressWrappingTaskMonitor(monitor);
        HashSet<Long> discoveredTypes = new HashSet<Long>();
        for (GoModuledata module : this.goBinary.getModules()) {
            upwtm.initialize(0L, "Iterating Go RTTI types");
            for (Address typeAddr : module.getTypeList()) {
                if (upwtm.isCancelled()) {
                    throw new IOException("Failed to init Go type info: cancelled");
                }
                upwtm.setProgress((long)discoveredTypes.size());
                GoType goType = this.getTypeUnchecked(typeAddr);
                if (goType != null) {
                    goType.discoverGoTypes(discoveredTypes);
                    continue;
                }
                Msg.warn((Object)this, (Object)("Failed to read Go type at " + String.valueOf(typeAddr)));
            }
            upwtm.initialize(0L, "Iterating Go Interfaces");
            for (GoItab itab : module.getItabs()) {
                if (upwtm.isCancelled()) {
                    throw new IOException("Failed to init Go type info: cancelled");
                }
                upwtm.setProgress((long)discoveredTypes.size());
                TypeRec rec = this.getTypeRec(itab.getType());
                if (rec.interfaces == null) {
                    rec.interfaces = new ArrayList<GoItab>();
                }
                rec.interfaces.add(itab);
                TypeRec ifaceRec = this.getTypeRec(itab.getInterfaceType());
                if (ifaceRec.interfaces == null) {
                    ifaceRec.interfaces = new ArrayList<GoItab>();
                }
                ifaceRec.interfaces.add(itab);
                itab.discoverGoTypes(discoveredTypes);
            }
            this.findUnindexedClosureStructTypes(monitor);
        }
        Msg.info((Object)this, (Object)"Found %d Go types".formatted(this.typeOffsetIndex.size()));
    }

    public void markupGoTypes(MarkupSession markupSession, TaskMonitor monitor) throws CancelledException, IOException {
        for (GoType goType : this.allTypes()) {
            monitor.checkCancelled();
            markupSession.markup(goType, false);
        }
    }

    private long getAlignedEndOfTypeInfo(GoType type, int typeStructAlign) {
        try {
            return NumericUtilities.getUnsignedAlignedValue((long)type.getEndOfTypeInfo(), (long)typeStructAlign);
        }
        catch (IOException e) {
            return type.getTypeOffset();
        }
    }

    private void findUnindexedClosureStructTypes(TaskMonitor monitor) throws IOException {
        int foundCount = 0;
        int typeStructAlign = this.ptrSize;
        int typeStructMinSize = this.goBinary.getStructureMappingInfo(GoStructType.class).getStructureLength();
        List<TypeStructRange> typeRanges = this.typeOffsetIndex.entrySet().stream().map(entry -> new TypeStructRange((Long)entry.getKey(), this.getAlignedEndOfTypeInfo(((TypeRec)entry.getValue()).type, typeStructAlign))).sorted((o1, o2) -> Long.compareUnsigned(o1.start, o2.start)).toList();
        monitor.initialize((long)typeRanges.size(), "Searching for Go unindexed types...");
        for (int i = 1; i < typeRanges.size() - 1; ++i) {
            monitor.setProgress((long)i);
            if (monitor.isCancelled()) {
                throw new IOException("unindexed types cancelled");
            }
            TypeStructRange t1 = typeRanges.get(i);
            TypeStructRange t2 = typeRanges.get(i + 1);
            long gapStart = t1.end;
            while (t2.start - gapStart > (long)typeStructMinSize) {
                GoType goType = this.readTypeUnchecked(gapStart);
                if (goType == null || !(goType instanceof GoStructType) || !goType.getSymbolName().isAnonType()) {
                    gapStart += (long)typeStructAlign;
                    continue;
                }
                TypeRec newTypeRec = this.getTypeRec(goType);
                gapStart = this.getAlignedEndOfTypeInfo(goType, typeStructAlign);
                ++foundCount;
            }
        }
        Msg.info((Object)this, (Object)"Discovered %d unindexed Go types".formatted(foundCount));
    }

    private TypeRec getTypeRec(GoType goType) {
        long offset = goType.getStructureContext().getStructureStart();
        TypeRec prevRec = this.typeOffsetIndex.get(offset);
        if (prevRec != null) {
            return prevRec;
        }
        Object typeName = goType.getFullyQualifiedName();
        prevRec = this.typeNameIndex.get(typeName);
        if (prevRec != null && prevRec.recoveredDT != null) {
            prevRec.type = goType;
            this.typeOffsetIndex.put(offset, prevRec);
            return prevRec;
        }
        if (prevRec != null && prevRec.type != null && !(prevRec.type instanceof GoTypeBridge)) {
            ++prevRec.conflictCount;
            typeName = (String)typeName + ".conflict" + prevRec.conflictCount;
        }
        TypeRec newRec = new TypeRec();
        newRec.name = typeName;
        newRec.type = goType;
        this.typeOffsetIndex.put(offset, newRec);
        this.typeNameIndex.put((String)typeName, newRec);
        return newRec;
    }

    private TypeRec getTypeRec(long offset, boolean cacheOnly) throws IOException {
        if (offset == 0L) {
            return null;
        }
        TypeRec rec = this.typeOffsetIndex.get(offset);
        if (rec != null || cacheOnly) {
            return rec;
        }
        GoType goType = this.readType(offset);
        return this.getTypeRec(goType);
    }

    public DataTypeManager getDTM() {
        return this.dtm;
    }

    public int getPtrSize() {
        return this.ptrSize;
    }

    public List<GoType> allTypes() {
        return this.typeOffsetIndex.entrySet().stream().sorted((e1, e2) -> Long.compareUnsigned((Long)e1.getKey(), (Long)e2.getKey())).map(e -> ((TypeRec)e.getValue()).type).toList();
    }

    private List<TypeRec> sortedTypeRecs() {
        return this.typeOffsetIndex.entrySet().stream().sorted((e1, e2) -> Long.compareUnsigned((Long)e1.getKey(), (Long)e2.getKey())).map(Map.Entry::getValue).toList();
    }

    public List<Long> allTypeOffsets() {
        return this.typeOffsetIndex.keySet().stream().sorted().toList();
    }

    private GoType readTypeUnchecked(long offset) {
        try {
            return this.readType(offset);
        }
        catch (IOException e) {
            return null;
        }
    }

    private GoType readType(long offset) throws IOException {
        Class<? extends GoType> typeClass = GoType.getSpecializedTypeClass(this.goBinary, offset);
        GoType goType = this.goBinary.readStructure(typeClass, offset);
        return goType;
    }

    public boolean hasGoType(String typeName) {
        TypeRec rec = this.typeNameIndex.get(typeName);
        return rec != null && rec.type != null;
    }

    public GoType findGoType(String typeName) throws IOException {
        TypeRec result = this.findTypeRec(typeName);
        if (result == null) {
            this.missingGoTypes.add(typeName);
        }
        return result != null ? result.type : null;
    }

    public DataType findDataType(GoSymbolName typeName) throws IOException {
        return this.findDataType(typeName.asString(), DataType.class);
    }

    public <T extends DataType> T findDataType(GoSymbolName typeName, Class<T> clazz) throws IOException {
        return this.findDataType(typeName.asString(), clazz);
    }

    public DataType findDataType(String typeName) throws IOException {
        TypeRec rec = this.findTypeRec(typeName);
        return this.getDataType(rec);
    }

    public <T extends DataType> T findDataType(String typeName, Class<T> clazz) throws IOException {
        DataType result = this.findDataType(typeName);
        return (T)(clazz.isInstance(result) ? (DataType)clazz.cast(result) : null);
    }

    public DataType getDataType(String typeName) throws IOException {
        TypeRec result = this.findTypeRec(typeName);
        if (result == null || result.recoveredDT == null) {
            throw new IOException("Unknown Go data type: " + typeName);
        }
        return result.recoveredDT;
    }

    TypeRec newTypeRecFromDT(String typeName, DataType dt) {
        TypeRec result = new TypeRec();
        result.recoveredDT = dt;
        result.name = typeName;
        this.typeNameIndex.put(typeName, result);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    TypeRec findTypeRec(String typeName) throws IOException {
        TypeRec result = this.typeNameIndex.get(typeName = STATIC_GOTYPE_ALIASES.getOrDefault(typeName, typeName));
        if (result != null) return result;
        GoSymbolName typeSymbolName = GoSymbolName.parseTypeName(typeName, null);
        String[] typeNameparts = GoTypeManager.splitTypeName(typeName);
        if (typeNameparts != null) {
            DataType subDT;
            String typePrefix = typeNameparts[0];
            String subTypeName = typeNameparts[1];
            TypeRec subType = null;
            try {
                subType = this.findTypeRec(subTypeName);
            }
            catch (IOException e) {
                Msg.warn((Object)this, (Object)"Failed to get subtype '%s' in %s".formatted(subTypeName, typeName));
            }
            DataType dataType = subDT = subType != null ? subType.recoveredDT : null;
            if (typePrefix.equals("[]")) {
                return this.newTypeRecFromDT(typeName, (DataType)this.createSpecializedSlice(typeSymbolName, subDT));
            }
            if (typePrefix.equals("*")) {
                return this.newTypeRecFromDT(typeName, (DataType)this.dtm.getPointer(subDT));
            }
            if (!typePrefix.startsWith("[")) throw new IOException("Unknown type prefix: " + typeName);
            if (!typePrefix.endsWith("]")) throw new IOException("Unknown type prefix: " + typeName);
            if (subDT == null) return result;
            int arraySize = this.extractArraySize(typePrefix);
            ArrayDataType arrayDT = new ArrayDataType(subDT, arraySize);
            return this.newTypeRecFromDT(typeName, (DataType)arrayDT);
        }
        if (typeName.startsWith("map[")) {
            return this.newTypeRecFromDT(typeName, this.createSpecializedMapDT(typeName));
        }
        GoKind primitiveTypeKind = GoKind.parseTypename(typeName);
        if (primitiveTypeKind.isPrimitive()) {
            return this.makeBasicType(typeSymbolName, primitiveTypeKind);
        }
        GoApiSnapshot.GoTypeDef typeDef = this.apiSnapshot.getTypeDef(typeName);
        if (typeDef == null) return result;
        return this.convertApiTypeDef(typeSymbolName, typeDef);
    }

    private int extractArraySize(String arrayStr) throws IOException {
        try {
            int arraySize = Integer.parseInt(arrayStr.substring(1, arrayStr.length() - 1));
            return arraySize;
        }
        catch (NumberFormatException e) {
            throw new IOException("Bad array size: " + arrayStr);
        }
    }

    private TypeRec convertApiTypeDef(GoSymbolName typeName, GoApiSnapshot.GoTypeDef typeDef) throws IOException {
        GoApiSnapshot.GoTypeDef goTypeDef = typeDef;
        Objects.requireNonNull(goTypeDef);
        GoApiSnapshot.GoTypeDef goTypeDef2 = goTypeDef;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GoApiSnapshot.GoBasicDef.class, GoApiSnapshot.GoAliasDef.class, GoApiSnapshot.GoStructDef.class, GoApiSnapshot.GoFuncTypeDef.class}, (Object)goTypeDef2, n)) {
            case 0: {
                GoApiSnapshot.GoBasicDef basic = (GoApiSnapshot.GoBasicDef)goTypeDef2;
                return this.convertBasicDef(typeName, basic);
            }
            case 1: {
                GoApiSnapshot.GoAliasDef alias = (GoApiSnapshot.GoAliasDef)goTypeDef2;
                return this.convertAliasDef(typeName, alias);
            }
            case 2: {
                GoApiSnapshot.GoStructDef struct = (GoApiSnapshot.GoStructDef)goTypeDef2;
                return this.convertStructDef(typeName, struct);
            }
            case 3: {
                GoApiSnapshot.GoFuncTypeDef func = (GoApiSnapshot.GoFuncTypeDef)goTypeDef2;
                return this.convertFuncDef(typeName, func);
            }
        }
        throw new IOException("Go unhandled type definition: " + typeDef.toString());
    }

    private TypeRec convertFuncDef(GoSymbolName typeName, GoApiSnapshot.GoFuncTypeDef func) throws IOException {
        VoidDataType returnDT;
        CategoryPath cp = this.getCP(typeName);
        String name = typeName.asString();
        StructureDataType struct = new StructureDataType(cp, name, 0, this.dtm);
        Pointer structPtr = this.dtm.getPointer((DataType)struct);
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(cp, name + "_F", this.dtm);
        struct.add((DataType)this.dtm.getPointer((DataType)funcDef), "F", null);
        struct.add((DataType)new ArrayDataType(this.getDataType("uint8"), 0), "context", null);
        struct.setToDefaultPacking();
        TypeRec result = this.cacheDataType(name, (DataType)structPtr);
        ArrayList<ParameterDefinitionImpl> params = new ArrayList<ParameterDefinitionImpl>();
        params.add(new ParameterDefinitionImpl(".context", (DataType)structPtr, null));
        for (GoApiSnapshot.GoNameTypePair param : func.Params) {
            DataType paramDT = this.findDataType(param.DataType);
            params.add(new ParameterDefinitionImpl(param.Name, paramDT, null));
        }
        if (func.Results.isEmpty()) {
            returnDT = VoidDataType.dataType;
        } else if (func.Results.size() == 1) {
            returnDT = this.findDataType(func.Results.get((int)0).DataType);
        } else {
            ArrayList<DataType> paramDataTypes = new ArrayList<DataType>();
            for (GoApiSnapshot.GoNameTypePair outParam : func.Results) {
                paramDataTypes.add(this.findDataType(outParam.DataType));
            }
            returnDT = this.getFuncMultiReturn(paramDataTypes);
        }
        funcDef.setArguments((ParameterDefinition[])params.toArray(ParameterDefinition[]::new));
        funcDef.setReturnType((DataType)returnDT);
        return result;
    }

    private TypeRec convertBasicDef(GoSymbolName typeName, GoApiSnapshot.GoBasicDef basicDef) throws IOException {
        GoKind kind = GoKind.parseTypename(basicDef.DataType);
        if (kind == null) {
            throw new IOException("Bad Go basic typedef " + basicDef.toString());
        }
        return this.makeBasicType(typeName, kind);
    }

    private TypeRec makeBasicType(GoSymbolName typeName, GoKind kind) throws IOException {
        DataType plainDT = this.recoverPlainDataType(kind);
        if (plainDT == null) {
            throw new IOException("Bad Go basic type " + String.valueOf((Object)kind));
        }
        CategoryPath cp = this.getCP(typeName);
        String name = typeName.asString();
        if (!plainDT.getCategoryPath().equals((Object)cp) || !plainDT.getName().equals(name)) {
            plainDT = new TypedefDataType(cp, name, plainDT, this.dtm);
        }
        return this.newTypeRecFromDT(name, plainDT);
    }

    private TypeRec convertAliasDef(GoSymbolName typeName, GoApiSnapshot.GoAliasDef aliasDef) throws IOException {
        DataType targetDT = this.findDataType(aliasDef.Target);
        if (targetDT == null) {
            throw new IOException("Bad Go type alias " + aliasDef.toString());
        }
        return this.newTypeRecFromDT(typeName.asString(), (DataType)new TypedefDataType(this.getCP(typeName), typeName.asString(), targetDT, this.dtm));
    }

    private TypeRec convertStructDef(GoSymbolName typeName, GoApiSnapshot.GoStructDef structDef) throws IOException {
        String baseTypeName = typeName.asString();
        LengthAlignment lenInfo = this.getDataTypeLength(structDef);
        StructureDataType struct = new StructureDataType(this.getCP(typeName), baseTypeName, lenInfo.len, this.dtm);
        struct.align(lenInfo.align);
        TypeRec rec = new TypeRec();
        rec.name = typeName.asString();
        rec.recoveredDT = struct;
        this.typeNameIndex.put(rec.name, rec);
        StructureDataType packedStruct = new StructureDataType(struct.getCategoryPath(), struct.getName(), 0, this.dtm);
        packedStruct.setToDefaultPacking();
        for (int i = 0; i < structDef.Fields.size(); ++i) {
            GoApiSnapshot.GoNameTypePair field = structDef.Fields.get(i);
            DataType dtcDT = this.findDataType(field.DataType);
            if (dtcDT == null) {
                throw new IOException("Failed to get type for field [%d %s: %s] in %s".formatted(i, field.Name, field.DataType, typeName));
            }
            packedStruct.add(dtcDT, field.Name, null);
        }
        if (packedStruct.getLength() != struct.getLength()) {
            throw new IOException("Go type struct definition changed size when packing: %s %d->%d".formatted(rec.name, struct.getLength(), packedStruct.getLength()));
        }
        struct.replaceWith((DataType)packedStruct);
        return rec;
    }

    static String[] splitTypeName(String typeName) {
        Matcher m = TYPENAME_SPLITTER_REGEX.matcher(typeName);
        if (m.matches()) {
            return new String[]{m.group(1), m.group(2)};
        }
        return null;
    }

    public List<GoType> getClosureTypes() {
        return this.typeOffsetIndex.values().stream().filter(rec -> {
            GoStructType structType;
            GoType patt0$temp = rec.type;
            return patt0$temp instanceof GoStructType && (structType = (GoStructType)patt0$temp).isClosureContextType();
        }).map(rec -> rec.type).toList();
    }

    public List<GoType> getMethodWrapperClosureTypes() {
        return this.typeOffsetIndex.values().stream().filter(rec -> {
            GoStructType structType;
            GoType patt0$temp = rec.type;
            return patt0$temp instanceof GoStructType && (structType = (GoStructType)patt0$temp).isMethodWrapperContextType();
        }).map(rec -> rec.type).toList();
    }

    public GoType getType(long offset) throws IOException {
        return this.getType(offset, false);
    }

    public GoType getType(long offset, boolean cacheOnly) throws IOException {
        TypeRec rec = this.getTypeRec(offset, cacheOnly);
        return rec != null ? rec.type : null;
    }

    public GoType getTypeUnchecked(Address addr) {
        try {
            return this.getType(addr.getOffset(), false);
        }
        catch (IOException e) {
            return null;
        }
    }

    public DataType getVoidPtrDT() {
        return this.voidPtrDT;
    }

    public String getTypeName(long offset) {
        try {
            TypeRec rec = this.getTypeRec(offset, false);
            if (rec != null) {
                return rec.name;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return "unknown_type_%x".formatted(offset);
    }

    public String getTypeName(GoType type) {
        return this.getTypeName(type.getStructureContext().getStructureStart());
    }

    public List<GoItab> getInterfacesImplementedByType(GoType type) {
        TypeRec rec = this.getTypeRec(type);
        List<Object> itabs = rec.interfaces != null ? rec.interfaces : List.of();
        return itabs.stream().filter(itab -> itab._type == type.getTypeOffset()).toList();
    }

    public List<GoItab> getTypesThatImplementInterface(GoInterfaceType iface) {
        TypeRec rec = this.getTypeRec(iface);
        List<Object> itabs = rec.interfaces != null ? rec.interfaces : List.of();
        return itabs.stream().filter(itab -> itab.inter == iface.getTypeOffset()).toList();
    }

    public GoType resolveTypeOff(long ptrInModule, long off) throws IOException {
        if (off == 0L || off == 0xFFFFFFFFL || off == -1L) {
            return null;
        }
        GoModuledata module = this.goBinary.findContainingModule(ptrInModule);
        return this.getType(module.getTypesOffset() + off, false);
    }

    public void cacheRecoveredDataType(GoType typ, DataType dt) throws IOException {
        TypeRec rec = this.getTypeRec(typ);
        rec.recoveredDT = dt;
    }

    private TypeRec cacheDataType(String typeName, DataType dt) throws IOException {
        TypeRec typeRec = this.typeNameIndex.get(typeName);
        if (typeRec == null) {
            return this.newTypeRecFromDT(typeName, dt);
        }
        throw new IOException("tried to cache data type already exists: " + typeName);
    }

    public void recoverGhidraDataTypes(TaskMonitor monitor) throws IOException, CancelledException {
        monitor.initialize((long)this.typeOffsetIndex.size(), "Converting Go types to Ghidra data types");
        for (TypeRec rec : this.sortedTypeRecs()) {
            monitor.increment();
            if (rec.recoveredDT != null || rec.type == null) continue;
            rec.recoveredDT = rec.type.recoverDataType();
            if (this.dtm.getDataType(rec.recoveredDT.getDataTypePath()) != null) continue;
            this.dtm.addDataType(rec.recoveredDT, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
    }

    public DataType recoverPlainDataType(GoKind kind) {
        return switch (kind) {
            case GoKind.Bool -> BooleanDataType.dataType;
            case GoKind.Float32 -> AbstractFloatDataType.getFloatDataType((int)4, null);
            case GoKind.Float64 -> AbstractFloatDataType.getFloatDataType((int)8, null);
            case GoKind.Int -> AbstractIntegerDataType.getSignedDataType((int)this.ptrSize, (DataTypeManager)this.dtm);
            case GoKind.Int8 -> AbstractIntegerDataType.getSignedDataType((int)1, null);
            case GoKind.Int16 -> AbstractIntegerDataType.getSignedDataType((int)2, null);
            case GoKind.Int32 -> AbstractIntegerDataType.getSignedDataType((int)4, null);
            case GoKind.Int64 -> AbstractIntegerDataType.getSignedDataType((int)8, null);
            case GoKind.Uint -> AbstractIntegerDataType.getUnsignedDataType((int)this.ptrSize, (DataTypeManager)this.dtm);
            case GoKind.Uint8 -> AbstractIntegerDataType.getUnsignedDataType((int)1, null);
            case GoKind.Uint16 -> AbstractIntegerDataType.getUnsignedDataType((int)2, null);
            case GoKind.Uint32 -> AbstractIntegerDataType.getUnsignedDataType((int)4, null);
            case GoKind.Uint64 -> AbstractIntegerDataType.getUnsignedDataType((int)8, null);
            case GoKind.Uintptr -> AbstractIntegerDataType.getUnsignedDataType((int)this.ptrSize, (DataTypeManager)this.dtm);
            case GoKind.String -> this.buildStringStruct();
            case GoKind.Pointer, GoKind.UnsafePointer -> this.getVoidPtrDT();
            default -> null;
        };
    }

    private Structure buildStringStruct() {
        StructureDataType struct = new StructureDataType(this.getCP(), "string", 0, this.dtm);
        struct.setToDefaultPacking();
        struct.add((DataType)this.dtm.getPointer((DataType)CharDataType.dataType), "str", null);
        struct.add(this.recoverPlainDataType(GoKind.Int), "len", null);
        return struct;
    }

    public DataType getDataType(GoType typ) throws IOException {
        return this.getDataType(typ, DataType.class, false);
    }

    public <T extends DataType> T getDataType(GoType typ, Class<T> clazz, boolean cacheOnly) throws IOException {
        DataType dt;
        if (typ == null) {
            return null;
        }
        if (typ instanceof GoTypeBridge) {
            GoTypeBridge typeBridge = (GoTypeBridge)typ;
            DataType dt2 = typeBridge.recoverDataType();
            return (T)(clazz.isInstance(dt2) ? (DataType)clazz.cast(dt2) : null);
        }
        TypeRec rec = this.getTypeRec(typ);
        if (rec.recoveredDT == null && !cacheOnly) {
            rec.recoveredDT = typ.recoverDataType();
        }
        if (clazz.isInstance(dt = rec.recoveredDT)) {
            return (T)((DataType)clazz.cast(dt));
        }
        if (dt != null) {
            Msg.warn((Object)this, (Object)"Failed to get Ghidra data type from Go type: %s[%x]".formatted(rec.name, rec.type.getStructureContext().getStructureStart()));
        }
        return null;
    }

    private DataType getDataType(TypeRec rec) throws IOException {
        if (rec == null) {
            return null;
        }
        if (rec.recoveredDT == null) {
            rec.recoveredDT = rec.type.recoverDataType();
        }
        return rec.recoveredDT;
    }

    public CategoryPath getCP() {
        return GoConstants.GOLANG_RECOVERED_TYPES_CATEGORYPATH;
    }

    public CategoryPath getCP(GoType typ) {
        CategoryPath result = GoConstants.GOLANG_RECOVERED_TYPES_CATEGORYPATH;
        try {
            String structNS = typ.getStructureNamespace();
            if (structNS != null && !structNS.isEmpty()) {
                result = result.extend(new String[]{structNS});
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public CategoryPath getCP(GoSymbolName symbolName) {
        CategoryPath result = GoConstants.GOLANG_RECOVERED_TYPES_CATEGORYPATH;
        String packagePath = symbolName.getPackagePath();
        if (packagePath != null && !packagePath.isEmpty()) {
            result = result.extend(new String[]{packagePath});
        }
        return result;
    }

    public DataType createSpecializedMapDT(String mapTypeName) {
        try {
            GoSymbolName typeSymbolName = GoSymbolName.parseTypeName(mapTypeName);
            Structure hmapStruct = this.findDataType("runtime.hmap", Structure.class);
            if (hmapStruct != null) {
                return new TypedefDataType(this.getCP(typeSymbolName), mapTypeName, (DataType)this.dtm.getPointer((DataType)hmapStruct), this.dtm);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.voidPtrDT;
    }

    public Structure getGenericSliceDT() throws IllegalArgumentException, IOException {
        Structure sliceDT;
        GoSymbolName sliceTypeName = GoSymbolName.parseTypeName("runtime.slice");
        try {
            sliceDT = this.findDataType(sliceTypeName, Structure.class);
            if (sliceDT != null) {
                return sliceDT;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sliceDT = new StructureDataType(this.getCP(sliceTypeName), sliceTypeName.asString(), 0, this.dtm);
        sliceDT.setToDefaultPacking();
        sliceDT.add(this.voidPtrDT, "array", null);
        sliceDT.add(this.findDataType("int"), "len", null);
        sliceDT.add(this.findDataType("int"), "cap", null);
        return sliceDT;
    }

    public Structure createSpecializedSlice(GoSymbolName sliceTypeName, DataType element) throws IllegalArgumentException, IOException {
        Structure genericSliceDT = this.getGenericSliceDT();
        StructureDataType sliceDT = new StructureDataType(this.getCP(sliceTypeName), sliceTypeName.asString(), genericSliceDT.getLength(), this.dtm);
        sliceDT.replaceWith((DataType)genericSliceDT);
        int arrayPtrComponentIndex = 0;
        DataTypeComponent arrayDTC = genericSliceDT.getComponent(arrayPtrComponentIndex);
        sliceDT.replace(arrayPtrComponentIndex, (DataType)this.dtm.getPointer(element), -1, arrayDTC.getFieldName(), arrayDTC.getComment());
        return sliceDT;
    }

    public DataType getGenericDictDT() {
        return this.genericDictDT;
    }

    public Structure getGenericInterfaceDT() {
        return this.goBinary.getStructureDataType(GoIface.class);
    }

    public Structure getGenericITabDT() {
        return this.goBinary.getStructureDataType(GoItab.class);
    }

    public DataType getMethodClosureType(String recvType) throws IOException {
        GoType closureType = this.findGoType("struct { F uintptr; R %s }".formatted(recvType));
        return closureType != null ? this.getDataType(closureType) : null;
    }

    DataType findRecieverType(GoSymbolName symbolName) throws IOException {
        GoSymbolName recvTypeName = symbolName.getReceiverTypeName();
        DataType recvDT = this.findDataType(recvTypeName);
        if (recvDT == null && symbolName.hasGenerics()) {
            recvTypeName = symbolName.getReceiverTypeName(symbolName.getShapelessGenericsString());
            recvDT = this.findDataType(recvTypeName);
        }
        return recvDT;
    }

    public DataType getDefaultClosureType() throws IOException {
        if (this.defaultClosureType == null) {
            StructureDataType closureDT = new StructureDataType(this.getCP(), ".closure", 0, this.dtm);
            closureDT.setDescription("Artifical type that represents a Go closure context");
            FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.getCP(), ".closureF", this.dtm);
            ParameterDefinition[] params = new ParameterDefinition[]{new ParameterDefinitionImpl(".context", (DataType)this.dtm.getPointer((DataType)closureDT), null)};
            funcDef.setArguments(params);
            closureDT.add((DataType)this.dtm.getPointer((DataType)funcDef), "F", null);
            closureDT.add((DataType)new ArrayDataType(this.getDataType("uintptr"), 0), "context", null);
            this.defaultClosureType = (Structure)this.dtm.addDataType((DataType)closureDT, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
        return this.defaultClosureType;
    }

    public Structure getDefaultMethodWrapperClosureType() {
        if (this.defaultMethodWrapperType == null) {
            StructureDataType closureDT = new StructureDataType(this.getCP(), ".methodwrapper", 0, this.dtm);
            FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.getCP(), ".methodwrapperF", this.dtm);
            ParameterDefinition[] params = new ParameterDefinition[]{new ParameterDefinitionImpl(".context", (DataType)this.dtm.getPointer((DataType)closureDT), null)};
            funcDef.setArguments(params);
            closureDT.add((DataType)this.dtm.getPointer((DataType)funcDef), "F", null);
            closureDT.add(this.voidPtrDT, "R", "method receiver");
            this.defaultMethodWrapperType = (Structure)this.dtm.addDataType((DataType)closureDT, DataTypeConflictHandler.DEFAULT_HANDLER);
        }
        return this.defaultMethodWrapperType;
    }

    public Structure getFuncMultiReturn(List<DataType> returnTypes) {
        GoFunctionMultiReturn multiReturn = new GoFunctionMultiReturn(this.getCP(), returnTypes, this.dtm, this.goBinary.newStorageAllocator());
        return multiReturn.getStruct();
    }

    public GoType getSubstitutionType(String typeName) throws IOException {
        if (typeName.startsWith("*")) {
            return new GoTypeBridge(typeName, this.getVoidPtrDT(), this.goBinary);
        }
        if (typeName.startsWith("[]") || typeName.equals("runtime.slice")) {
            return new GoTypeBridge(typeName, (DataType)this.getGenericSliceDT(), this.goBinary);
        }
        if (typeName.startsWith("map[")) {
            return this.findGoType("*runtime.hmap");
        }
        if (typeName.startsWith("chan ")) {
            return this.findGoType("*runtime.hchan");
        }
        if (typeName.startsWith("func(")) {
            DataType closureType = this.getDefaultClosureType();
            return new GoTypeBridge(typeName, (DataType)this.dtm.getPointer(closureType), this.goBinary);
        }
        if (typeName.equals("runtime.iface")) {
            return new GoTypeBridge(typeName, (DataType)this.getGenericInterfaceDT(), this.goBinary);
        }
        return null;
    }

    public Set<String> getMissingGoTypes() {
        return this.missingGoTypes;
    }

    private LengthAlignment getDataTypeLength(GoApiSnapshot.GoBasicDef basicTypeDef) throws IOException {
        return this.getTypeLength(GoKind.parseTypename(basicTypeDef.DataType));
    }

    private LengthAlignment getTypeLength(GoKind kind) throws IOException {
        return switch (kind) {
            case GoKind.Bool, GoKind.Int8, GoKind.Uint8 -> new LengthAlignment(1, 1);
            case GoKind.Float32 -> new LengthAlignment(4, this.align(4));
            case GoKind.Float64 -> new LengthAlignment(8, this.align(8));
            case GoKind.Int16, GoKind.Uint16 -> new LengthAlignment(2, this.align(2));
            case GoKind.Int32, GoKind.Uint32 -> new LengthAlignment(4, this.align(4));
            case GoKind.Int64, GoKind.Uint64 -> new LengthAlignment(8, this.align(8));
            case GoKind.Complex64 -> new LengthAlignment(8, this.align(8));
            case GoKind.Complex128 -> new LengthAlignment(16, this.align(16));
            case GoKind.Int, GoKind.Uint -> new LengthAlignment(this.ptrSize, this.align(this.ptrSize));
            case GoKind.Uintptr -> new LengthAlignment(this.ptrSize, this.align(this.ptrSize));
            case GoKind.Func -> new LengthAlignment(this.ptrSize, this.align(this.ptrSize));
            case GoKind.String -> new LengthAlignment(this.ptrSize * 2, this.align(this.ptrSize));
            case GoKind.Pointer, GoKind.UnsafePointer -> new LengthAlignment(this.ptrSize, this.align(this.ptrSize));
            default -> throw new IOException();
        };
    }

    private int align(int size) {
        return this.dtm.getDataOrganization().getSizeAlignment(size);
    }

    private LengthAlignment getDataTypeLength(String name) throws IOException {
        String[] typeNameParts = GoTypeManager.splitTypeName(name = STATIC_GOTYPE_ALIASES.getOrDefault(name, name));
        if (typeNameParts != null) {
            String prefix;
            switch (prefix = typeNameParts[0]) {
                case "*": {
                    return new LengthAlignment(this.ptrSize, this.align(this.ptrSize));
                }
                case "[]": {
                    return new LengthAlignment(this.ptrSize * 3, this.align(this.ptrSize));
                }
            }
            if (prefix.startsWith("[") && prefix.endsWith("]")) {
                int arraySize = this.extractArraySize(prefix);
                LengthAlignment elementInfo = this.getDataTypeLength(typeNameParts[1]);
                return new LengthAlignment(arraySize * elementInfo.len, elementInfo.align);
            }
            throw new IOException("Unknown type prefix: " + name);
        }
        if (name.startsWith("map[") || name.startsWith("chan ")) {
            return new LengthAlignment(this.ptrSize, this.align(this.ptrSize));
        }
        GoKind typeKind = GoKind.parseTypename(name);
        if (typeKind.isPrimitive()) {
            return this.getTypeLength(typeKind);
        }
        GoApiSnapshot.GoTypeDef typeDef = this.apiSnapshot.getTypeDef(name);
        if (typeDef != null) {
            GoApiSnapshot.GoTypeDef goTypeDef = typeDef;
            Objects.requireNonNull(goTypeDef);
            GoApiSnapshot.GoTypeDef goTypeDef2 = goTypeDef;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GoApiSnapshot.GoStructDef.class, GoApiSnapshot.GoBasicDef.class, GoApiSnapshot.GoAliasDef.class, GoApiSnapshot.GoFuncTypeDef.class, GoApiSnapshot.GoInterfaceDef.class}, (Object)goTypeDef2, n)) {
                case 0 -> {
                    GoApiSnapshot.GoStructDef x = (GoApiSnapshot.GoStructDef)goTypeDef2;
                    yield this.getDataTypeLength(x);
                }
                case 1 -> {
                    GoApiSnapshot.GoBasicDef x = (GoApiSnapshot.GoBasicDef)goTypeDef2;
                    yield this.getDataTypeLength(x);
                }
                case 2 -> {
                    GoApiSnapshot.GoAliasDef x = (GoApiSnapshot.GoAliasDef)goTypeDef2;
                    yield this.getDataTypeLength(x);
                }
                case 3 -> {
                    GoApiSnapshot.GoFuncTypeDef x = (GoApiSnapshot.GoFuncTypeDef)goTypeDef2;
                    yield this.getDataTypeLength(x);
                }
                case 4 -> {
                    GoApiSnapshot.GoInterfaceDef x = (GoApiSnapshot.GoInterfaceDef)goTypeDef2;
                    yield this.getDataTypeLength(x);
                }
                default -> throw new IOException("Failed to get size of apisnapshot type: " + name);
            };
        }
        throw new IOException("Failed to get size of type: " + name);
    }

    private LengthAlignment getDataTypeLength(GoApiSnapshot.GoAliasDef aliasDef) throws IOException {
        return this.getDataTypeLength(aliasDef.Target);
    }

    private LengthAlignment getDataTypeLength(GoApiSnapshot.GoFuncTypeDef functypeDef) {
        return new LengthAlignment(this.ptrSize, this.align(this.ptrSize));
    }

    private LengthAlignment getDataTypeLength(GoApiSnapshot.GoInterfaceDef ifaceDef) {
        return new LengthAlignment(this.ptrSize * 2, this.align(this.ptrSize));
    }

    private LengthAlignment getDataTypeLength(GoApiSnapshot.GoStructDef structDef) throws IOException {
        int len = 0;
        int align = 1;
        for (GoApiSnapshot.GoNameTypePair field : structDef.Fields) {
            LengthAlignment fieldInfo = this.getDataTypeLength(field.DataType);
            len = (int)NumericUtilities.getUnsignedAlignedValue((long)len, (long)fieldInfo.align);
            len += fieldInfo.len;
            align = Math.max(align, fieldInfo.align);
        }
        len = (int)NumericUtilities.getUnsignedAlignedValue((long)len, (long)align);
        return new LengthAlignment(len, align);
    }

    public FunctionDefinitionDataType createFuncDef(List<ParameterDefinition> params, List<ParameterDefinition> returnParams, GoSymbolName symbolName, boolean noReturn) {
        VoidDataType returnDT;
        if (returnParams == null) {
            returnDT = null;
        } else if (returnParams.size() == 0) {
            returnDT = VoidDataType.dataType;
        } else if (returnParams.size() == 1) {
            returnDT = returnParams.get(0).getDataType();
        } else {
            List<DataType> paramDTs = returnParams.stream().map(ParameterDefinition::getDataType).toList();
            returnDT = this.getFuncMultiReturn(paramDTs);
        }
        return this.createFuncDef(params, (DataType)returnDT, symbolName, noReturn);
    }

    public FunctionDefinitionDataType createFuncDef(List<ParameterDefinition> params, DataType returnDT, GoSymbolName symbolName, boolean noReturn) {
        String funcName = SymbolUtilities.replaceInvalidChars((String)symbolName.asString(), (boolean)true);
        FunctionDefinitionDataType funcDef = new FunctionDefinitionDataType(this.getCP(symbolName), funcName, this.dtm);
        funcDef.setArguments((ParameterDefinition[])params.toArray(ParameterDefinition[]::new));
        funcDef.setReturnType(returnDT);
        funcDef.setNoReturn(noReturn);
        return funcDef;
    }

    static class TypeRec {
        GoType type;
        String name;
        int conflictCount;
        DataType recoveredDT;
        List<GoItab> interfaces;

        TypeRec() {
        }
    }

    record TypeStructRange(long start, long end) {
    }

    record LengthAlignment(int len, int align) {
    }
}

