/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.printing;

import docking.ReusableDialogComponentProvider;
import docking.widgets.button.GRadioButton;
import docking.widgets.checkbox.GCheckBox;
import generic.theme.Gui;
import ghidra.util.HelpLocation;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class PrintOptionsDialog
extends ReusableDialogComponentProvider {
    private static final String FONT_ID = "font.print";
    private boolean selectionEnabled;
    private boolean cancelled = false;
    private JRadioButton selection;
    private JRadioButton visible;
    private JRadioButton view;
    private JCheckBox monochrome;
    private JCheckBox title;
    private JCheckBox date;
    private JCheckBox pageNum;
    private ButtonGroup group;

    protected PrintOptionsDialog(boolean selectionEnabled) {
        super("Print Options", true, false, true, false);
        this.setResizable(false);
        this.selectionEnabled = selectionEnabled;
        this.addWorkPanel(this.create());
        this.addOKButton();
        this.addCancelButton();
        this.setHelpLocation(new HelpLocation("PrintingPlugin", "Print"));
    }

    protected void cancelCallback() {
        this.close();
        this.cancelled = true;
    }

    protected void okCallback() {
        this.close();
        this.cancelled = false;
    }

    JPanel create() {
        JPanel outerPanel = new JPanel(new BorderLayout());
        JPanel rangePanel = new JPanel();
        rangePanel.setLayout(new BoxLayout(rangePanel, 1));
        rangePanel.setBorder(BorderFactory.createTitledBorder("Print Range"));
        rangePanel.getAccessibleContext().setAccessibleName("Print Range");
        KeyAdapter key = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ((AbstractButton)e.getSource()).setSelected(true);
                    PrintOptionsDialog.this.okCallback();
                }
            }
        };
        this.group = new ButtonGroup();
        this.selection = new GRadioButton("Selected area(s)");
        this.selection.addKeyListener(key);
        this.selection.getAccessibleContext().setAccessibleName("Selected Area");
        rangePanel.add(this.selection);
        this.group.add(this.selection);
        this.selection.setEnabled(this.selectionEnabled);
        this.visible = new GRadioButton("Code visible on screen");
        this.visible.addKeyListener(key);
        this.visible.getAccessibleContext().setAccessibleName("Visible Code");
        rangePanel.add(this.visible);
        this.group.add(this.visible);
        this.view = new GRadioButton("Current view");
        this.view.addKeyListener(key);
        this.view.getAccessibleContext().setAccessibleName("Current View");
        rangePanel.add(this.view);
        this.group.add(this.view);
        JPanel headerPanel = new JPanel();
        headerPanel.setLayout(new BoxLayout(headerPanel, 0));
        headerPanel.setBorder(BorderFactory.createTitledBorder("Header and Footer"));
        headerPanel.getAccessibleContext().setAccessibleName("Info");
        this.title = new GCheckBox("Title");
        this.title.setSelected(true);
        this.title.addKeyListener(key);
        this.title.getAccessibleContext().setAccessibleName("Title");
        headerPanel.add(this.title);
        this.date = new GCheckBox("Date/Time");
        this.date.setSelected(true);
        this.date.addKeyListener(key);
        this.date.getAccessibleContext().setAccessibleName("Date/Time");
        headerPanel.add(this.date);
        this.pageNum = new GCheckBox("Page Numbers");
        this.pageNum.setSelected(true);
        this.pageNum.addKeyListener(key);
        this.pageNum.getAccessibleContext().setAccessibleName("Page Numbers");
        headerPanel.add(this.pageNum);
        JPanel optionsPanel = new JPanel();
        optionsPanel.setLayout(new FlowLayout(0));
        optionsPanel.setBorder(BorderFactory.createTitledBorder("Other Print Options"));
        optionsPanel.getAccessibleContext().setAccessibleName("Other Options");
        this.monochrome = new GCheckBox("Use Monochrome", true);
        this.monochrome.addKeyListener(key);
        this.monochrome.getAccessibleContext().setAccessibleName("Monochrome");
        optionsPanel.add(this.monochrome);
        outerPanel.add((Component)rangePanel, "North");
        outerPanel.add((Component)headerPanel, "Center");
        outerPanel.add((Component)optionsPanel, "South");
        this.setFocusComponent();
        outerPanel.getAccessibleContext().setAccessibleName("Print Options");
        return outerPanel;
    }

    public boolean getSelection() {
        return this.selection.isSelected();
    }

    public boolean getVisible() {
        return this.visible.isSelected();
    }

    public boolean getView() {
        return this.view.isSelected();
    }

    public boolean getPrintTitle() {
        return this.title.isSelected();
    }

    public boolean getPrintDate() {
        return this.date.isSelected();
    }

    public boolean getPrintPageNum() {
        return this.pageNum.isSelected();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }

    public Font getHeaderFont() {
        return Gui.getFont((String)FONT_ID);
    }

    public FontMetrics getHeaderMetrics() {
        return this.rootPanel.getFontMetrics(this.getHeaderFont());
    }

    public boolean showHeader() {
        return this.getPrintTitle();
    }

    public boolean showFooter() {
        return this.getPrintDate() || this.getPrintPageNum();
    }

    public boolean getMonochrome() {
        return this.monochrome.isSelected();
    }

    public int getHeaderHeight() {
        FontMetrics metrics = this.getHeaderMetrics();
        return metrics.getMaxAscent() + metrics.getMaxDescent();
    }

    public void setSelectionEnabled(boolean selectionEnabled) {
        this.selectionEnabled = selectionEnabled;
        this.selection.setEnabled(selectionEnabled);
        this.selection.setSelected(selectionEnabled);
        if (!selectionEnabled) {
            this.view.setSelected(true);
        }
        this.setFocusComponent();
    }

    public void setFocusComponent() {
        if (this.selectionEnabled) {
            this.group.setSelected(this.selection.getModel(), true);
            this.setFocusComponent(this.selection);
        } else {
            this.group.setSelected(this.view.getModel(), true);
            this.setFocusComponent(this.view);
        }
    }
}

