/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.vt.gui.filters;

import docking.widgets.label.GDLabel;
import docking.widgets.label.GLabel;
import ghidra.feature.vt.api.impl.VTEvent;
import ghidra.feature.vt.api.impl.VersionTrackingChangeRecord;
import ghidra.feature.vt.api.main.VTMarkupItem;
import ghidra.feature.vt.api.main.VTMatch;
import ghidra.feature.vt.api.main.VTMatchTag;
import ghidra.feature.vt.api.main.VTSession;
import ghidra.feature.vt.gui.filters.AncillaryFilter;
import ghidra.feature.vt.gui.filters.Filter;
import ghidra.feature.vt.gui.filters.FilterState;
import ghidra.feature.vt.gui.filters.TagFilterChooser;
import ghidra.feature.vt.gui.filters.TagFilterEditorDialog;
import ghidra.feature.vt.gui.plugin.VTController;
import ghidra.feature.vt.gui.plugin.VTControllerListener;
import ghidra.feature.vt.gui.util.MatchInfo;
import ghidra.framework.model.DomainObjectChangeRecord;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.EventType;
import ghidra.framework.options.Options;
import ghidra.framework.options.SaveState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TagFilter
extends AncillaryFilter<VTMatch> {
    private static final String ALL_TAGS_INCLUDED = "<All Tags Included>";
    private static final String ALL_TAGS_EXCLUDED = "<All Tags Excluded>";
    static final String EXCLUDED_TAGS_KEY = "TagFilter.tags";
    private static final String DELIMITER = ":";
    private Map<String, VTMatchTag> excludedTags = new TreeMap<String, VTMatchTag>();
    private JLabel excludedTagsLabel = new GDLabel();
    private JComponent component;
    private final VTController controller;
    private final TagFilterChooser tagChooser;
    private JButton editButton;

    public TagFilter(VTController controller) {
        this(controller, new TagFilterEditorDialog(controller));
    }

    TagFilter(VTController controller, TagFilterChooser tagChooser) {
        this.controller = controller;
        this.tagChooser = tagChooser;
        controller.addListener(new TagUpdateListener());
        this.component = this.createComponent();
        this.initializeTags();
    }

    @Override
    protected Filter<VTMatch> createEmptyCopy() {
        return new TagFilter(this.controller);
    }

    private JComponent createComponent() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createTitledBorder("Tags"));
        this.editButton = new JButton("Edit");
        this.editButton.addActionListener(e -> this.chooseExcludedTags());
        this.editButton.setEnabled(false);
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new BoxLayout(innerPanel, 0));
        innerPanel.add((Component)new GLabel("Excluded Tags: "));
        innerPanel.add(this.excludedTagsLabel);
        innerPanel.add(Box.createHorizontalGlue());
        innerPanel.add(this.editButton);
        panel.add((Component)innerPanel, "North");
        return panel;
    }

    private void chooseExcludedTags() {
        Map<String, VTMatchTag> allTags = this.getAllTags();
        this.excludedTags = this.tagChooser.getExcludedTags(allTags, new TreeMap<String, VTMatchTag>(this.excludedTags));
        this.updateTags(allTags);
    }

    private void initializeTags() {
        this.excludedTags = new TreeMap<String, VTMatchTag>();
        this.updateTags();
    }

    private void reInitializeTags() {
        this.updateTags(this.getAllTags());
    }

    private void updateTags() {
        this.updateTags(this.getAllTags());
    }

    private void updateTags(Map<String, VTMatchTag> allTags) {
        this.fireStatusChanged(this.getFilterStatus());
        if (this.excludedTags.size() == 0) {
            this.excludedTagsLabel.setText(ALL_TAGS_INCLUDED);
            return;
        }
        if (this.excludedTags.size() == allTags.size()) {
            this.excludedTagsLabel.setText(ALL_TAGS_EXCLUDED);
            return;
        }
        String tagText = this.getTagText(this.excludedTags);
        this.excludedTagsLabel.setText(tagText.replaceAll(DELIMITER, ", "));
    }

    private Map<String, VTMatchTag> getAllTags() {
        VTSession session = this.controller.getSession();
        if (session == null) {
            return Collections.emptyMap();
        }
        TreeMap<String, VTMatchTag> map = new TreeMap<String, VTMatchTag>();
        Set<VTMatchTag> matchTags = session.getMatchTags();
        for (VTMatchTag tag : matchTags) {
            map.put(tag.getName(), tag);
        }
        map.put(VTMatchTag.UNTAGGED.getName(), VTMatchTag.UNTAGGED);
        return map;
    }

    private void tagAdded(VTMatchTag tag) {
        this.updateTags();
    }

    private void tagRemoved(String tagName) {
        this.excludedTags.remove(tagName);
        this.updateTags();
    }

    @Override
    public FilterState getFilterState() {
        FilterState state = new FilterState(this);
        state.put(EXCLUDED_TAGS_KEY, new TreeMap<String, VTMatchTag>(this.excludedTags));
        return state;
    }

    @Override
    public Filter.FilterShortcutState getFilterShortcutState() {
        if (this.excludedTags.size() == 0) {
            return Filter.FilterShortcutState.ALWAYS_PASSES;
        }
        Map<String, VTMatchTag> allTags = this.getAllTags();
        if (allTags.size() == this.excludedTags.size()) {
            return Filter.FilterShortcutState.NEVER_PASSES;
        }
        return Filter.FilterShortcutState.REQUIRES_CHECK;
    }

    private String getTagText(Map<String, VTMatchTag> tags) {
        StringBuilder buildy = new StringBuilder();
        Collection<VTMatchTag> values = tags.values();
        for (VTMatchTag tag : values) {
            String tagText = tag.getName();
            if (tag == VTMatchTag.UNTAGGED) {
                tagText = VTMatchTag.UNTAGGED.toString();
            }
            buildy.append(tagText).append(DELIMITER);
        }
        if (buildy.length() > 0) {
            int lastDelimiter = buildy.lastIndexOf(DELIMITER);
            buildy.delete(lastDelimiter, buildy.length());
        }
        return buildy.toString();
    }

    private Map<String, VTMatchTag> getTagsFromText(String tagText) {
        String[] tags;
        Map<String, VTMatchTag> allTags = this.getAllTags();
        TreeMap<String, VTMatchTag> tagFromStringMap = new TreeMap<String, VTMatchTag>();
        for (String tagString : tags = tagText.split(DELIMITER)) {
            VTMatchTag tag = allTags.get(tagString);
            if (tag == null) continue;
            tagFromStringMap.put(tagString, tag);
        }
        return tagFromStringMap;
    }

    @Override
    public void restoreFilterState(FilterState state) {
        Map storedExcludedTags = (Map)state.get(EXCLUDED_TAGS_KEY);
        this.excludedTags.clear();
        if (storedExcludedTags != null) {
            this.excludedTags.putAll(storedExcludedTags);
        }
        this.updateTags();
    }

    @Override
    public void writeConfigState(SaveState saveState) {
        this.removeOldTags();
        String tagText = this.getTagText(this.excludedTags);
        saveState.putString(this.getStateKey(), tagText);
    }

    private String getStateKey() {
        return this.getClass().getName();
    }

    @Override
    public void readConfigState(SaveState saveState) {
        String tagText = saveState.getString(this.getStateKey(), null);
        if (tagText == null) {
            return;
        }
        this.excludedTags = this.getTagsFromText(tagText);
    }

    @Override
    public JComponent getComponent() {
        return this.component;
    }

    @Override
    public Filter.FilterEditingStatus getFilterStatus() {
        if (this.excludedTags.size() != 0) {
            return Filter.FilterEditingStatus.APPLIED;
        }
        return Filter.FilterEditingStatus.NONE;
    }

    @Override
    public boolean passesFilter(VTMatch t) {
        VTMatchTag tag = t.getTag();
        return !this.excludedTags.containsKey(tag.getName());
    }

    private void removeOldTags() {
        Map<String, VTMatchTag> allTags = this.getAllTags();
        for (VTMatchTag tag : this.excludedTags.values()) {
            if (allTags.containsKey(tag.getName())) continue;
            this.excludedTags.remove(tag.getName());
        }
    }

    @Override
    public boolean isSubFilterOf(Filter<VTMatch> otherFilter) {
        Set<String> otherNames;
        Class<?> otherClazz;
        Class<?> clazz = this.getClass();
        if (!clazz.equals(otherClazz = otherFilter.getClass())) {
            return false;
        }
        TagFilter otherTagFilter = (TagFilter)otherFilter;
        Set<String> names = this.excludedTags.keySet();
        return names.containsAll(otherNames = otherTagFilter.excludedTags.keySet());
    }

    public String toString() {
        return this.getClass().getSimpleName() + ": " + String.valueOf(this.excludedTags.keySet());
    }

    private class TagUpdateListener
    implements VTControllerListener {
        private TagUpdateListener() {
        }

        @Override
        public void disposed() {
        }

        @Override
        public void markupItemSelected(VTMarkupItem markupItem) {
        }

        @Override
        public void matchSelected(MatchInfo matchInfo) {
        }

        @Override
        public void optionsChanged(Options options) {
        }

        @Override
        public void sessionChanged(VTSession session) {
            TagFilter.this.editButton.setEnabled(session != null);
            TagFilter.this.reInitializeTags();
        }

        @Override
        public void sessionUpdated(DomainObjectChangedEvent ev) {
            for (int i = 0; i < ev.numRecords(); ++i) {
                VersionTrackingChangeRecord vtRecord;
                DomainObjectChangeRecord doRecord = ev.getChangeRecord(i);
                EventType eventType = doRecord.getEventType();
                if (eventType == VTEvent.TAG_ADDED) {
                    vtRecord = (VersionTrackingChangeRecord)doRecord;
                    TagFilter.this.tagAdded((VTMatchTag)vtRecord.getNewValue());
                    continue;
                }
                if (eventType != VTEvent.TAG_REMOVED) continue;
                vtRecord = (VersionTrackingChangeRecord)doRecord;
                TagFilter.this.tagRemoved((String)vtRecord.getOldValue());
            }
        }
    }
}

