/*
 * Decompiled with CFR 0.152.
 */
package org.catacombae.hfsexplorer.types.resff;

import java.io.PrintStream;
import org.catacombae.csjc.PrintableStruct;
import org.catacombae.csjc.StaticStruct;
import org.catacombae.hfsexplorer.Util;

public class ReferenceListEntry
implements StaticStruct,
PrintableStruct {
    public static final int STRUCTSIZE = 12;
    private final byte[] resourceID = new byte[2];
    private final byte[] resourceNameOffset = new byte[2];
    private final byte[] resourceAttributes = new byte[1];
    private final byte[] resourceDataOffset = new byte[3];
    private final byte[] reserved1 = new byte[4];

    public ReferenceListEntry(byte[] data, int offset) {
        System.arraycopy(data, offset + 0, this.resourceID, 0, 2);
        System.arraycopy(data, offset + 2, this.resourceNameOffset, 0, 2);
        System.arraycopy(data, offset + 4, this.resourceAttributes, 0, 1);
        System.arraycopy(data, offset + 5, this.resourceDataOffset, 0, 3);
        System.arraycopy(data, offset + 8, this.reserved1, 0, 4);
    }

    public static int length() {
        return 12;
    }

    public short getResourceID() {
        return Util.readShortBE(this.resourceID);
    }

    public short getResourceNameOffset() {
        return Util.readShortBE(this.resourceNameOffset);
    }

    public byte getResourceAttributes() {
        return Util.readByteBE(this.resourceAttributes);
    }

    public int getResourceDataOffset() {
        byte[] temp = new byte[4];
        temp[0] = 0;
        System.arraycopy(this.resourceDataOffset, 0, temp, 1, this.resourceDataOffset.length);
        return Util.readIntBE(temp);
    }

    public int getReserved1() {
        return Util.readIntBE(this.reserved1);
    }

    public void printFields(PrintStream ps, String prefix) {
        ps.println(prefix + " resourceID: " + this.getResourceID());
        ps.println(prefix + " resourceNameOffset: " + this.getResourceNameOffset());
        ps.println(prefix + " resourceAttributes: " + this.getResourceAttributes());
        ps.println(prefix + " resourceDataOffset: " + this.getResourceDataOffset());
        ps.println(prefix + " reserved1: " + this.getReserved1());
    }

    public void print(PrintStream ps, String prefix) {
        ps.println(prefix + "ReferenceListEntry:");
        this.printFields(ps, prefix);
    }

    public byte[] getBytes() {
        byte[] result = new byte[ReferenceListEntry.length()];
        int offset = 0;
        System.arraycopy(this.resourceID, 0, result, offset, this.resourceID.length);
        System.arraycopy(this.resourceNameOffset, 0, result, offset += this.resourceID.length, this.resourceNameOffset.length);
        System.arraycopy(this.resourceAttributes, 0, result, offset += this.resourceNameOffset.length, this.resourceAttributes.length);
        System.arraycopy(this.resourceDataOffset, 0, result, offset += this.resourceAttributes.length, this.resourceDataOffset.length);
        System.arraycopy(this.reserved1, 0, result, offset += this.resourceDataOffset.length, this.reserved1.length);
        offset += this.reserved1.length;
        return result;
    }

    public int size() {
        return ReferenceListEntry.length();
    }
}

