/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.icon.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import net.infonode.gui.GraphicsUtil;

public class TreeIcon
implements Icon {
    public static final int PLUS = 1;
    public static final int MINUS = 2;
    private int type;
    private int width;
    private int height;
    private Color color;
    private Color bgColor;
    private boolean border = true;

    public TreeIcon(int type, int width, int height, boolean border, Color color, Color bgColor) {
        this.type = type;
        this.width = width;
        this.height = height;
        this.border = border;
        this.color = color;
        this.bgColor = bgColor;
    }

    public TreeIcon(int type, int width, int height) {
        this(type, width, height, true, Color.BLACK, null);
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        if (this.bgColor != null) {
            g.setColor(this.bgColor);
            g.fillRect(x + 1, y + 1, this.width - 2, this.height - 2);
        }
        g.setColor(this.color);
        if (this.border) {
            g.drawRect(x + 1, y + 1, this.width - 2, this.height - 2);
        }
        GraphicsUtil.drawOptimizedLine(g, x + 3, y + this.height / 2, x + this.width - 3, y + this.height / 2);
        if (this.type == 1) {
            GraphicsUtil.drawOptimizedLine(g, x + this.width / 2, y + 3, x + this.width / 2, y + this.height - 3);
        }
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }
}

