/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.time.mindmapmode;

import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.freeplane.core.resources.TranslatedObject;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.filter.condition.IElementaryConditionController;
import org.freeplane.features.format.FormattedDate;
import org.freeplane.features.time.TimeComboBoxEditor;
import org.freeplane.n3.nanoxml.XMLElement;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionAfter;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionBefore;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionExecuted;
import org.freeplane.view.swing.features.time.mindmapmode.ReminderConditionLater;

class ReminderConditionController
implements IElementaryConditionController {
    static final String FILTER_REMINDER = "filter_reminder";
    private final ComboBoxEditor editor = new TimeComboBoxEditor(true);
    private final ComboBoxModel values = new DefaultComboBoxModel();

    public boolean canEditValues(Object property, TranslatedObject simpleCond) {
        return true;
    }

    public boolean canHandle(Object selectedItem) {
        if (!(selectedItem instanceof TranslatedObject)) {
            return false;
        }
        TranslatedObject namedObject = (TranslatedObject)selectedItem;
        return namedObject.objectEquals((Object)FILTER_REMINDER);
    }

    public boolean canSelectValues(Object property, TranslatedObject simpleCond) {
        if (simpleCond.objectEquals((Object)"filter_reminder_later")) {
            return false;
        }
        return !simpleCond.objectEquals((Object)"filter_reminder_executed");
    }

    public ASelectableCondition createCondition(Object selectedItem, TranslatedObject simpleCond, Object value, boolean matchCase, boolean matchApproximately, boolean ignoreDiacritics) {
        return ReminderConditionController.create(simpleCond, (FormattedDate)value);
    }

    public ComboBoxModel getConditionsForProperty(Object property) {
        return new DefaultComboBoxModel<Object>(this.getTimeConditionNames());
    }

    public ListModel getFilteredProperties() {
        DefaultListModel<TranslatedObject> list = new DefaultListModel<TranslatedObject>();
        list.addElement(TextUtils.createTranslatedString((String)FILTER_REMINDER));
        return list;
    }

    public Object[] getTimeConditionNames() {
        return new TranslatedObject[]{TextUtils.createTranslatedString((String)"filter_reminder_later"), TextUtils.createTranslatedString((String)"filter_reminder_executed"), TextUtils.createTranslatedString((String)"filter_reminder_after"), TextUtils.createTranslatedString((String)"filter_reminder_before")};
    }

    public ComboBoxEditor getValueEditor(Object selectedProperty, TranslatedObject selectedCondition) {
        return this.editor;
    }

    public ComboBoxModel getValuesForProperty(Object selectedItem, TranslatedObject simpleCond) {
        this.values.setSelectedItem(FormattedDate.createDefaultFormattedDate((long)System.currentTimeMillis(), (String)"datetime"));
        return this.values;
    }

    public boolean isCaseDependent(Object property, TranslatedObject simpleCond) {
        return false;
    }

    public boolean supportsApproximateMatching(Object property, TranslatedObject simpleCond) {
        return false;
    }

    public ASelectableCondition loadCondition(XMLElement element) {
        try {
            if (element.getName().equalsIgnoreCase("reminder_condition_later")) {
                return new ReminderConditionLater();
            }
            if (element.getName().equalsIgnoreCase("reminder_condition_earlier")) {
                return new ReminderConditionExecuted();
            }
            if (element.getName().equalsIgnoreCase("reminder_condition_before")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate((long)Long.parseLong(dateString), (String)"datetime");
                return new ReminderConditionBefore(date);
            }
            if (element.getName().equalsIgnoreCase("reminder_condition_after")) {
                String dateString = element.getAttribute("DATE", null);
                FormattedDate date = FormattedDate.createDefaultFormattedDate((long)Long.parseLong(dateString), (String)"datetime");
                return new ReminderConditionAfter(date);
            }
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
        }
        return null;
    }

    public ListCellRenderer getValueRenderer(Object selectedProperty, TranslatedObject selectedCondition) {
        return null;
    }

    private static ASelectableCondition create(TranslatedObject simpleCond, FormattedDate date) {
        if (simpleCond.objectEquals((Object)"filter_reminder_later")) {
            return new ReminderConditionLater();
        }
        if (simpleCond.objectEquals((Object)"filter_reminder_executed")) {
            return new ReminderConditionExecuted();
        }
        if (simpleCond.objectEquals((Object)"filter_reminder_after")) {
            return new ReminderConditionAfter(date);
        }
        if (simpleCond.objectEquals((Object)"filter_reminder_before")) {
            return new ReminderConditionBefore(date);
        }
        return null;
    }
}

