/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.discovery.compatibility;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.equinox.internal.p2.core.helpers.SecureXMLUtil;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Directory;
import org.eclipse.equinox.internal.p2.discovery.compatibility.Messages;
import org.eclipse.equinox.internal.p2.discovery.compatibility.util.DefaultSaxErrorHandler;
import org.eclipse.equinox.internal.p2.discovery.compatibility.util.IOWithCauseException;
import org.eclipse.osgi.util.NLS;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class DirectoryParser {
    public Directory parse(Reader directoryContents) throws IOException {
        XMLReader xmlReader;
        try {
            xmlReader = SecureXMLUtil.newSecureXMLReader();
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new IOWithCauseException(e.getMessage(), e);
        }
        xmlReader.setErrorHandler(new DefaultSaxErrorHandler());
        DirectoryContentHandler contentHandler = new DirectoryContentHandler();
        xmlReader.setContentHandler(contentHandler);
        try {
            xmlReader.parse(new InputSource(directoryContents));
        }
        catch (SAXException e) {
            throw new IOWithCauseException(e.getMessage(), e);
        }
        if (contentHandler.directory == null) {
            throw new IOException(Messages.DirectoryParser_no_directory);
        }
        return contentHandler.directory;
    }

    private static class DirectoryContentHandler
    implements ContentHandler {
        Directory directory;

        private DirectoryContentHandler() {
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void endDocument() throws SAXException {
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
        }

        @Override
        public void endPrefixMapping(String prefix) throws SAXException {
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
        }

        @Override
        public void setDocumentLocator(Locator locator) {
        }

        @Override
        public void skippedEntity(String name) throws SAXException {
        }

        @Override
        public void startDocument() throws SAXException {
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            String url;
            if ("directory".equals(localName)) {
                if (this.directory != null) {
                    this.unexpectedElement(localName);
                }
                this.directory = new Directory();
            } else if (this.directory != null && "entry".equals(localName) && (url = atts.getValue("", "url")) != null && url.length() > 0) {
                Directory.Entry entry = new Directory.Entry();
                entry.setLocation(url);
                entry.setPermitCategories(Boolean.parseBoolean(atts.getValue("permitCategories")));
                this.directory.getEntries().add(entry);
            }
        }

        private void unexpectedElement(String localName) throws SAXException {
            throw new SAXException(NLS.bind((String)Messages.DirectoryParser_unexpected_element, (Object)localName));
        }

        @Override
        public void startPrefixMapping(String prefix, String uri) throws SAXException {
        }
    }
}

