import { Parser } from "./Parser.js";
/*
 * NOTE: If either of these two imports produces a type error,
 * please update your @types/node dependency!
 */
import { Writable } from "node:stream";
import { StringDecoder } from "node:string_decoder";
// Following the example in https://nodejs.org/api/stream.html#stream_decoding_buffers_in_a_writable_stream
function isBuffer(_chunk, encoding) {
    return encoding === "buffer";
}
/**
 * WritableStream makes the `Parser` interface available as a NodeJS stream.
 *
 * @see Parser
 */
export class WritableStream extends Writable {
    constructor(cbs, options) {
        super({ decodeStrings: false });
        this._decoder = new StringDecoder();
        this._parser = new Parser(cbs, options);
    }
    _write(chunk, encoding, callback) {
        this._parser.write(isBuffer(chunk, encoding) ? this._decoder.write(chunk) : chunk);
        callback();
    }
    _final(callback) {
        this._parser.end(this._decoder.end());
        callback();
    }
}//# sourceMappingURL=https://main.vscode-cdn.net/sourcemaps/302ff6a2e235c95b88e587d4a4b6eeb1b6613297/node_modules/htmlparser2/dist/esm/WritableStream.js.map