sap.ui.define([
		'sap/m/library',
		'sap/m/TablePersoController',
		'./DemoPersoService',
		'./Formatter',
		'sap/ui/core/mvc/Controller',
		'sap/ui/model/json/JSONModel'
	], function(mlibrary, TablePersoController, DemoPersoService, Formatter, Controller, JSONModel) {
	"use strict";

	var ResetAllMode =  mlibrary.ResetAllMode;

	var TableController = Controller.extend("sap.m.sample.TablePerso.Table", {

		onInit: function () {

			// set explored app's demo model on this sample
			var oModel = new JSONModel(sap.ui.require.toUrl("sap/ui/demo/mock/products.json"));
			var oGroupingModel = new JSONModel({ hasGrouping: false});
			this.getView().setModel(oModel);
			this.getView().setModel(oGroupingModel, 'Grouping');

			// init and activate controller
			this._oTPC = new TablePersoController({
				table: this.byId("productsTable"),
				//specify the first part of persistence ids e.g. 'demoApp-productsTable-dimensionsCol'
				componentName: "demoApp",
				resetAllMode: ResetAllMode.ServiceReset,
				persoService: DemoPersoService
			}).activate();
		},

		onExit: function () {
			this._oTPC.destroy();
		},

		onPersoButtonPressed: function (oEvent) {
			this._oTPC.openDialog();
		},

		onTablePersoRefresh : function() {
			DemoPersoService.resetPersData().done(
				function() {
					this._oTPC.refresh();
				}.bind(this)
			);
		},

		onTableGrouping : function(oEvent) {
			this._oTPC.setHasGrouping(oEvent.getSource().getSelected());
		}

	});


	return TableController;

});