/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.resolve.processors.inference;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.ConstraintFormula;
import com.intellij.psi.impl.source.resolve.graphInference.constraints.TypeCompatibilityConstraint;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyMethodResult;
import org.jetbrains.plugins.groovy.lang.psi.api.GroovyResolveResult;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrNewExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.resolve.api.ArgumentMapping;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GrConstraintFormula;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.GroovyInferenceSession;
import org.jetbrains.plugins.groovy.lang.resolve.processors.inference.InferenceKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u000bH\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/ConstructorCallConstraint;", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GrConstraintFormula;", "leftType", "Lcom/intellij/psi/PsiType;", "expression", "Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrNewExpression;", "<init>", "(Lcom/intellij/psi/PsiType;Lorg/jetbrains/plugins/groovy/lang/psi/api/statements/expressions/GrNewExpression;)V", "reduce", "", "session", "Lorg/jetbrains/plugins/groovy/lang/resolve/processors/inference/GroovyInferenceSession;", "constraints", "", "Lcom/intellij/psi/impl/source/resolve/graphInference/constraints/ConstraintFormula;", "runConstructorSession", "", "classSession", "toString", "", "intellij.groovy.psi"})
public final class ConstructorCallConstraint
extends GrConstraintFormula {
    @Nullable
    private final PsiType leftType;
    @NotNull
    private final GrNewExpression expression;

    public ConstructorCallConstraint(@Nullable PsiType leftType, @NotNull GrNewExpression expression) {
        Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
        this.leftType = leftType;
        this.expression = expression;
    }

    @Override
    public boolean reduce(@NotNull GroovyInferenceSession session, @NotNull List<? super ConstraintFormula> constraints) {
        Intrinsics.checkNotNullParameter((Object)((Object)session), (String)"session");
        Intrinsics.checkNotNullParameter(constraints, (String)"constraints");
        GrCodeReferenceElement grCodeReferenceElement = this.expression.getReferenceElement();
        if (grCodeReferenceElement == null) {
            return true;
        }
        GrCodeReferenceElement reference = grCodeReferenceElement;
        GroovyResolveResult groovyResolveResult = reference.advancedResolve();
        Intrinsics.checkNotNullExpressionValue((Object)groovyResolveResult, (String)"advancedResolve(...)");
        GroovyResolveResult result2 = groovyResolveResult;
        PsiElement psiElement = result2.getElement();
        PsiClass psiClass = psiElement instanceof PsiClass ? (PsiClass)psiElement : null;
        if (psiClass == null) {
            return true;
        }
        PsiClass clazz = psiClass;
        PsiSubstitutor psiSubstitutor = result2.getContextSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getContextSubstitutor(...)");
        PsiSubstitutor contextSubstitutor = psiSubstitutor;
        PsiTypeParameter[] psiTypeParameterArray = clazz.getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        session.startNestedSession(psiTypeParameterArray, contextSubstitutor, this.expression, result2, (Function1<? super GroovyInferenceSession, Unit>)((Function1)arg_0 -> ConstructorCallConstraint.reduce$lambda$0(this, contextSubstitutor, clazz, arg_0)));
        return true;
    }

    private final void runConstructorSession(GroovyInferenceSession classSession) {
        GroovyResolveResult groovyResolveResult = this.expression.advancedResolve();
        GroovyMethodResult groovyMethodResult = groovyResolveResult instanceof GroovyMethodResult ? (GroovyMethodResult)groovyResolveResult : null;
        if (groovyMethodResult == null) {
            return;
        }
        GroovyMethodResult result2 = groovyMethodResult;
        Object object = result2.getCandidate();
        if (object == null || (object = object.getArgumentMapping()) == null) {
            return;
        }
        Object mapping = object;
        PsiTypeParameter[] psiTypeParameterArray = result2.getElement().getTypeParameters();
        Intrinsics.checkNotNullExpressionValue((Object)psiTypeParameterArray, (String)"getTypeParameters(...)");
        PsiSubstitutor psiSubstitutor = result2.getContextSubstitutor();
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getContextSubstitutor(...)");
        classSession.startNestedSession(psiTypeParameterArray, psiSubstitutor, this.expression, result2, (Function1<? super GroovyInferenceSession, Unit>)((Function1)arg_0 -> ConstructorCallConstraint.runConstructorSession$lambda$1((ArgumentMapping)mapping, classSession, arg_0)));
    }

    @Override
    @NotNull
    public String toString() {
        PsiType psiType = this.leftType;
        return this.expression.getText() + " -> " + (psiType != null ? psiType.getPresentableText() : null);
    }

    private static final Unit reduce$lambda$0(ConstructorCallConstraint this$0, PsiSubstitutor $contextSubstitutor, PsiClass $clazz, GroovyInferenceSession nested) {
        PsiType classType;
        PsiType left;
        Intrinsics.checkNotNullParameter((Object)((Object)nested), (String)"nested");
        this$0.runConstructorSession(nested);
        if (this$0.leftType != null && (left = nested.substituteWithInferenceVariables(this$0.leftType)) != null && (classType = nested.substituteWithInferenceVariables($contextSubstitutor.substitute((PsiType)InferenceKt.type($clazz)))) != null) {
            nested.addConstraint((ConstraintFormula)new TypeCompatibilityConstraint(left, classType));
        }
        nested.repeatInferencePhases();
        return Unit.INSTANCE;
    }

    private static final Unit runConstructorSession$lambda$1(ArgumentMapping $mapping, GroovyInferenceSession $classSession, GroovyInferenceSession it) {
        Intrinsics.checkNotNullParameter((Object)((Object)it), (String)"it");
        PsiSubstitutor psiSubstitutor = $classSession.getInferenceSubstitution();
        Intrinsics.checkNotNullExpressionValue((Object)psiSubstitutor, (String)"getInferenceSubstitution(...)");
        it.initArgumentConstraints($mapping, psiSubstitutor);
        it.repeatInferencePhases();
        return Unit.INSTANCE;
    }
}

