/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.completion;

import com.intellij.codeInsight.PsiEquivalenceUtil;
import com.intellij.codeInsight.completion.PrefixMatcher;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMember;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public final class CompleteReferencesWithSameQualifier {
    private final GrReferenceExpression myRefExpr;
    private final PrefixMatcher myMatcher;
    private final GrExpression myQualifier;

    private CompleteReferencesWithSameQualifier(@NotNull GrReferenceExpression refExpr, @NotNull PrefixMatcher matcher, @Nullable GrExpression qualifier) {
        if (refExpr == null) {
            CompleteReferencesWithSameQualifier.$$$reportNull$$$0(0);
        }
        if (matcher == null) {
            CompleteReferencesWithSameQualifier.$$$reportNull$$$0(1);
        }
        this.myRefExpr = refExpr;
        this.myMatcher = matcher;
        this.myQualifier = qualifier;
    }

    @NotNull
    public static Set<String> getVariantsWithSameQualifier(@NotNull GrReferenceExpression refExpr, @NotNull PrefixMatcher matcher, @Nullable GrExpression qualifier) {
        if (refExpr == null) {
            CompleteReferencesWithSameQualifier.$$$reportNull$$$0(2);
        }
        if (matcher == null) {
            CompleteReferencesWithSameQualifier.$$$reportNull$$$0(3);
        }
        Set<String> set = new CompleteReferencesWithSameQualifier(refExpr, matcher, qualifier).getVariantsWithSameQualifierImpl();
        if (set == null) {
            CompleteReferencesWithSameQualifier.$$$reportNull$$$0(4);
        }
        return set;
    }

    private Set<String> getVariantsWithSameQualifierImpl() {
        if (this.myQualifier != null && this.myQualifier.getType() != null) {
            return Collections.emptySet();
        }
        PsiElement scope = PsiTreeUtil.getParentOfType((PsiElement)this.myRefExpr, (Class[])new Class[]{GrMember.class, PsiFile.class});
        LinkedHashSet<String> result2 = new LinkedHashSet<String>();
        if (scope != null) {
            this.addVariantsWithSameQualifier(scope, result2);
        }
        return result2;
    }

    private void addVariantsWithSameQualifier(@NotNull PsiElement element, @NotNull Set<String> result2) {
        if (element == null) {
            CompleteReferencesWithSameQualifier.$$$reportNull$$$0(5);
        }
        if (result2 == null) {
            CompleteReferencesWithSameQualifier.$$$reportNull$$$0(6);
        }
        if (element instanceof GrReferenceExpression) {
            String refName;
            GrReferenceExpression refExpr = (GrReferenceExpression)element;
            if (element != this.myRefExpr && !PsiUtil.isLValue((GroovyPsiElement)element) && (refName = refExpr.getReferenceName()) != null && !result2.contains(refName) && this.myMatcher.prefixMatches(refName)) {
                GrExpression hisQualifier = refExpr.getQualifierExpression();
                if (hisQualifier != null && this.myQualifier != null) {
                    if (PsiEquivalenceUtil.areElementsEquivalent((PsiElement)hisQualifier, (PsiElement)this.myQualifier) && refExpr.resolve() == null) {
                        result2.add(refName);
                    }
                } else if (hisQualifier == null && this.myQualifier == null && refExpr.resolve() == null) {
                    result2.add(refName);
                }
            }
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            this.addVariantsWithSameQualifier(child, result2);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "refExpr";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "matcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/completion/CompleteReferencesWithSameQualifier";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/completion/CompleteReferencesWithSameQualifier";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariantsWithSameQualifier";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getVariantsWithSameQualifier";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addVariantsWithSameQualifier";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

