/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mcpserver.toolsets.general;

import com.intellij.find.FindBundle;
import com.intellij.find.FindManager;
import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.mcpserver.McpToolKt;
import com.intellij.mcpserver.McpToolset;
import com.intellij.mcpserver.ProjectContextElementKt;
import com.intellij.mcpserver.annotations.McpDescription;
import com.intellij.mcpserver.annotations.McpTool;
import com.intellij.mcpserver.toolsets.general.TextToolset;
import com.intellij.mcpserver.toolsets.general.TextToolset$UsageInfoEntry$;
import com.intellij.mcpserver.toolsets.general.TextToolset$UsageInfoResult$;
import com.intellij.mcpserver.util.Fs_utilKt;
import com.intellij.mcpserver.util.Text_utilKt;
import com.intellij.mcpserver.util.TruncateMode;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.platform.ide.progress.TasksKt;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.util.Processor;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import kotlin.time.DurationKt;
import kotlin.time.DurationUnit;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.serialization.EncodeDefault;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.Serializable;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.descriptors.SerialDescriptor;
import kotlinx.serialization.encoding.CompositeEncoder;
import kotlinx.serialization.internal.ArrayListSerializer;
import kotlinx.serialization.internal.PluginExceptionsKt;
import kotlinx.serialization.internal.SerializationConstructorMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001:\u0002\"#B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J,\u0010\u0004\u001a\u00020\u00052\b\b\u0001\u0010\u0006\u001a\u00020\u00052\b\b\u0003\u0010\u0007\u001a\u00020\b2\b\b\u0003\u0010\t\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\u000bJ@\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u0006\u001a\u00020\u00052\b\b\u0001\u0010\u000e\u001a\u00020\u00052\b\b\u0001\u0010\u000f\u001a\u00020\u00052\b\b\u0003\u0010\u0010\u001a\u00020\u00112\b\b\u0003\u0010\u0012\u001a\u00020\u0011H\u0087@\u00a2\u0006\u0002\u0010\u0013JN\u0010\u0014\u001a\u00020\u00152\b\b\u0001\u0010\u0016\u001a\u00020\u00052\n\b\u0003\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0003\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0012\u001a\u00020\u00112\b\b\u0003\u0010\u0019\u001a\u00020\n2\b\b\u0003\u0010\u001a\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\u001bJN\u0010\u001c\u001a\u00020\u00152\b\b\u0001\u0010\u001d\u001a\u00020\u00052\n\b\u0003\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0003\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\b\u0003\u0010\u0012\u001a\u00020\u00112\b\b\u0003\u0010\u0019\u001a\u00020\n2\b\b\u0003\u0010\u001a\u001a\u00020\nH\u0087@\u00a2\u0006\u0002\u0010\u001bJT\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001f\u001a\u00020\u00052\u0006\u0010 \u001a\u00020\u00112\n\b\u0002\u0010\u0017\u001a\u0004\u0018\u00010\u00052\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0019\u001a\u00020\n2\b\b\u0002\u0010\u001a\u001a\u00020\nH\u0082@\u00a2\u0006\u0002\u0010!\u00a8\u0006$"}, d2={"Lcom/intellij/mcpserver/toolsets/general/TextToolset;", "Lcom/intellij/mcpserver/McpToolset;", "<init>", "()V", "get_file_text_by_path", "", "pathInProject", "truncateMode", "Lcom/intellij/mcpserver/util/TruncateMode;", "maxLinesCount", "", "(Ljava/lang/String;Lcom/intellij/mcpserver/util/TruncateMode;ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "replace_text_in_file", "", "oldText", "newText", "replaceAll", "", "caseSensitive", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZZLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "search_in_files_by_text", "Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoResult;", "searchText", "directoryToSearch", "fileMask", "maxUsageCount", "timeout", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;ZIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "search_in_files_by_regex", "regexPattern", "search_in_files", "searchTextOrRegex", "isRegex", "(Ljava/lang/String;ZLjava/lang/String;Ljava/lang/String;ZIILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "UsageInfoEntry", "UsageInfoResult", "intellij.mcpserver"})
@SourceDebugExtension(value={"SMAP\nTextToolset.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TextToolset.kt\ncom/intellij/mcpserver/toolsets/general/TextToolset\n+ 2 CoroutineScope.kt\nkotlinx/coroutines/CoroutineScopeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,263:1\n374#2:264\n374#2:265\n374#2:266\n1617#3,9:267\n1869#3:276\n1870#3:278\n1626#3:279\n1#4:277\n*S KotlinDebug\n*F\n+ 1 TextToolset.kt\ncom/intellij/mcpserver/toolsets/general/TextToolset\n*L\n54#1:264\n105#1:265\n189#1:266\n230#1:267,9\n230#1:276\n230#1:278\n230#1:279\n230#1:277\n*E\n"})
public final class TextToolset
implements McpToolset {
    /*
     * Unable to fully structure code
     */
    @McpTool
    @McpDescription(description="\n        Retrieves the text content of a file using its path relative to project root.\n        Use this tool to read file contents when you have the file's project-relative path.\n        In the case of binary files, the tool returns an error.\n        If the file is too large, the text will be truncated with '<<<...content truncated...>>>' marker and in according to the `truncateMode` parameter.\n    ")
    @Nullable
    public final Object get_file_text_by_path(@McpDescription(description="Path relative to the project root") @NotNull String pathInProject, @McpDescription(description="How to truncate the text: from the start, in the middle, at the end, or don't truncate at all") @NotNull TruncateMode truncateMode, @McpDescription(description="Max number of lines to return. Truncation will be performed depending on truncateMode.") int maxLinesCount, @NotNull Continuation<? super String> $completion) {
        if (!($completion instanceof get_file_text_by_path.1)) ** GOTO lbl-1000
        var9_5 = $completion;
        if ((var9_5.label & -2147483648) != 0) {
            var9_5.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ TextToolset this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.get_file_text_by_path(null, null, 0, (Continuation<? super String>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var10_7 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$currentCoroutineContext = false;
                project = ProjectContextElementKt.getProject($continuation.getContext());
                resolvedPath = Fs_utilKt.resolveInProject$default(project, pathInProject, false, 2, null);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)pathInProject);
                $continuation.L$1 = truncateMode;
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)resolvedPath);
                $continuation.I$0 = maxLinesCount;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, get_file_text_by_path$lambda$0(java.nio.file.Path ), ()Ljava/lang/String;)((Path)resolvedPath), (Continuation)$continuation);
                if (v0 == var10_7) {
                    return var10_7;
                }
                ** GOTO lbl34
            }
            case 1: {
                maxLinesCount = $continuation.I$0;
                resolvedPath = (Path)$continuation.L$3;
                project = (Project)$continuation.L$2;
                truncateMode = (TruncateMode)$continuation.L$1;
                pathInProject = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl34:
                // 2 sources

                originalText = (String)v0;
                return Text_utilKt.truncateText(originalText, maxLinesCount, 65536, truncateMode, "<<<...content truncated...>>>");
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object get_file_text_by_path$default(TextToolset textToolset, String string, TruncateMode truncateMode, int n, Continuation continuation, int n2, Object object) {
        if ((n2 & 2) != 0) {
            truncateMode = TruncateMode.START;
        }
        if ((n2 & 4) != 0) {
            n = 1000;
        }
        return textToolset.get_file_text_by_path(string, truncateMode, n, (Continuation<? super String>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    @McpTool
    @McpDescription(description="\n        Replaces text in a file with flexible options for find and replace operations.\n        Use this tool to make targeted changes without replacing the entire file content.\n        This is the most efficient tool for file modifications when you know the exact text to replace.\n        \n        Requires three parameters:\n        - pathInProject: The path to the target file, relative to project root\n        - oldTextOrPatte: The text to be replaced (exact match by default)\n        - newText: The replacement text\n        \n        Optional parameters:\n        - replaceAll: Whether to replace all occurrences (default: true)\n        - caseSensitive: Whether the search is case-sensitive (default: true)\n        - regex: Whether to treat oldText as a regular expression (default: false)\n        \n        Returns one of these responses:\n        - \"ok\" when replacement happened\n        - error \"project dir not found\" if project directory cannot be determined\n        - error \"file not found\" if the file doesn't exist\n        - error \"could not get document\" if the file content cannot be accessed\n        - error \"no occurrences found\" if the old text was not found in the file\n        \n        Note: Automatically saves the file after modification\n    ")
    @Nullable
    public final Object replace_text_in_file(@McpDescription(description="Path to target file relative to project root") @NotNull String pathInProject, @McpDescription(description="Text to be replaced") @NotNull String oldText, @McpDescription(description="Replacement text") @NotNull String newText, @McpDescription(description="Replace all occurrences") boolean replaceAll, @McpDescription(description="Case-sensitive search") boolean caseSensitive, @NotNull Continuation<? super Unit> $completion) {
        if (!($completion instanceof replace_text_in_file.1)) ** GOTO lbl-1000
        var17_7 = $completion;
        if ((var17_7.label & -2147483648) != 0) {
            var17_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                boolean Z$0;
                boolean Z$1;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ TextToolset this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.replace_text_in_file(null, null, null, false, false, (Continuation<? super Unit>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var18_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$currentCoroutineContext = false;
                project = ProjectContextElementKt.getProject($continuation.getContext());
                resolvedPath = Fs_utilKt.resolveInProject$default(project, pathInProject, false, 2, null);
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)pathInProject);
                $continuation.L$1 = oldText;
                $continuation.L$2 = newText;
                $continuation.L$3 = project;
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)resolvedPath);
                $continuation.Z$0 = replaceAll;
                $continuation.Z$1 = caseSensitive;
                $continuation.label = 1;
                v0 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, replace_text_in_file$lambda$1(java.nio.file.Path java.lang.String ), ()Lkotlin/Pair;)((Path)resolvedPath, (String)pathInProject), (Continuation)$continuation);
                if (v0 == var18_9) {
                    return var18_9;
                }
                ** GOTO lbl38
            }
            case 1: {
                caseSensitive = $continuation.Z$1;
                replaceAll = $continuation.Z$0;
                resolvedPath = (Path)$continuation.L$4;
                project = (Project)$continuation.L$3;
                newText = (String)$continuation.L$2;
                oldText = (String)$continuation.L$1;
                pathInProject = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 2 sources

                var9_15 = (Pair)v0;
                document = (Document)var9_15.component1();
                v1 = var9_15.component2();
                Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"component2(...)");
                text = (String)v1;
                rangeMarkers = new ArrayList<E>();
                currentStartIndex = 0;
                while ((occurrenceStart = StringsKt.indexOf((CharSequence)text, (String)oldText, (int)currentStartIndex, (boolean)(caseSensitive == false))) >= 0) {
                    Intrinsics.checkNotNullExpressionValue((Object)document.createRangeMarker(occurrenceStart, occurrenceStart + oldText.length(), true), (String)"createRangeMarker(...)");
                    rangeMarkers.add(rangeMarker);
                    if (!replaceAll) break;
                    currentStartIndex = occurrenceStart + oldText.length();
                }
                v2 = FindBundle.message((String)"find.replace.text.dialog.title", (Object[])new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"message(...)");
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)pathInProject);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)oldText);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)newText);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$4 = SpillingKt.nullOutSpilledVariable((Object)resolvedPath);
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)document);
                $continuation.L$6 = SpillingKt.nullOutSpilledVariable((Object)text);
                $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)rangeMarkers);
                $continuation.Z$0 = replaceAll;
                $continuation.Z$1 = caseSensitive;
                $continuation.I$0 = currentStartIndex;
                $continuation.label = 2;
                v3 = com.intellij.openapi.command.CoroutinesKt.writeCommandAction((Project)project, (String)v2, (Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, replace_text_in_file$lambda$2(java.util.List com.intellij.openapi.editor.Document java.lang.String ), ()Lkotlin/Unit;)((List)rangeMarkers, (Document)document, (String)newText), (Continuation)$continuation);
                if (v3 == var18_9) {
                    return var18_9;
                }
                ** GOTO lbl85
            }
            case 2: {
                currentStartIndex = $continuation.I$0;
                caseSensitive = $continuation.Z$1;
                replaceAll = $continuation.Z$0;
                rangeMarkers = (List)$continuation.L$7;
                text = (String)$continuation.L$6;
                document = (Document)$continuation.L$5;
                resolvedPath = (Path)$continuation.L$4;
                project = (Project)$continuation.L$3;
                newText = (String)$continuation.L$2;
                oldText = (String)$continuation.L$1;
                pathInProject = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl85:
                // 2 sources

                return Unit.INSTANCE;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    public static /* synthetic */ Object replace_text_in_file$default(TextToolset textToolset, String string, String string2, String string3, boolean bl, boolean bl2, Continuation continuation, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            bl2 = true;
        }
        return textToolset.replace_text_in_file(string, string2, string3, bl, bl2, (Continuation<? super Unit>)continuation);
    }

    @McpTool
    @McpDescription(description="\n        |Searches for a text substring within all files in the project using IntelliJ's search engine.\n        |Prefer this tool over reading files with command-line tools because it's much faster.\n        |\n        |The result occurrences are surrounded with `||` characters, e.g. `some text ||substring|| text`\n    ")
    @Nullable
    public final Object search_in_files_by_text(@McpDescription(description="Text substring to search for") @NotNull String searchText, @McpDescription(description="Directory to search in, relative to project root. If not specified, searches in the entire project.") @Nullable String directoryToSearch, @McpDescription(description="File mask to search for. If not specified, searches for all files. Example: `*.java`") @Nullable String fileMask, @McpDescription(description="Whether to search for the text in a case-sensitive manner") boolean caseSensitive, @McpDescription(description="Maximum number of entries to return.") int maxUsageCount, @McpDescription(description="Timeout in milliseconds") int timeout, @NotNull Continuation<? super UsageInfoResult> $completion) {
        return this.search_in_files(searchText, false, directoryToSearch, fileMask, caseSensitive, maxUsageCount, timeout, $completion);
    }

    public static /* synthetic */ Object search_in_files_by_text$default(TextToolset textToolset, String string, String string2, String string3, boolean bl, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            string3 = null;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        if ((n3 & 0x10) != 0) {
            n = 1000;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 10000;
        }
        return textToolset.search_in_files_by_text(string, string2, string3, bl, n, n2, (Continuation<? super UsageInfoResult>)continuation);
    }

    @McpTool
    @McpDescription(description="\n        |Searches with a regex pattern within all files in the project using IntelliJ's search engine.\n        |Prefer this tool over reading files with command-line tools because it's much faster.\n        |\n        |The result occurrences are surrounded with || characters, e.g. `some text ||substring|| text`\n    ")
    @Nullable
    public final Object search_in_files_by_regex(@McpDescription(description="Regex patter to search for") @NotNull String regexPattern, @McpDescription(description="Directory to search in, relative to project root. If not specified, searches in the entire project.") @Nullable String directoryToSearch, @McpDescription(description="File mask to search for. If not specified, searches for all files. Example: `*.java`") @Nullable String fileMask, @McpDescription(description="Whether to search for the text in a case-sensitive manner") boolean caseSensitive, @McpDescription(description="Maximum number of entries to return.") int maxUsageCount, @McpDescription(description="Timeout in milliseconds") int timeout, @NotNull Continuation<? super UsageInfoResult> $completion) {
        return this.search_in_files(regexPattern, true, directoryToSearch, fileMask, caseSensitive, maxUsageCount, timeout, $completion);
    }

    public static /* synthetic */ Object search_in_files_by_regex$default(TextToolset textToolset, String string, String string2, String string3, boolean bl, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 2) != 0) {
            string2 = null;
        }
        if ((n3 & 4) != 0) {
            string3 = null;
        }
        if ((n3 & 8) != 0) {
            bl = true;
        }
        if ((n3 & 0x10) != 0) {
            n = 1000;
        }
        if ((n3 & 0x20) != 0) {
            n2 = 10000;
        }
        return textToolset.search_in_files_by_regex(string, string2, string3, bl, n, n2, (Continuation<? super UsageInfoResult>)continuation);
    }

    /*
     * Unable to fully structure code
     */
    private final Object search_in_files(String searchTextOrRegex, boolean isRegex, String directoryToSearch, String fileMask, boolean caseSensitive, int maxUsageCount, int timeout, Continuation<? super UsageInfoResult> $completion) {
        if (!($completion instanceof search_in_files.1)) ** GOTO lbl-1000
        var41_9 = $completion;
        if ((var41_9.label & -2147483648) != 0) {
            var41_9.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                Object L$5;
                Object L$6;
                Object L$7;
                Object L$8;
                Object L$9;
                Object L$10;
                Object L$11;
                Object L$12;
                Object L$13;
                Object L$14;
                Object L$15;
                boolean Z$0;
                boolean Z$1;
                int I$0;
                int I$1;
                int I$2;
                int I$3;
                int I$4;
                int I$5;
                int I$6;
                int I$7;
                /* synthetic */ Object result;
                final /* synthetic */ TextToolset this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return TextToolset.access$search_in_files(this.this$0, null, false, null, null, false, 0, 0, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var42_11 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                $i$f$currentCoroutineContext = false;
                project = ProjectContextElementKt.getProject($continuation.getContext());
                projectDir = Fs_utilKt.getProjectDirectory(project);
                if (StringsKt.isBlank((CharSequence)searchTextOrRegex)) {
                    McpToolKt.mcpFail("Search text is empty");
                    throw new KotlinNothingValueException();
                }
                $this$search_in_files_u24lambda_u243 = var12_15 = FindManager.getInstance((Project)project).getFindInProjectModel().clone();
                $i$a$-apply-TextToolset$search_in_files$findModel$1 = false;
                $this$search_in_files_u24lambda_u243.setStringToFind(searchTextOrRegex);
                $this$search_in_files_u24lambda_u243.setCaseSensitive(false);
                $this$search_in_files_u24lambda_u243.setWholeWordsOnly(false);
                $this$search_in_files_u24lambda_u243.setRegularExpressions(false);
                $this$search_in_files_u24lambda_u243.setProjectScope(true);
                $this$search_in_files_u24lambda_u243.setSearchInProjectFiles(false);
                $this$search_in_files_u24lambda_u243.setFileFilter(fileMask);
                $this$search_in_files_u24lambda_u243.setCaseSensitive(caseSensitive != false);
                $this$search_in_files_u24lambda_u243.setRegularExpressions(isRegex != false);
                if (directoryToSearch != null) {
                    directoryToSearchPath = Fs_utilKt.resolveInProject$default(project, directoryToSearch, false, 2, null);
                    v0 = new LinkOption[]{};
                    if (!Files.isDirectory(directoryToSearchPath, Arrays.copyOf(v0, v0.length))) {
                        McpToolKt.mcpFail("The specified path '" + directoryToSearch + "' is not a directory.");
                        throw new KotlinNothingValueException();
                    }
                    $this$search_in_files_u24lambda_u243.setDirectoryName(directoryToSearchPath.toString());
                }
                findModel = var12_15;
                usages = new CopyOnWriteArrayList();
                $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)searchTextOrRegex);
                $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)directoryToSearch);
                $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fileMask);
                $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)project);
                $continuation.L$4 = projectDir;
                $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)findModel);
                $continuation.L$6 = usages;
                $continuation.Z$0 = isRegex;
                $continuation.Z$1 = caseSensitive;
                $continuation.I$0 = maxUsageCount;
                $continuation.I$1 = timeout;
                $continuation.label = 1;
                v1 = TimeoutKt.withTimeoutOrNull-KLykuaI((long)DurationKt.toDuration((int)timeout, (DurationUnit)DurationUnit.MILLISECONDS), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, searchTextOrRegex, findModel, (CopyOnWriteArrayList<UsageInfo>)usages, maxUsageCount, null){
                    Object L$0;
                    int label;
                    final /* synthetic */ Project $project;
                    final /* synthetic */ String $searchTextOrRegex;
                    final /* synthetic */ FindModel $findModel;
                    final /* synthetic */ CopyOnWriteArrayList<UsageInfo> $usages;
                    final /* synthetic */ int $maxUsageCount;
                    {
                        this.$project = $project;
                        this.$searchTextOrRegex = $searchTextOrRegex;
                        this.$findModel = $findModel;
                        this.$usages = $usages;
                        this.$maxUsageCount = $maxUsageCount;
                        super(2, $completion);
                    }

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    public final Object invokeSuspend(Object $result) {
                        Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)$result);
                                Processor processor = arg_0 -> search_in_files.timedOut.1.invokeSuspend$lambda$0(this.$usages, this.$maxUsageCount, arg_0);
                                Object[] objectArray = new Object[2];
                                objectArray[0] = this.$searchTextOrRegex;
                                String string = this.$findModel.getDirectoryName();
                                if (string == null) {
                                    String string2 = FindBundle.message((String)"find.scope.project.title", (Object[])new Object[0]);
                                    string = string2;
                                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
                                }
                                objectArray[1] = string;
                                String string3 = FindBundle.message((String)"find.searching.for.string.in.file.progress", (Object[])objectArray);
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
                                this.L$0 = SpillingKt.nullOutSpilledVariable((Object)processor);
                                this.label = 1;
                                Object object2 = TasksKt.withBackgroundProgress((Project)this.$project, (String)string3, (boolean)true, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$findModel, this.$project, (Processor<UsageInfo>)processor, null){
                                    int label;
                                    final /* synthetic */ FindModel $findModel;
                                    final /* synthetic */ Project $project;
                                    final /* synthetic */ Processor<UsageInfo> $processor;
                                    {
                                        this.$findModel = $findModel;
                                        this.$project = $project;
                                        this.$processor = $processor;
                                        super(2, $completion);
                                    }

                                    public final Object invokeSuspend(Object $result) {
                                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)$result);
                                                FindInProjectUtil.findUsages((FindModel)this.$findModel, (Project)this.$project, this.$processor, (FindUsagesProcessPresentation)new FindUsagesProcessPresentation(new UsageViewPresentation()));
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (object2 != object) return Unit.INSTANCE;
                                return object;
                            }
                            case 1: {
                                Processor processor = (Processor)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object2 = $result;
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }

                    private static final boolean invokeSuspend$lambda$0(CopyOnWriteArrayList $usages, int $maxUsageCount, UsageInfo usageInfo) {
                        $usages.add(usageInfo);
                        return $usages.size() < $maxUsageCount;
                    }
                }), (Continuation)$continuation);
                if (v1 == var42_11) {
                    return var42_11;
                }
                ** GOTO lbl73
            }
            case 1: {
                timeout = $continuation.I$1;
                maxUsageCount = $continuation.I$0;
                caseSensitive = $continuation.Z$1;
                isRegex = $continuation.Z$0;
                usages = (CopyOnWriteArrayList)$continuation.L$6;
                findModel = (FindModel)$continuation.L$5;
                projectDir = (Path)$continuation.L$4;
                project = (Project)$continuation.L$3;
                fileMask = (String)$continuation.L$2;
                directoryToSearch = (String)$continuation.L$1;
                searchTextOrRegex = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v1 = $result;
lbl73:
                // 2 sources

                timedOut = v1 == null ? 1 : 0;
                $this$mapNotNull$iv = usages;
                $i$f$mapNotNull = 0;
                var17_23 = $this$mapNotNull$iv;
                destination$iv$iv = new ArrayList<E>();
                $i$f$mapNotNullTo = 0;
                $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                $i$f$forEach = 0;
                var22_28 = $this$forEach$iv$iv$iv.iterator();
lbl82:
                // 3 sources

                while (var22_28.hasNext()) {
                    element$iv$iv = element$iv$iv$iv = var22_28.next();
                    $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = 0;
                    usage = (UsageInfo)element$iv$iv;
                    $i$a$-mapNotNull-TextToolset$search_in_files$entries$1 = 0;
                    if (usage.getVirtualFile() != null) ** GOTO lbl90
                    v2 = null;
                    ** GOTO lbl165
lbl90:
                    // 1 sources

                    $continuation.L$0 = SpillingKt.nullOutSpilledVariable((Object)searchTextOrRegex);
                    $continuation.L$1 = SpillingKt.nullOutSpilledVariable((Object)directoryToSearch);
                    $continuation.L$2 = SpillingKt.nullOutSpilledVariable((Object)fileMask);
                    $continuation.L$3 = SpillingKt.nullOutSpilledVariable((Object)project);
                    $continuation.L$4 = projectDir;
                    $continuation.L$5 = SpillingKt.nullOutSpilledVariable((Object)findModel);
                    $continuation.L$6 = usages;
                    $continuation.L$7 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNull$iv);
                    $continuation.L$8 = SpillingKt.nullOutSpilledVariable((Object)$this$mapNotNullTo$iv$iv);
                    $continuation.L$9 = destination$iv$iv;
                    $continuation.L$10 = SpillingKt.nullOutSpilledVariable((Object)$this$forEach$iv$iv$iv);
                    $continuation.L$11 = var22_28;
                    $continuation.L$12 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv$iv);
                    $continuation.L$13 = SpillingKt.nullOutSpilledVariable((Object)element$iv$iv);
                    $continuation.L$14 = usage;
                    $continuation.L$15 = file;
                    $continuation.Z$0 = isRegex;
                    $continuation.Z$1 = caseSensitive;
                    $continuation.I$0 = maxUsageCount;
                    $continuation.I$1 = timeout;
                    $continuation.I$2 = timedOut;
                    $continuation.I$3 = $i$f$mapNotNull;
                    $continuation.I$4 = $i$f$mapNotNullTo;
                    $continuation.I$5 = $i$f$forEach;
                    $continuation.I$6 = $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv;
                    $continuation.I$7 = $i$a$-mapNotNull-TextToolset$search_in_files$entries$1;
                    $continuation.label = 2;
                    v3 = CoroutinesKt.readAction((Function0)(Function0)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, search_in_files$lambda$5$lambda$4(com.intellij.openapi.vfs.VirtualFile ), ()Lcom/intellij/openapi/editor/Document;)((VirtualFile)file), (Continuation)$continuation);
                    if (v3 == var42_11) {
                        return var42_11;
                    }
                    ** GOTO lbl151
                }
                break;
            }
            case 2: {
                $i$a$-mapNotNull-TextToolset$search_in_files$entries$1 = $continuation.I$7;
                $i$a$-forEach-CollectionsKt___CollectionsKt$mapNotNullTo$1$iv$iv = $continuation.I$6;
                $i$f$forEach = $continuation.I$5;
                $i$f$mapNotNullTo = $continuation.I$4;
                $i$f$mapNotNull = $continuation.I$3;
                timedOut = $continuation.I$2;
                timeout = $continuation.I$1;
                maxUsageCount = $continuation.I$0;
                caseSensitive = $continuation.Z$1;
                isRegex = $continuation.Z$0;
                file = (VirtualFile)$continuation.L$15;
                usage = (UsageInfo)$continuation.L$14;
                element$iv$iv = $continuation.L$13;
                element$iv$iv$iv = $continuation.L$12;
                var22_28 = (Iterator<T>)$continuation.L$11;
                $this$forEach$iv$iv$iv = (Iterable)$continuation.L$10;
                destination$iv$iv = (Collection)$continuation.L$9;
                $this$mapNotNullTo$iv$iv = (Iterable)$continuation.L$8;
                $this$mapNotNull$iv = (Iterable)$continuation.L$7;
                usages = (CopyOnWriteArrayList)$continuation.L$6;
                findModel = (FindModel)$continuation.L$5;
                projectDir = (Path)$continuation.L$4;
                project = (Project)$continuation.L$3;
                fileMask = (String)$continuation.L$2;
                directoryToSearch = (String)$continuation.L$1;
                searchTextOrRegex = (String)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v3 = $result;
lbl151:
                // 2 sources

                if ((Document)v3 == null) {
                    v2 = null;
                } else if (usage.getNavigationRange() == null) {
                    v2 = null;
                } else {
                    startLineNumber = document.getLineNumber(textRange.getStartOffset());
                    startLineStartOffset = document.getLineStartOffset(startLineNumber);
                    endLineNumber = document.getLineNumber(textRange.getEndOffset());
                    endLineEndOffset = document.getLineEndOffset(endLineNumber);
                    Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(startLineStartOffset, textRange.getStartOffset())), (String)"getText(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(textRange.getStartOffset(), textRange.getEndOffset())), (String)"getText(...)");
                    Intrinsics.checkNotNullExpressionValue((Object)document.getText(new TextRange(textRange.getEndOffset(), endLineEndOffset)), (String)"getText(...)");
                    v2 = new UsageInfoEntry(Fs_utilKt.relativizeIfPossible(projectDir, file), startLineNumber + 1, textBeforeOccurrence + "||" + textInner + "||" + textAfterOccurrence);
                }
lbl165:
                // 4 sources

                if (v2 == null) ** GOTO lbl82
                it$iv$iv = v2;
                $i$a$-let-CollectionsKt___CollectionsKt$mapNotNullTo$1$1$iv$iv = false;
                destination$iv$iv.add(it$iv$iv);
                ** GOTO lbl82
            }
        }
        entries = (List)destination$iv$iv;
        return new UsageInfoResult(entries, usages.size() >= maxUsageCount, timedOut != 0);
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    static /* synthetic */ Object search_in_files$default(TextToolset textToolset, String string, boolean bl, String string2, String string3, boolean bl2, int n, int n2, Continuation continuation, int n3, Object object) {
        if ((n3 & 4) != 0) {
            string2 = null;
        }
        if ((n3 & 8) != 0) {
            string3 = null;
        }
        if ((n3 & 0x10) != 0) {
            bl2 = true;
        }
        if ((n3 & 0x20) != 0) {
            n = 1000;
        }
        if ((n3 & 0x40) != 0) {
            n2 = 10000;
        }
        return textToolset.search_in_files(string, bl, string2, string3, bl2, n, n2, (Continuation<? super UsageInfoResult>)continuation);
    }

    private static final String get_file_text_by_path$lambda$0(Path $resolvedPath) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile($resolvedPath);
        if (virtualFile == null) {
            McpToolKt.mcpFail("File " + $resolvedPath + " doesn't exist or can't be opened");
            throw new KotlinNothingValueException();
        }
        VirtualFile file = virtualFile;
        if (file.getFileType().isBinary()) {
            McpToolKt.mcpFail("File " + $resolvedPath + " is binary");
            throw new KotlinNothingValueException();
        }
        return VirtualFileUtil.readText((VirtualFile)file);
    }

    private static final Pair replace_text_in_file$lambda$1(Path $resolvedPath, String $pathInProject) {
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByNioFile($resolvedPath);
        if (virtualFile == null) {
            McpToolKt.mcpFail("file not found: " + $pathInProject);
            throw new KotlinNothingValueException();
        }
        VirtualFile file = virtualFile;
        Document document = FileDocumentManager.getInstance().getDocument(file);
        if (document == null) {
            McpToolKt.mcpFail("Could not get document for " + file);
            throw new KotlinNothingValueException();
        }
        Document document2 = document;
        return TuplesKt.to((Object)document2, (Object)document2.getText());
    }

    private static final Unit replace_text_in_file$lambda$2(List $rangeMarkers, Document $document, String $newText) {
        for (RangeMarker marker : CollectionsKt.reversed((Iterable)$rangeMarkers)) {
            TextRange textRange;
            if (!marker.isValid()) continue;
            Intrinsics.checkNotNullExpressionValue((Object)marker.getTextRange(), (String)"getTextRange(...)");
            $document.replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)$newText);
            marker.dispose();
        }
        FileDocumentManager.getInstance().saveDocument($document);
        return Unit.INSTANCE;
    }

    private static final Document search_in_files$lambda$5$lambda$4(VirtualFile $file) {
        return FileDocumentManager.getInstance().getDocument($file);
    }

    public static final /* synthetic */ Object access$search_in_files(TextToolset $this, String searchTextOrRegex, boolean isRegex, String directoryToSearch, String fileMask, boolean caseSensitive, int maxUsageCount, int timeout, Continuation $completion) {
        return $this.search_in_files(searchTextOrRegex, isRegex, directoryToSearch, fileMask, caseSensitive, maxUsageCount, timeout, (Continuation<? super UsageInfoResult>)$completion);
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 $2\u00020\u0001:\u0002#$B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0007\u0010\bB7\b\u0010\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\u0007\u0010\fJ\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0015\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0019\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001J%\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u00002\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!H\u0001\u00a2\u0006\u0002\b\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoEntry;", "", "filePath", "", "lineNumber", "", "lineText", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "seen0", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/lang/String;ILjava/lang/String;Lkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getFilePath", "()Ljava/lang/String;", "getLineNumber", "()I", "getLineText", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "toString", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_mcpserver", "$serializer", "Companion", "intellij.mcpserver"})
    public static final class UsageInfoEntry {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final String filePath;
        private final int lineNumber;
        @NotNull
        private final String lineText;

        public UsageInfoEntry(@NotNull String filePath, int lineNumber, @NotNull String lineText) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
            this.filePath = filePath;
            this.lineNumber = lineNumber;
            this.lineText = lineText;
        }

        @NotNull
        public final String getFilePath() {
            return this.filePath;
        }

        public final int getLineNumber() {
            return this.lineNumber;
        }

        @NotNull
        public final String getLineText() {
            return this.lineText;
        }

        @NotNull
        public final String component1() {
            return this.filePath;
        }

        public final int component2() {
            return this.lineNumber;
        }

        @NotNull
        public final String component3() {
            return this.lineText;
        }

        @NotNull
        public final UsageInfoEntry copy(@NotNull String filePath, int lineNumber, @NotNull String lineText) {
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Intrinsics.checkNotNullParameter((Object)lineText, (String)"lineText");
            return new UsageInfoEntry(filePath, lineNumber, lineText);
        }

        public static /* synthetic */ UsageInfoEntry copy$default(UsageInfoEntry usageInfoEntry, String string, int n, String string2, int n2, Object object) {
            if ((n2 & 1) != 0) {
                string = usageInfoEntry.filePath;
            }
            if ((n2 & 2) != 0) {
                n = usageInfoEntry.lineNumber;
            }
            if ((n2 & 4) != 0) {
                string2 = usageInfoEntry.lineText;
            }
            return usageInfoEntry.copy(string, n, string2);
        }

        @NotNull
        public String toString() {
            return "UsageInfoEntry(filePath=" + this.filePath + ", lineNumber=" + this.lineNumber + ", lineText=" + this.lineText + ")";
        }

        public int hashCode() {
            int result2 = this.filePath.hashCode();
            result2 = result2 * 31 + Integer.hashCode(this.lineNumber);
            result2 = result2 * 31 + this.lineText.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UsageInfoEntry)) {
                return false;
            }
            UsageInfoEntry usageInfoEntry = (UsageInfoEntry)other;
            if (!Intrinsics.areEqual((Object)this.filePath, (Object)usageInfoEntry.filePath)) {
                return false;
            }
            if (this.lineNumber != usageInfoEntry.lineNumber) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.lineText, (Object)usageInfoEntry.lineText);
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_mcpserver(UsageInfoEntry self, CompositeEncoder output, SerialDescriptor serialDesc) {
            output.encodeStringElement(serialDesc, 0, self.filePath);
            output.encodeIntElement(serialDesc, 1, self.lineNumber);
            output.encodeStringElement(serialDesc, 2, self.lineText);
        }

        public /* synthetic */ UsageInfoEntry(int seen0, String filePath, int lineNumber, String lineText, SerializationConstructorMarker serializationConstructorMarker) {
            if (7 != (7 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)7, (SerialDescriptor)UsageInfoEntry$$serializer.INSTANCE.getDescriptor());
            }
            this.filePath = filePath;
            this.lineNumber = lineNumber;
            this.lineText = lineText;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoEntry$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoEntry;", "intellij.mcpserver"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<UsageInfoEntry> serializer() {
                return (KSerializer)UsageInfoEntry$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable
    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0087\b\u0018\u0000 )2\u00020\u0001:\u0002()B)\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tB;\b\u0010\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u000e\u0010\u0002\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0004\b\b\u0010\u000eJ\u000f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0019\u001a\u00020\u0006H\u00c6\u0003J-\u0010\u001a\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001b\u001a\u00020\u00062\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u000bH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\u001fH\u00d6\u0001J%\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00002\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0001\u00a2\u0006\u0002\b'R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001c\u0010\u0005\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0011\u0010\u0012\u001a\u0004\b\u0013\u0010\u0014R\u001c\u0010\u0007\u001a\u00020\u00068\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0015\u0010\u0012\u001a\u0004\b\u0016\u0010\u0014\u00a8\u0006*"}, d2={"Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoResult;", "", "entries", "", "Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoEntry;", "probablyHasMoreMatchingEntries", "", "timedOut", "<init>", "(Ljava/util/List;ZZ)V", "seen0", "", "serializationConstructorMarker", "Lkotlinx/serialization/internal/SerializationConstructorMarker;", "(ILjava/util/List;ZZLkotlinx/serialization/internal/SerializationConstructorMarker;)V", "getEntries", "()Ljava/util/List;", "getProbablyHasMoreMatchingEntries$annotations", "()V", "getProbablyHasMoreMatchingEntries", "()Z", "getTimedOut$annotations", "getTimedOut", "component1", "component2", "component3", "copy", "equals", "other", "hashCode", "toString", "", "write$Self", "", "self", "output", "Lkotlinx/serialization/encoding/CompositeEncoder;", "serialDesc", "Lkotlinx/serialization/descriptors/SerialDescriptor;", "write$Self$intellij_mcpserver", "$serializer", "Companion", "intellij.mcpserver"})
    public static final class UsageInfoResult {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final List<UsageInfoEntry> entries;
        private final boolean probablyHasMoreMatchingEntries;
        private final boolean timedOut;
        @JvmField
        @NotNull
        private static final Lazy<KSerializer<Object>>[] $childSerializers;

        public UsageInfoResult(@NotNull List<UsageInfoEntry> entries, boolean probablyHasMoreMatchingEntries, boolean timedOut2) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            this.entries = entries;
            this.probablyHasMoreMatchingEntries = probablyHasMoreMatchingEntries;
            this.timedOut = timedOut2;
        }

        public /* synthetic */ UsageInfoResult(List list, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 2) != 0) {
                bl = false;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(list, bl, bl2);
        }

        @NotNull
        public final List<UsageInfoEntry> getEntries() {
            return this.entries;
        }

        public final boolean getProbablyHasMoreMatchingEntries() {
            return this.probablyHasMoreMatchingEntries;
        }

        @EncodeDefault(mode=EncodeDefault.Mode.NEVER)
        public static /* synthetic */ void getProbablyHasMoreMatchingEntries$annotations() {
        }

        public final boolean getTimedOut() {
            return this.timedOut;
        }

        @EncodeDefault(mode=EncodeDefault.Mode.NEVER)
        public static /* synthetic */ void getTimedOut$annotations() {
        }

        @NotNull
        public final List<UsageInfoEntry> component1() {
            return this.entries;
        }

        public final boolean component2() {
            return this.probablyHasMoreMatchingEntries;
        }

        public final boolean component3() {
            return this.timedOut;
        }

        @NotNull
        public final UsageInfoResult copy(@NotNull List<UsageInfoEntry> entries, boolean probablyHasMoreMatchingEntries, boolean timedOut2) {
            Intrinsics.checkNotNullParameter(entries, (String)"entries");
            return new UsageInfoResult(entries, probablyHasMoreMatchingEntries, timedOut2);
        }

        public static /* synthetic */ UsageInfoResult copy$default(UsageInfoResult usageInfoResult, List list, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 1) != 0) {
                list = usageInfoResult.entries;
            }
            if ((n & 2) != 0) {
                bl = usageInfoResult.probablyHasMoreMatchingEntries;
            }
            if ((n & 4) != 0) {
                bl2 = usageInfoResult.timedOut;
            }
            return usageInfoResult.copy(list, bl, bl2);
        }

        @NotNull
        public String toString() {
            return "UsageInfoResult(entries=" + this.entries + ", probablyHasMoreMatchingEntries=" + this.probablyHasMoreMatchingEntries + ", timedOut=" + this.timedOut + ")";
        }

        public int hashCode() {
            int result2 = ((Object)this.entries).hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.probablyHasMoreMatchingEntries);
            result2 = result2 * 31 + Boolean.hashCode(this.timedOut);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof UsageInfoResult)) {
                return false;
            }
            UsageInfoResult usageInfoResult = (UsageInfoResult)other;
            if (!Intrinsics.areEqual(this.entries, usageInfoResult.entries)) {
                return false;
            }
            if (this.probablyHasMoreMatchingEntries != usageInfoResult.probablyHasMoreMatchingEntries) {
                return false;
            }
            return this.timedOut == usageInfoResult.timedOut;
        }

        @JvmStatic
        public static final /* synthetic */ void write$Self$intellij_mcpserver(UsageInfoResult self, CompositeEncoder output, SerialDescriptor serialDesc) {
            Lazy<KSerializer<Object>>[] lazyArray = $childSerializers;
            output.encodeSerializableElement(serialDesc, 0, (SerializationStrategy)lazyArray[0].getValue(), self.entries);
            if (self.probablyHasMoreMatchingEntries) {
                output.encodeBooleanElement(serialDesc, 1, self.probablyHasMoreMatchingEntries);
            }
            if (self.timedOut) {
                output.encodeBooleanElement(serialDesc, 2, self.timedOut);
            }
        }

        public /* synthetic */ UsageInfoResult(int seen0, List entries, boolean probablyHasMoreMatchingEntries, boolean timedOut2, SerializationConstructorMarker serializationConstructorMarker) {
            if (1 != (1 & seen0)) {
                PluginExceptionsKt.throwMissingFieldException((int)seen0, (int)1, (SerialDescriptor)UsageInfoResult$$serializer.INSTANCE.getDescriptor());
            }
            this.entries = entries;
            this.probablyHasMoreMatchingEntries = (seen0 & 2) == 0 ? false : probablyHasMoreMatchingEntries;
            this.timedOut = (seen0 & 4) == 0 ? false : timedOut2;
        }

        public static final /* synthetic */ Lazy[] access$get$childSerializers$cp() {
            return $childSerializers;
        }

        static {
            Lazy[] lazyArray = new Lazy[]{LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.PUBLICATION, () -> (KSerializer)new ArrayListSerializer((KSerializer)UsageInfoEntry$$serializer.INSTANCE)), null, null};
            $childSerializers = lazyArray;
        }

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoResult$Companion;", "", "<init>", "()V", "serializer", "Lkotlinx/serialization/KSerializer;", "Lcom/intellij/mcpserver/toolsets/general/TextToolset$UsageInfoResult;", "intellij.mcpserver"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<UsageInfoResult> serializer() {
                return (KSerializer)UsageInfoResult$$serializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

