/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model.catboostOld;

import com.jetbrains.ml.tools.model.catboostOld.BinaryFeature;
import com.jetbrains.ml.tools.model.catboostOld.CategoricalFeature;
import com.jetbrains.ml.tools.model.catboostOld.Feature;
import com.jetbrains.ml.tools.model.catboostOld.FeatureMapper;
import com.jetbrains.ml.tools.model.catboostOld.FloatFeature;
import com.jetbrains.ml.tools.model.catboostOld.InconsistentMetadataException;
import com.jetbrains.ml.tools.model.catboostOld.ModelReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MagicApiIntrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KType;
import kotlin.reflect.KTypeProjection;
import kotlin.text.StringsKt;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonPrimitive;
import kotlinx.serialization.modules.SerializersModule;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u000e\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aBU\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u0012\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u0012\b\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u000fR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0011R\u0019\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\n\n\u0002\u0010\u0015\u001a\u0004\b\u0013\u0010\u0014R\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0011R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0011R\u0013\u0010\u000e\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\u001b"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/ModelMetadata;", "", "knownFeatures", "", "", "binaryFeatures", "Lcom/jetbrains/ml/tools/model/catboostOld/BinaryFeature;", "floatFeatures", "Lcom/jetbrains/ml/tools/model/catboostOld/FloatFeature;", "categoricalFeatures", "Lcom/jetbrains/ml/tools/model/catboostOld/CategoricalFeature;", "featuresOrder", "", "Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "version", "(Ljava/util/List;Ljava/util/List;Ljava/util/List;Ljava/util/List;[Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;Ljava/lang/String;)V", "getBinaryFeatures", "()Ljava/util/List;", "getCategoricalFeatures", "getFeaturesOrder", "()[Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "[Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "getFloatFeatures", "getKnownFeatures", "getVersion", "()Ljava/lang/String;", "Companion", "ml-tools"})
public final class ModelMetadata {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<String> knownFeatures;
    @NotNull
    private final List<BinaryFeature> binaryFeatures;
    @NotNull
    private final List<FloatFeature> floatFeatures;
    @NotNull
    private final List<CategoricalFeature> categoricalFeatures;
    @NotNull
    private final FeatureMapper[] featuresOrder;
    @Nullable
    private final String version;
    @NotNull
    private static final String DEFAULT = "default";
    @NotNull
    private static final String USE_UNDEFINED = "use_undefined";

    public ModelMetadata(@NotNull List<String> knownFeatures, @NotNull List<BinaryFeature> binaryFeatures, @NotNull List<FloatFeature> floatFeatures, @NotNull List<CategoricalFeature> categoricalFeatures, @NotNull FeatureMapper[] featuresOrder, @Nullable String version) {
        Intrinsics.checkNotNullParameter(knownFeatures, (String)"knownFeatures");
        Intrinsics.checkNotNullParameter(binaryFeatures, (String)"binaryFeatures");
        Intrinsics.checkNotNullParameter(floatFeatures, (String)"floatFeatures");
        Intrinsics.checkNotNullParameter(categoricalFeatures, (String)"categoricalFeatures");
        Intrinsics.checkNotNullParameter((Object)featuresOrder, (String)"featuresOrder");
        this.knownFeatures = knownFeatures;
        this.binaryFeatures = binaryFeatures;
        this.floatFeatures = floatFeatures;
        this.categoricalFeatures = categoricalFeatures;
        this.featuresOrder = featuresOrder;
        this.version = version;
    }

    @NotNull
    public final List<String> getKnownFeatures() {
        return this.knownFeatures;
    }

    @NotNull
    public final List<BinaryFeature> getBinaryFeatures() {
        return this.binaryFeatures;
    }

    @NotNull
    public final List<FloatFeature> getFloatFeatures() {
        return this.floatFeatures;
    }

    @NotNull
    public final List<CategoricalFeature> getCategoricalFeatures() {
        return this.categoricalFeatures;
    }

    @NotNull
    public final FeatureMapper[] getFeaturesOrder() {
        return this.featuresOrder;
    }

    @Nullable
    public final String getVersion() {
        return this.version;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00010\tH\u0002J\"\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\tJ7\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\t2\u001e\u0010\u0010\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u0011\"\b\u0012\u0004\u0012\u00020\u000f0\u0012\u00a2\u0006\u0002\u0010\u0013J3\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00112\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000f0\t2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012\u00a2\u0006\u0002\u0010\u0018J\u001c\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u00042\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0012JH\u0010\u001c\u001a.\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001f\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001f0\u001d2\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\tH\u0002J$\u0010 \u001a\u00020\u001e2\u0006\u0010\f\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\tH\u0002J\"\u0010!\u001a\u00020\"2\u0006\u0010\f\u001a\u00020\u00042\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\r0\tJ\u000e\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/jetbrains/ml/tools/model/catboostOld/ModelMetadata$Companion;", "", "()V", "DEFAULT", "", "USE_UNDEFINED", "allowUndefined", "", "description", "", "binary", "Lcom/jetbrains/ml/tools/model/catboostOld/BinaryFeature;", "name", "Lkotlinx/serialization/json/JsonElement;", "buildFeaturesIndex", "Lcom/jetbrains/ml/tools/model/catboostOld/Feature;", "featureGroups", "", "", "([Ljava/util/List;)Ljava/util/Map;", "buildMappers", "Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "features", "order", "(Ljava/util/Map;Ljava/util/List;)[Lcom/jetbrains/ml/tools/model/catboostOld/FeatureMapper;", "categorical", "Lcom/jetbrains/ml/tools/model/catboostOld/CategoricalFeature;", "categories", "extractBinaryValuesMappings", "Lkotlin/Pair;", "", "Lcom/jetbrains/ml/tools/model/catboostOld/ValueMapping;", "extractDefaultValue", "float", "Lcom/jetbrains/ml/tools/model/catboostOld/FloatFeature;", "read", "Lcom/jetbrains/ml/tools/model/catboostOld/ModelMetadata;", "reader", "Lcom/jetbrains/ml/tools/model/catboostOld/ModelReader;", "ml-tools"})
    @SourceDebugExtension(value={"SMAP\nModelMetadata.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModelMetadata.kt\ncom/jetbrains/ml/tools/model/catboostOld/ModelMetadata$Companion\n+ 2 Json.kt\nkotlinx/serialization/json/Json\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 6 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,130:1\n147#2:131\n147#2:132\n147#2:137\n147#2:142\n125#3:133\n152#3,3:134\n125#3:138\n152#3,3:139\n125#3:143\n152#3,3:144\n1#4:147\n1002#5,2:148\n37#6,2:150\n*S KotlinDebug\n*F\n+ 1 ModelMetadata.kt\ncom/jetbrains/ml/tools/model/catboostOld/ModelMetadata$Companion\n*L\n24#1:131\n27#1:132\n29#1:137\n31#1:142\n28#1:133\n28#1:134,3\n30#1:138\n30#1:139,3\n32#1:143\n32#1:144,3\n111#1:148,2\n126#1:150,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final ModelMetadata read(@NotNull ModelReader reader) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map this_$iv;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Map this_$iv2;
            Collection collection;
            Object object;
            Object item$iv$iv;
            void $this$mapTo$iv$iv3;
            void $this$map$iv3;
            Map this_$iv3;
            void this_$iv4;
            Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
            Json json = (Json)Json.Default;
            String string$iv = reader.readKnownFeatures();
            boolean $i$f$decodeFromString = false;
            SerializersModule serializersModule = this_$iv4.getSerializersModule();
            KType kType = Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)));
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            List knownFeatures = (List)this_$iv4.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule, (KType)kType), string$iv);
            string$iv = (Json)Json.Default;
            String string$iv2 = reader.readBinaryFeatures();
            boolean $i$f$decodeFromString22 = false;
            SerializersModule serializersModule2 = this_$iv3.getSerializersModule();
            KType kType2 = Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(JsonElement.class)))));
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            this_$iv3 = (Map)this_$iv3.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)serializersModule2, (KType)kType2), string$iv2);
            boolean $i$f$map22 = false;
            void $i$f$decodeFromString22 = $this$map$iv3;
            Collection destination$iv$iv = new ArrayList($this$map$iv3.size());
            boolean $i$f$mapTo22 = false;
            Iterator iterator = $this$mapTo$iv$iv3.entrySet().iterator();
            while (iterator.hasNext()) {
                void it;
                object = item$iv$iv = iterator.next();
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Companion.binary((String)it.getKey(), (Map)it.getValue()));
            }
            List binaryFactors = (List)destination$iv$iv;
            Json $i$f$map22 = (Json)Json.Default;
            String string$iv3 = reader.readFloatFeatures();
            boolean $i$f$decodeFromString32 = false;
            SerializersModule $i$f$mapTo22 = this_$iv2.getSerializersModule();
            KType kType3 = Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(JsonElement.class)))));
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            this_$iv2 = (Map)this_$iv2.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)$i$f$mapTo22, (KType)kType3), string$iv3);
            boolean $i$f$map32 = false;
            void $i$f$decodeFromString32 = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList($this$map$iv2.size());
            boolean $i$f$mapTo32 = false;
            item$iv$iv = $this$mapTo$iv$iv2.entrySet().iterator();
            while (item$iv$iv.hasNext()) {
                void it;
                Map.Entry item$iv$iv2;
                Map.Entry bl = item$iv$iv2 = (Map.Entry)item$iv$iv.next();
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(Companion.float((String)it.getKey(), (Map)it.getValue()));
            }
            List floatFactors = (List)destination$iv$iv2;
            Json $i$f$map32 = (Json)Json.Default;
            String string$iv4 = reader.readCategoricalFeatures();
            boolean $i$f$decodeFromString42 = false;
            SerializersModule $i$f$mapTo32 = this_$iv.getSerializersModule();
            KType kType4 = Reflection.typeOf(Map.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)), (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(List.class, (KTypeProjection)KTypeProjection.Companion.invariant(Reflection.typeOf(String.class)))));
            MagicApiIntrinsics.voidMagicApiCall((Object)"kotlinx.serialization.serializer.withModule");
            this_$iv = (Map)this_$iv.decodeFromString((DeserializationStrategy)SerializersKt.serializer((SerializersModule)$i$f$mapTo32, (KType)kType4), string$iv4);
            boolean $i$f$map = false;
            void $i$f$decodeFromString42 = $this$map$iv;
            Collection destination$iv$iv3 = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            object = $this$mapTo$iv$iv.entrySet().iterator();
            while (object.hasNext()) {
                void it;
                Map.Entry item$iv$iv3;
                Map.Entry bl2 = item$iv$iv3 = (Map.Entry)object.next();
                collection = destination$iv$iv3;
                boolean bl = false;
                collection.add(Companion.categorical((String)it.getKey(), (List)it.getValue()));
            }
            List categoricalFactors = (List)destination$iv$iv3;
            List<String> order = reader.readFeatureOrder();
            List[] listArray = new List[]{binaryFactors, floatFactors, categoricalFactors};
            Map<String, Feature> featuresIndex = this.buildFeaturesIndex(listArray);
            return new ModelMetadata(knownFeatures, binaryFactors, floatFactors, categoricalFactors, this.buildMappers(featuresIndex, order), reader.readVersion());
        }

        @NotNull
        public final BinaryFeature binary(@NotNull String name, @NotNull Map<String, ? extends JsonElement> description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            Pair<Pair<String, Double>, Pair<String, Double>> pair = this.extractBinaryValuesMappings(description);
            Pair first = (Pair)pair.component1();
            Pair second = (Pair)pair.component2();
            double d = this.extractDefaultValue(name, description);
            return new BinaryFeature(name, (Pair<String, Double>)first, (Pair<String, Double>)second, d, this.allowUndefined(description));
        }

        @NotNull
        public final FloatFeature float(@NotNull String name, @NotNull Map<String, ? extends JsonElement> description) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(description, (String)"description");
            double d = this.extractDefaultValue(name, description);
            return new FloatFeature(name, d, this.allowUndefined(description));
        }

        @NotNull
        public final CategoricalFeature categorical(@NotNull String name, @NotNull List<String> categories) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(categories, (String)"categories");
            return new CategoricalFeature(name, CollectionsKt.toSet((Iterable)categories));
        }

        @NotNull
        public final Map<String, Feature> buildFeaturesIndex(List<? extends Feature> ... featureGroups) {
            Intrinsics.checkNotNullParameter(featureGroups, (String)"featureGroups");
            Map index = new LinkedHashMap();
            for (List<? extends Feature> features : featureGroups) {
                com.jetbrains.ml.tools.model.catboostOld.ModelMetadata$Companion.buildFeaturesIndex$addFeatures(index, features);
            }
            return index;
        }

        private final boolean allowUndefined(Map<String, ? extends Object> description) {
            Object value = description.get(ModelMetadata.USE_UNDEFINED);
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            return true;
        }

        private final double extractDefaultValue(String name, Map<String, ? extends JsonElement> description) {
            JsonElement jsonElement = description.get(ModelMetadata.DEFAULT);
            if (jsonElement == null) {
                throw new InconsistentMetadataException("Default value not found. Feature name: " + name);
            }
            JsonElement value = jsonElement;
            try {
                return JsonElementKt.getDouble((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new InconsistentMetadataException("Default value must be double(name=" + name + ", value=" + value);
            }
        }

        private final Pair<Pair<String, Double>, Pair<String, Double>> extractBinaryValuesMappings(Map<String, ? extends JsonElement> description) {
            boolean bl;
            List result = new ArrayList();
            for (Map.Entry<String, ? extends JsonElement> entry : description.entrySet()) {
                double d;
                String name = entry.getKey();
                JsonElement value = entry.getValue();
                if (Intrinsics.areEqual((Object)name, (Object)ModelMetadata.DEFAULT) || Intrinsics.areEqual((Object)name, (Object)ModelMetadata.USE_UNDEFINED)) continue;
                try {
                    d = JsonElementKt.getDouble((JsonPrimitive)JsonElementKt.getJsonPrimitive((JsonElement)value));
                }
                catch (IllegalArgumentException e) {
                    throw new InconsistentMetadataException("Mapped value for binary feature should be double (value=" + value + ")");
                }
                double mappedValue = d;
                result.add(TuplesKt.to((Object)name, (Object)mappedValue));
            }
            boolean bl2 = bl = result.size() == 2;
            if (_Assertions.ENABLED && !bl) {
                boolean $i$a$-assert-ModelMetadata$Companion$extractBinaryValuesMappings$22 = false;
                String $i$a$-assert-ModelMetadata$Companion$extractBinaryValuesMappings$22 = "Binary feature must contains 2 values, but found " + result;
                throw new AssertionError((Object)$i$a$-assert-ModelMetadata$Companion$extractBinaryValuesMappings$22);
            }
            List $this$sortBy$iv = result;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Pair it = (Pair)a;
                        boolean bl = false;
                        Comparable comparable = (Comparable)((Object)((String)it.getFirst()));
                        it = (Pair)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)((String)it.getFirst()))));
                    }
                });
            }
            return new Pair(result.get(0), result.get(1));
        }

        @NotNull
        public final FeatureMapper[] buildMappers(@NotNull Map<String, ? extends Feature> features, @NotNull List<String> order) {
            Intrinsics.checkNotNullParameter(features, (String)"features");
            Intrinsics.checkNotNullParameter(order, (String)"order");
            List mappers = new ArrayList();
            for (String arrayFeatureName : order) {
                String string;
                String name = StringsKt.substringBefore$default((String)arrayFeatureName, (char)'=', null, (int)2, null);
                int it = StringsKt.indexOf$default((CharSequence)arrayFeatureName, (char)'=', (int)0, (boolean)false, (int)6, null);
                boolean bl = false;
                if (it == -1) {
                    string = null;
                } else {
                    String string2 = arrayFeatureName.substring(it + 1);
                    string = string2;
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
                }
                String suffix = string;
                Object object = features.get(name);
                if (object == null || (object = ((Feature)object).createMapper(suffix)) == null) {
                    throw new InconsistentMetadataException("Unexpected feature name in array: " + arrayFeatureName);
                }
                Object mapper = object;
                mappers.add(mapper);
            }
            Collection $this$toTypedArray$iv = mappers;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            return thisCollection$iv.toArray(new FeatureMapper[0]);
        }

        private static final <T extends Feature> Map<String, Feature> buildFeaturesIndex$addFeatures(Map<String, Feature> $this$buildFeaturesIndex_u24addFeatures, List<? extends T> features) {
            for (Feature feature : features) {
                if ($this$buildFeaturesIndex_u24addFeatures.keySet().contains(feature.getName())) {
                    throw new InconsistentMetadataException("Ambiguous feature description '" + feature.getName() + "': " + feature + " and " + $this$buildFeaturesIndex_u24addFeatures.get(feature.getName()));
                }
                $this$buildFeaturesIndex_u24addFeatures.put(feature.getName(), feature);
            }
            return $this$buildFeaturesIndex_u24addFeatures;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

