/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.ml.tools.model;

import com.jetbrains.ml.api.feature.Feature;
import com.jetbrains.ml.api.feature.FeatureFilter;
import com.jetbrains.ml.api.model.MLModel;
import com.jetbrains.ml.tools.model.ColumnsCompiler;
import com.jetbrains.ml.tools.model.DatasetColumns;
import com.jetbrains.ml.tools.model.Regressor;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u0000\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J/\u0010\f\u001a\u00020\u00022\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016\u00a2\u0006\u0002\u0010\u0014JD\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\u0012\u0010\u0017\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000e2\u0012\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/ml/tools/model/RegressionModel;", "Lcom/jetbrains/ml/api/model/MLModel;", "", "columnsCompiler", "Lcom/jetbrains/ml/tools/model/ColumnsCompiler;", "decisionFunction", "Lcom/jetbrains/ml/tools/model/Regressor;", "(Lcom/jetbrains/ml/tools/model/ColumnsCompiler;Lcom/jetbrains/ml/tools/model/Regressor;)V", "knownFeatures", "Lcom/jetbrains/ml/api/feature/FeatureFilter;", "getKnownFeatures", "()Lcom/jetbrains/ml/api/feature/FeatureFilter;", "predict", "features", "", "Lcom/jetbrains/ml/api/feature/Feature;", "parameters", "", "", "", "(Ljava/util/List;Ljava/util/Map;)Ljava/lang/Double;", "predictBatch", "contextFeatures", "itemFeatures", "ml-tools"})
public final class RegressionModel
implements MLModel<Double> {
    @NotNull
    private final ColumnsCompiler columnsCompiler;
    @NotNull
    private final Regressor decisionFunction;
    @NotNull
    private final FeatureFilter knownFeatures;

    public RegressionModel(@NotNull ColumnsCompiler columnsCompiler, @NotNull Regressor decisionFunction) {
        Intrinsics.checkNotNullParameter((Object)columnsCompiler, (String)"columnsCompiler");
        Intrinsics.checkNotNullParameter((Object)decisionFunction, (String)"decisionFunction");
        this.columnsCompiler = columnsCompiler;
        this.decisionFunction = decisionFunction;
        this.knownFeatures = FeatureFilter.Companion.ofNames(this.columnsCompiler.getKnownFeatures());
    }

    @NotNull
    public FeatureFilter getKnownFeatures() {
        return this.knownFeatures;
    }

    @NotNull
    public Double predict(@NotNull List<? extends Feature> features, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter(features, (String)"features");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        DatasetColumns row = this.columnsCompiler.compileRow(features);
        return (Double)this.decisionFunction.predict(row, parameters);
    }

    @NotNull
    public List<Double> predictBatch(@NotNull List<? extends Feature> contextFeatures, @NotNull List<? extends List<? extends Feature>> itemFeatures, @NotNull Map<String, ? extends Object> parameters) {
        Intrinsics.checkNotNullParameter(contextFeatures, (String)"contextFeatures");
        Intrinsics.checkNotNullParameter(itemFeatures, (String)"itemFeatures");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        List<DatasetColumns> rows = this.columnsCompiler.compileRows(contextFeatures, itemFeatures);
        return this.decisionFunction.predictBatch(rows, parameters);
    }

    @NotNull
    public <T> Map<T, Double> predictBatch(@NotNull List<? extends Feature> contextFeatures, @NotNull Map<T, ? extends List<? extends Feature>> itemFeatures, @NotNull Map<String, ? extends Object> parameters) {
        return MLModel.DefaultImpls.predictBatch((MLModel)this, contextFeatures, itemFeatures, parameters);
    }
}

