/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.recentFiles.frontend.model;

import com.intellij.ide.vfs.VirtualFileId;
import com.intellij.ide.vfs.VirtualFileIdKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.recentFiles.frontend.SwitcherVirtualFile;
import com.intellij.platform.recentFiles.frontend.model.FrontendRecentFilesMutableStateKt;
import com.intellij.platform.recentFiles.shared.RecentFileKind;
import com.intellij.platform.recentFiles.shared.RecentFilesMutableState;
import com.intellij.platform.recentFiles.shared.RecentFilesState;
import com.intellij.platform.recentFiles.shared.SwitcherRpcDto;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.MutableStateFlow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\tH\u0016J\u0018\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u000b\u001a\u00020\fH\u0096@\u00a2\u0006\u0002\u0010\rJ\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0010\u001a\u00020\u0002H\u0016J\u001a\u0010\u0013\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00020\u00150\u00142\u0006\u0010\u0016\u001a\u00020\u0017\u00a8\u0006\u0018"}, d2={"Lcom/intellij/platform/recentFiles/frontend/model/FrontendRecentFilesMutableState;", "Lcom/intellij/platform/recentFiles/shared/RecentFilesMutableState;", "Lcom/intellij/platform/recentFiles/frontend/SwitcherVirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "convertDtoToModel", "rpcDto", "Lcom/intellij/platform/recentFiles/shared/SwitcherRpcDto;", "convertVirtualFileIdToModel", "virtualFileId", "Lcom/intellij/ide/vfs/VirtualFileId;", "(Lcom/intellij/ide/vfs/VirtualFileId;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "convertModelToVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "model", "checkValidity", "", "chooseStateToReadFrom", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/intellij/platform/recentFiles/shared/RecentFilesState;", "filesKind", "Lcom/intellij/platform/recentFiles/shared/RecentFileKind;", "intellij.platform.recentFiles.frontend"})
public final class FrontendRecentFilesMutableState
extends RecentFilesMutableState<SwitcherVirtualFile> {
    public FrontendRecentFilesMutableState(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    public SwitcherVirtualFile convertDtoToModel(@NotNull SwitcherRpcDto rpcDto) {
        Intrinsics.checkNotNullParameter((Object)rpcDto, (String)"rpcDto");
        if (!(rpcDto instanceof SwitcherRpcDto.File)) {
            throw new NoWhenBranchMatchedException();
        }
        return new SwitcherVirtualFile((SwitcherRpcDto.File)rpcDto);
    }

    @Nullable
    public Object convertVirtualFileIdToModel(@NotNull VirtualFileId virtualFileId, @NotNull Continuation<? super SwitcherVirtualFile> $completion) {
        VirtualFile virtualFile = VirtualFileIdKt.virtualFile((VirtualFileId)virtualFileId);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile localFile = virtualFile;
        return FrontendRecentFilesMutableStateKt.convertVirtualFileToViewModel(localFile, this.getProject(), $completion);
    }

    @Nullable
    public VirtualFile convertModelToVirtualFile(@NotNull SwitcherVirtualFile model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        return model.getVirtualFile();
    }

    public boolean checkValidity(@NotNull SwitcherVirtualFile model) {
        Intrinsics.checkNotNullParameter((Object)model, (String)"model");
        VirtualFile virtualFile = model.getVirtualFile();
        return !(virtualFile != null ? !virtualFile.isValid() : false);
    }

    @NotNull
    public final MutableStateFlow<RecentFilesState<SwitcherVirtualFile>> chooseStateToReadFrom(@NotNull RecentFileKind filesKind) {
        Intrinsics.checkNotNullParameter((Object)filesKind, (String)"filesKind");
        return switch (WhenMappings.$EnumSwitchMapping$0[filesKind.ordinal()]) {
            case 1 -> this.getRecentlyEditedFilesState();
            case 2 -> this.getRecentlyOpenedFilesState();
            case 3 -> {
                if (((RecentFilesState)this.getRecentlyOpenedPinnedFilesState().getValue()).getEntries().size() > 1) {
                    yield this.getRecentlyOpenedPinnedFilesState();
                }
                yield this.getRecentlyOpenedFilesState();
            }
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[RecentFileKind.values().length];
            try {
                nArray[RecentFileKind.RECENTLY_EDITED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_OPENED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RecentFileKind.RECENTLY_OPENED_UNPINNED.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

