/**
 * Map of non-ASCII characters to Groff commands.
 *
 * @type {Record<string, string>}
 */
export const groffEscape = {
  '≠': '!=',
  À: '`A',
  Á: "'A",
  Â: '^A',
  Ã: '~A',
  Ä: ':A',
  Å: 'oA',
  Ć: "'C",
  Ç: ',C',
  È: '`E',
  É: "'E",
  Ê: '^E',
  Ë: ':E',
  Ì: '`I',
  Í: "'I",
  Î: '^I',
  Ï: ':I',
  Ñ: '~N',
  Ò: '`O',
  Ó: "'O",
  Ô: '^O',
  Õ: '~O',
  Ö: ':O',
  Š: 'vS',
  Ù: '`U',
  Ú: "'U",
  Û: '^U',
  Ü: ':U',
  Ý: "'Y",
  Ÿ: ':Y',
  Ž: 'vZ',
  à: '`a',
  á: "'a",
  â: '^a',
  ã: '~a',
  ä: ':a',
  å: 'oa',
  ć: "'c",
  ç: ',c',
  è: '`e',
  é: "'e",
  ê: '^e',
  ë: ':e',
  ì: '`i',
  í: "'i",
  î: '^i',
  ï: ':i',
  ñ: '~n',
  ò: '`o',
  ó: "'o",
  ô: '^o',
  õ: '~o',
  ö: ':o',
  š: 'vs',
  ù: '`u',
  ú: "'u",
  û: '^u',
  ü: ':u',
  ý: "'y",
  ÿ: ':y',
  ž: 'vz',
  '¡': 'r!',
  '¢': 'ct',
  '£': 'Po',
  '¤': 'Cs',
  '¥': 'Ye',
  '¦': 'bb',
  '§': 'sc',
  '¨': 'ad',
  '©': 'co',
  ª: 'Of',
  '«': 'Fo',
  '¬': 'no',
  '®': 'rg',
  '¯': 'a-',
  '°': 'de',
  '±': '+-',
  '²': 'S2',
  '³': 'S3',
  '´': 'aa',
  µ: 'mc',
  '¶': 'ps',
  '·': 'pc',
  '¸': 'ac',
  '¹': 'S1',
  º: 'Om',
  '»': 'Fc',
  '¼': '14',
  '½': '12',
  '¾': '34',
  '¿': 'r?',
  Æ: 'AE',
  Ð: '-D',
  '×': 'mu',
  Ø: '/O',
  Þ: 'TP',
  ß: 'ss',
  æ: 'ae',
  ð: 'Sd',
  '÷': 'di',
  ø: '/o',
  þ: 'Tp',
  ı: '.i',
  Ĳ: 'IJ',
  ĳ: 'ij',
  Ł: '/L',
  ł: '/l',
  Œ: 'OE',
  œ: 'oe',
  ƒ: 'Fn',
  ȷ: '.j',
  ˇ: 'ah',
  '˘': 'ab',
  '˙': 'a.',
  '˚': 'ao',
  '˛': 'ho',
  '˝': 'a"',
  Α: '*A',
  Β: '*B',
  Γ: '*G',
  Δ: '*D',
  Ε: '*E',
  Ζ: '*Z',
  Η: '*Y',
  Θ: '*H',
  Ι: '*I',
  Κ: '*K',
  Λ: '*L',
  Μ: '*M',
  Ν: '*N',
  Ξ: '*C',
  Ο: '*O',
  Π: '*P',
  Ρ: '*R',
  Σ: '*S',
  Τ: '*T',
  Υ: '*U',
  Φ: '*F',
  Χ: '*X',
  Ψ: '*Q',
  Ω: '*W',
  α: '*a',
  β: '*b',
  γ: '*g',
  δ: '*d',
  ε: '*e',
  ζ: '*z',
  η: '*y',
  θ: '*h',
  ι: '*i',
  κ: '*k',
  λ: '*l',
  μ: '*m',
  ν: '*n',
  ξ: '*c',
  ο: '*o',
  π: '*p',
  ρ: '*r',
  ς: 'ts',
  σ: '*s',
  τ: '*t',
  υ: '*u',
  φ: '+f',
  χ: '*x',
  ψ: '*q',
  ω: '*w',
  ϑ: '+h',
  ϕ: '*f',
  ϖ: '+p',
  ϵ: '+e',
  '‐': 'hy',
  '–': 'en',
  '—': 'em',
  '‘': 'oq',
  '’': 'cq',
  '‚': 'bq',
  '“': 'lq',
  '”': 'rq',
  '„': 'Bq',
  '†': 'dg',
  '‡': 'dd',
  '•': 'bu',
  '‰': '%0',
  '′': 'fm',
  '″': 'sd',
  '‹': 'fo',
  '›': 'fc',
  '‾': 'rn',
  '⁄': 'f/',
  '€': 'Eu',
  ℏ: '-h',
  ℑ: 'Im',
  '℘': 'wp',
  ℜ: 'Re',
  '™': 'tm',
  ℵ: 'Ah',
  '⅛': '18',
  '⅜': '38',
  '⅝': '58',
  '⅞': '78',
  '←': '<-',
  '↑': 'ua',
  '→': '->',
  '↓': 'da',
  '↔': '<>',
  '↕': 'va',
  '↵': 'CR',
  '⇐': 'lA',
  '⇑': 'uA',
  '⇒': 'rA',
  '⇓': 'dA',
  '⇔': 'hA',
  '⇕': 'vA',
  '∀': 'fa',
  '∂': 'pd',
  '∃': 'te',
  '∅': 'es',
  '∇': 'gr',
  '∈': 'mo',
  '∉': 'nm',
  '∋': 'st',
  '∏': 'product',
  '∐': 'coproduct',
  '∑': 'sum',
  '−': 'mi',
  '∓': '-+',
  '∗': '**',
  '√': 'sr',
  '∝': 'pt',
  '∞': 'if',
  '∠': '/_',
  '∧': 'AN',
  '∨': 'OR',
  '∩': 'ca',
  '∪': 'cu',
  '∫': 'is',
  '∴': 'tf',
  '∼': 'ap',
  '≃': '|=',
  '≅': '=~',
  '≈': '~~',
  '≡': '==',
  '≢': 'ne',
  '≤': '<=',
  '≥': '>=',
  '≪': '>>',
  '≫': '<<',
  '⊂': 'sb',
  '⊄': 'nb',
  '⊃': 'sp',
  '⊅': 'nc',
  '⊆': 'ib',
  '⊇': 'ip',
  '⊕': 'c+',
  '⊗': 'c*',
  '⊥': 'pp',
  '⋅': 'md',
  '⌈': 'lc',
  '⌉': 'rc',
  '⌊': 'lf',
  '⌋': 'rf',
  '⎛': 'parenlefttp',
  '⎜': 'parenleftex',
  '⎝': 'parenleftbt',
  '⎞': 'parenrighttp',
  '⎟': 'parenrightex',
  '⎠': 'parenrightbt',
  '⎢': 'bracketleftex',
  '⎥': 'bracketrightex',
  '⎧': 'lt',
  '⎨': 'lk',
  '⎩': 'lb',
  '⎪': 'bv',
  '⎫': 'rt',
  '⎬': 'rk',
  '⎭': 'rb',
  '⎯': 'an',
  '│': 'br',
  '□': 'sq',
  '◊': 'lz',
  '○': 'ci',
  '☜': 'lh',
  '☞': 'rh',
  '♠': 'SP',
  '♣': 'CL',
  '♥': 'HE',
  '♦': 'DI',
  '✓': 'OK',
  '⟨': 'la',
  '⟩': 'ra'
}
