/**
 * ./src/classes/cli-autologin.ts
 * penguins-eggs v.25.12.8 / ecmascript 2020
 * author: Piero Proietti
 * modified by: Hossein Seilani
 * license: MIT
 */
export default class CliAutologin {
    /**
     *
     * @param distro
     * @param version
     * @param user
     * @param userPasswd
     * @param rootPasswd
     * @param chroot
     */
    add(distro: string, version: string, user: string, userPasswd: string, rootPasswd: string, chroot?: string): Promise<void>;
    /**
     *
     * @param distro
     * @param version
     * @param user
     * @param userPasswd
     * @param rootPasswd
     * @param chroot
     */
    addIssue(distro: string, version: string, user: string, userPasswd: string, rootPasswd: string, chroot?: string): Promise<void>;
    /**
     *
     * @param distro
     * @param version
     * @param user
     * @param userPasswd
     * @param rootPasswd
     * @param chroot
     */
    addMotd(distro: string, version: string, user: string, userPasswd: string, rootPasswd: string, chroot?: string): Promise<void>;
    /**
     * remove()
     * Rimuove qualsiasi configurazione di autologin (Systemd, OpenRC, SysVinit).
     * Pulisce sia i target specifici (tty1) che quelli globali per evitare conflitti.
     * @param chroot - Il percorso della root del sistema (default: '/')
     */
    remove(chroot?: string): Promise<void>;
    private msgRemove;
}
