/** @file
 *
 * C99 common FSP definitions from
 * Intel Firmware Support Package External Architecture Specification v2.0
 *
 * These definitions come in a format that is usable outside an EFI environment.
 **/
#ifndef FSP_H_C99_H
#define FSP_H_C99_H

#include <fsp/upd.h>
#include <stdint.h>

enum {
	FSP_STATUS_RESET_REQUIRED_COLD		= 0x40000001,
	FSP_STATUS_RESET_REQUIRED_WARM		= 0x40000002,
	FSP_STATUS_RESET_REQUIRED_3		= 0x40000003,
	FSP_STATUS_RESET_REQUIRED_4		= 0x40000004,
	FSP_STATUS_RESET_REQUIRED_5		= 0x40000005,
	FSP_STATUS_RESET_REQUIRED_6		= 0x40000006,
	FSP_STATUS_RESET_REQUIRED_7		= 0x40000007,
	FSP_STATUS_RESET_REQUIRED_8		= 0x40000008,
};

typedef enum {
	EnumInitPhaseAfterPciEnumeration	= 0x20,
	EnumInitPhaseReadyToBoot		= 0x40,
	EnumInitPhaseEndOfFirmware		= 0xF0
} FSP_INIT_PHASE;

#endif /* FSP_H_C99_H */
